/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.variable.service.impl;

import java.util.List;
import java.util.Set;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandExecutor;
import org.flowable.common.engine.impl.query.AbstractQuery;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.runtime.VariableInstanceQuery;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.HistoricVariableInstanceQueryProperty;
import org.flowable.variable.service.impl.QueryOperator;
import org.flowable.variable.service.impl.QueryVariableValue;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;
import org.flowable.variable.service.impl.types.CacheableVariable;

public class VariableInstanceQueryImpl
extends AbstractQuery<VariableInstanceQuery, VariableInstance>
implements VariableInstanceQuery {
    private static final long serialVersionUID = 1L;
    protected VariableServiceConfiguration variableServiceConfiguration;
    protected String id;
    protected String taskId;
    protected Set<String> taskIds;
    protected String executionId;
    protected Set<String> executionIds;
    protected String processInstanceId;
    protected String activityInstanceId;
    protected String variableName;
    protected String variableNameLike;
    protected boolean excludeTaskRelated;
    protected boolean excludeVariableInitialization;
    protected String scopeId;
    protected String subScopeId;
    protected String scopeType;
    protected QueryVariableValue queryVariableValue;
    protected boolean excludeLocalVariables;

    public VariableInstanceQueryImpl() {
    }

    public VariableInstanceQueryImpl(CommandContext commandContext, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandContext);
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public VariableInstanceQueryImpl(CommandExecutor commandExecutor, VariableServiceConfiguration variableServiceConfiguration) {
        super(commandExecutor);
        this.variableServiceConfiguration = variableServiceConfiguration;
    }

    public VariableInstanceQuery id(String id) {
        this.id = id;
        return this;
    }

    public VariableInstanceQueryImpl processInstanceId(String processInstanceId) {
        if (processInstanceId == null) {
            throw new FlowableIllegalArgumentException("processInstanceId is null");
        }
        this.processInstanceId = processInstanceId;
        return this;
    }

    public VariableInstanceQueryImpl executionId(String executionId) {
        if (executionId == null) {
            throw new FlowableIllegalArgumentException("Execution id is null");
        }
        if (this.excludeLocalVariables) {
            throw new FlowableIllegalArgumentException("Cannot use executionId together with excludeLocalVariables");
        }
        this.executionId = executionId;
        return this;
    }

    public VariableInstanceQueryImpl executionIds(Set<String> executionIds) {
        if (executionIds == null) {
            throw new FlowableIllegalArgumentException("executionIds is null");
        }
        if (executionIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of executionIds is empty");
        }
        if (this.excludeLocalVariables) {
            throw new FlowableIllegalArgumentException("Cannot use executionIds together with excludeLocalVariables");
        }
        this.executionIds = executionIds;
        return this;
    }

    public VariableInstanceQuery activityInstanceId(String activityInstanceId) {
        this.activityInstanceId = activityInstanceId;
        return this;
    }

    public VariableInstanceQuery taskId(String taskId) {
        if (taskId == null) {
            throw new FlowableIllegalArgumentException("taskId is null");
        }
        if (this.excludeTaskRelated) {
            throw new FlowableIllegalArgumentException("Cannot use taskId together with excludeTaskVariables");
        }
        if (this.excludeLocalVariables) {
            throw new FlowableIllegalArgumentException("Cannot use taskIds together with excludeLocalVariables");
        }
        this.taskId = taskId;
        return this;
    }

    public VariableInstanceQueryImpl taskIds(Set<String> taskIds) {
        if (taskIds == null) {
            throw new FlowableIllegalArgumentException("taskIds is null");
        }
        if (taskIds.isEmpty()) {
            throw new FlowableIllegalArgumentException("Set of taskIds is empty");
        }
        if (this.excludeTaskRelated) {
            throw new FlowableIllegalArgumentException("Cannot use taskIds together with excludeTaskVariables");
        }
        if (this.excludeLocalVariables) {
            throw new FlowableIllegalArgumentException("Cannot use taskIds together with excludeLocalVariables");
        }
        this.taskIds = taskIds;
        return this;
    }

    public VariableInstanceQuery excludeTaskVariables() {
        if (this.taskId != null) {
            throw new FlowableIllegalArgumentException("Cannot use taskId together with excludeTaskVariables");
        }
        if (this.taskIds != null) {
            throw new FlowableIllegalArgumentException("Cannot use taskIds together with excludeTaskVariables");
        }
        this.excludeTaskRelated = true;
        return this;
    }

    public VariableInstanceQuery excludeVariableInitialization() {
        this.excludeVariableInitialization = true;
        return this;
    }

    public VariableInstanceQuery variableName(String variableName) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        this.variableName = variableName;
        return this;
    }

    public VariableInstanceQuery variableValueEquals(String variableName, Object variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.EQUALS, true);
        return this;
    }

    public VariableInstanceQuery variableValueNotEquals(String variableName, Object variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.NOT_EQUALS, true);
        return this;
    }

    public VariableInstanceQuery variableValueLike(String variableName, String variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue, QueryOperator.LIKE, true);
        return this;
    }

    public VariableInstanceQuery variableValueLikeIgnoreCase(String variableName, String variableValue) {
        if (variableName == null) {
            throw new FlowableIllegalArgumentException("variableName is null");
        }
        if (variableValue == null) {
            throw new FlowableIllegalArgumentException("variableValue is null");
        }
        this.variableName = variableName;
        this.queryVariableValue = new QueryVariableValue(variableName, variableValue.toLowerCase(), QueryOperator.LIKE_IGNORE_CASE, true);
        return this;
    }

    public VariableInstanceQuery variableNameLike(String variableNameLike) {
        if (variableNameLike == null) {
            throw new FlowableIllegalArgumentException("variableNameLike is null");
        }
        this.variableNameLike = variableNameLike;
        return this;
    }

    public VariableInstanceQuery scopeId(String scopeId) {
        this.scopeId = scopeId;
        return this;
    }

    public VariableInstanceQuery subScopeId(String subScopeId) {
        if (this.excludeLocalVariables) {
            throw new FlowableIllegalArgumentException("Cannot use subScopeId together with excludeLocalVariables");
        }
        this.subScopeId = subScopeId;
        return this;
    }

    public VariableInstanceQuery scopeType(String scopeType) {
        this.scopeType = scopeType;
        return this;
    }

    public VariableInstanceQuery excludeLocalVariables() {
        if (this.taskId != null) {
            throw new FlowableIllegalArgumentException("Cannot use taskId together with excludeLocalVariables");
        }
        if (this.taskIds != null) {
            throw new FlowableIllegalArgumentException("Cannot use taskIds together with excludeLocalVariables");
        }
        if (this.executionId != null) {
            throw new FlowableIllegalArgumentException("Cannot use executionId together with excludeLocalVariables");
        }
        if (this.subScopeId != null) {
            throw new FlowableIllegalArgumentException("Cannot use subScopeId together with excludeLocalVariables");
        }
        this.excludeLocalVariables = true;
        return this;
    }

    protected void ensureVariablesInitialized() {
        if (this.queryVariableValue != null) {
            this.queryVariableValue.initialize(this.variableServiceConfiguration);
        }
    }

    public long executeCount(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        return this.variableServiceConfiguration.getVariableInstanceEntityManager().findVariableInstanceCountByQueryCriteria(this);
    }

    public List<VariableInstance> executeList(CommandContext commandContext) {
        this.ensureVariablesInitialized();
        List<VariableInstance> variableInstances = this.variableServiceConfiguration.getVariableInstanceEntityManager().findVariableInstancesByQueryCriteria(this);
        if (!this.excludeVariableInitialization) {
            for (VariableInstance variableInstance : variableInstances) {
                VariableInstanceEntity variableEntity;
                if (!(variableInstance instanceof VariableInstanceEntity) || (variableEntity = (VariableInstanceEntity)variableInstance).getType() == null) continue;
                variableEntity.getValue();
                if (!"jpa-entity".equals(variableEntity.getType().getTypeName()) && !"jpa-entity-list".equals(variableEntity.getType().getTypeName())) continue;
                ((CacheableVariable)variableEntity.getType()).setForceCacheable(true);
            }
        }
        return variableInstances;
    }

    public VariableInstanceQuery orderByProcessInstanceId() {
        this.orderBy(HistoricVariableInstanceQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    public VariableInstanceQuery orderByVariableName() {
        this.orderBy(HistoricVariableInstanceQueryProperty.VARIABLE_NAME);
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public boolean getExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String getVariableNameLike() {
        return this.variableNameLike;
    }

    public String getScopeId() {
        return this.scopeId;
    }

    public String getSubScopeId() {
        return this.subScopeId;
    }

    public String getScopeType() {
        return this.scopeType;
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getTaskIds() {
        return this.taskIds;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Set<String> getExecutionIds() {
        return this.executionIds;
    }

    public boolean isExcludeTaskRelated() {
        return this.excludeTaskRelated;
    }

    public boolean isExcludeVariableInitialization() {
        return this.excludeVariableInitialization;
    }

    public QueryVariableValue getQueryVariableValue() {
        return this.queryVariableValue;
    }

    public boolean isExcludeLocalVariables() {
        return this.excludeLocalVariables;
    }
}

