/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.javax.el;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELException;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.common.engine.impl.javax.el.ExpressionFactory;
import org.flowable.common.engine.impl.javax.el.MethodNotFoundException;
import org.flowable.common.engine.impl.javax.el.PropertyNotWritableException;
import org.flowable.common.engine.impl.javax.el.Util;

public class BeanELResolver
extends ELResolver {
    private final boolean readOnly;
    private final ConcurrentHashMap<Class<?>, BeanProperties> cache;
    private ExpressionFactory defaultFactory;

    public BeanELResolver() {
        this(false);
    }

    public BeanELResolver(boolean readOnly) {
        this.readOnly = readOnly;
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return this.isResolvable(base) ? Object.class : null;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isResolvable(base)) {
            PropertyDescriptor[] properties;
            try {
                properties = Introspector.getBeanInfo(base.getClass()).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                return Collections.emptyList().iterator();
            }
            return new Iterator<FeatureDescriptor>(){
                int next = 0;

                @Override
                public boolean hasNext() {
                    return properties != null && this.next < properties.length;
                }

                @Override
                public FeatureDescriptor next() {
                    PropertyDescriptor property = properties[this.next++];
                    FeatureDescriptor feature = new FeatureDescriptor();
                    feature.setDisplayName(property.getDisplayName());
                    feature.setName(property.getName());
                    feature.setShortDescription(property.getShortDescription());
                    feature.setExpert(property.isExpert());
                    feature.setHidden(property.isHidden());
                    feature.setPreferred(property.isPreferred());
                    feature.setValue("type", property.getPropertyType());
                    feature.setValue("resolvableAtDesignTime", true);
                    return feature;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("cannot remove");
                }
            };
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        BeanProperty beanProperty;
        if (context == null) {
            throw new NullPointerException();
        }
        Class<?> result = null;
        if (this.isResolvable(base) && (beanProperty = this.toBeanProperty(base, property)) != null && (result = beanProperty.getPropertyType()) != null) {
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Method method;
        BeanProperty beanProperty;
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (this.isResolvable(base) && (beanProperty = this.toBeanProperty(base, property)) != null && (method = beanProperty.getReadMethod(base)) != null) {
            try {
                result = this.invoke(method, base, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw new ELException(e.getCause());
            }
            catch (Exception e) {
                throw new ELException(e);
            }
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        BeanProperty beanProperty;
        if (context == null) {
            throw new NullPointerException();
        }
        boolean result = this.readOnly;
        if (this.isResolvable(base) && (beanProperty = this.toBeanProperty(base, property)) != null) {
            result |= beanProperty.isReadOnly(base);
            context.setPropertyResolved(true);
        }
        return result;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (this.isResolvable(base)) {
            if (this.readOnly) {
                throw new PropertyNotWritableException("resolver is read-only");
            }
            BeanProperty beanProperty = this.toBeanProperty(base, property);
            if (beanProperty != null) {
                Method method = beanProperty.getWriteMethod(base);
                if (method == null) {
                    throw new PropertyNotWritableException("Cannot write property: " + property);
                }
                try {
                    this.invoke(method, base, value);
                }
                catch (InvocationTargetException e) {
                    throw new ELException("Cannot write property: " + property, e.getCause());
                }
                catch (IllegalArgumentException e) {
                    throw new ELException("Cannot write property: " + property, e);
                }
                catch (IllegalAccessException e) {
                    throw new PropertyNotWritableException("Cannot write property: " + property, e);
                }
                context.setPropertyResolved(true);
            }
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (context == null) {
            throw new NullPointerException();
        }
        Object result = null;
        if (this.isResolvable(base)) {
            if (params == null) {
                params = new Object[]{};
            }
            String name = method.toString();
            ExpressionFactory factory = this.getExpressionFactory(context);
            Method target = Util.findMethod(base.getClass(), base, name, paramTypes, params, factory);
            if (target == null) {
                throw new MethodNotFoundException("Cannot find method " + name + " with " + params.length + " parameters in " + base.getClass());
            }
            Object[] parameters = Util.buildParameters(target.getParameterTypes(), target.isVarArgs(), params, factory);
            try {
                result = this.invoke(target, base, parameters);
            }
            catch (InvocationTargetException e) {
                throw new ELException(e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new ELException(e);
            }
            context.setPropertyResolved(true);
        }
        return result;
    }

    protected Object invoke(Method target, Object base, Object ... parameters) throws InvocationTargetException, IllegalAccessException {
        return target.invoke(base, parameters);
    }

    private ExpressionFactory getExpressionFactory(ELContext context) {
        Object obj = context.getContext(ExpressionFactory.class);
        if (obj instanceof ExpressionFactory) {
            return (ExpressionFactory)obj;
        }
        if (this.defaultFactory == null) {
            this.defaultFactory = ExpressionFactory.newInstance();
        }
        return this.defaultFactory;
    }

    private final boolean isResolvable(Object base) {
        return base != null;
    }

    private final BeanProperty toBeanProperty(Object base, Object property) {
        BeanProperties beanProperties = this.cache.get(base.getClass());
        if (beanProperties == null) {
            BeanProperties newBeanProperties = new BeanProperties(base.getClass());
            beanProperties = this.cache.putIfAbsent(base.getClass(), newBeanProperties);
            if (beanProperties == null) {
                beanProperties = newBeanProperties;
            }
        }
        BeanProperty beanProperty = property == null ? null : beanProperties.getBeanProperty(property.toString());
        return beanProperty;
    }

    private final void purgeBeanClasses(ClassLoader loader) {
        Iterator classes = ((ConcurrentHashMap.KeySetView)this.cache.keySet()).iterator();
        while (classes.hasNext()) {
            if (loader != ((Class)classes.next()).getClassLoader()) continue;
            classes.remove();
        }
    }

    protected static final class BeanProperty {
        private final Class<?> owner;
        private final PropertyDescriptor descriptor;
        private Method readMethod;
        private Method writedMethod;

        public BeanProperty(Class<?> owner, PropertyDescriptor descriptor) {
            this.owner = owner;
            this.descriptor = descriptor;
        }

        public Class<?> getPropertyType() {
            return this.descriptor.getPropertyType();
        }

        public Method getReadMethod(Object base) {
            if (this.readMethod == null) {
                this.readMethod = Util.getMethod(this.owner, base, this.descriptor.getReadMethod());
            }
            return this.readMethod;
        }

        public Method getWriteMethod(Object base) {
            if (this.writedMethod == null) {
                this.writedMethod = Util.getMethod(this.owner, base, this.descriptor.getWriteMethod());
            }
            return this.writedMethod;
        }

        public boolean isReadOnly(Object base) {
            return this.getWriteMethod(base) == null;
        }
    }

    protected static final class BeanProperties {
        private final Map<String, BeanProperty> map = new HashMap<String, BeanProperty>();

        public BeanProperties(Class<?> baseClass) {
            PropertyDescriptor[] descriptors;
            try {
                descriptors = Introspector.getBeanInfo(baseClass).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                throw new ELException(e);
            }
            for (PropertyDescriptor descriptor : descriptors) {
                this.map.put(descriptor.getName(), new BeanProperty(baseClass, descriptor));
            }
        }

        public BeanProperty getBeanProperty(String property) {
            return this.map.get(property);
        }
    }
}

