/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.security;

import com.greenpineyu.fel.Fel;
import com.greenpineyu.fel.context.Var;
import com.greenpineyu.fel.security.SecurityMgr;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexSecurityMgr
implements SecurityMgr {
    private Map<String, Pattern> callableMap = new HashMap<String, Pattern>();
    private Map<String, Pattern> uncallableMap = new HashMap<String, Pattern>();

    public RegexSecurityMgr(Set<String> callables, Set<String> uncallables) {
        this.convert(callables, this.callableMap);
        this.convert(uncallables, this.uncallableMap);
    }

    private void convert(Set<String> src, Map<String, Pattern> dest) {
        if (src == null) {
            return;
        }
        for (String reg : src) {
            Pattern pattern = Pattern.compile(this.toRegex(reg));
            dest.put(reg, pattern);
        }
    }

    private String toRegex(String regex) {
        char[] chars = regex.toCharArray();
        StringBuilder sb = new StringBuilder("^");
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '.': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '*': {
                    sb.append(".*");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append("$");
        return sb.toString();
    }

    private String getSignature(Method m) {
        StringBuilder name = new StringBuilder();
        Class<?> cls = m.getDeclaringClass();
        name.append(cls.getCanonicalName()).append(".");
        name.append(m.getName()).append("(");
        Class<?>[] params = m.getParameterTypes();
        int i = 0;
        while (i < params.length) {
            Class<?> paramCls = params[i];
            String canonicalName = paramCls.getCanonicalName();
            if (canonicalName.startsWith("java.lang")) {
                canonicalName = canonicalName.substring(canonicalName.lastIndexOf(".") + 1);
            }
            name.append(canonicalName);
            if (i < params.length - 1) {
                name.append(",");
            }
            ++i;
        }
        name.append(")");
        return name.toString();
    }

    private boolean isMatch(Map<String, Pattern> m, String input) {
        for (Map.Entry<String, Pattern> entry : m.entrySet()) {
            if (!entry.getValue().matcher(input).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCallable(Method m) {
        String method = this.getSignature(m);
        if (this.isMatch(this.uncallableMap, method)) {
            return false;
        }
        if (this.callableMap.isEmpty()) {
            return true;
        }
        return this.isMatch(this.callableMap, method);
    }

    public static void main(String[] args) {
        Fel.eval("$(System).exit(1)", new Var[0]);
    }
}

