/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.Expression;
import com.greenpineyu.fel.common.ArrayUtils;
import com.greenpineyu.fel.common.Null;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.CommonFunction;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.parser.FelNode;
import com.greenpineyu.fel.security.SecurityMgr;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dot
implements Function {
    private SecurityMgr securityMgr;
    static final Map<Class<?>, Class<?>> PRIMITIVE_TYPES = new HashMap();
    public static final String DOT = ".";

    static {
        PRIMITIVE_TYPES.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_TYPES.put(Byte.class, Byte.TYPE);
        PRIMITIVE_TYPES.put(Character.class, Character.TYPE);
        PRIMITIVE_TYPES.put(Double.class, Double.TYPE);
        PRIMITIVE_TYPES.put(Float.class, Float.TYPE);
        PRIMITIVE_TYPES.put(Integer.class, Integer.TYPE);
        PRIMITIVE_TYPES.put(Long.class, Long.TYPE);
        PRIMITIVE_TYPES.put(Short.class, Short.TYPE);
    }

    public SecurityMgr getSecurityMgr() {
        return this.securityMgr;
    }

    public void setSecurityMgr(SecurityMgr securityMgr) {
        this.securityMgr = securityMgr;
    }

    @Override
    public String getName() {
        return DOT;
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        String methodName;
        FelNode right;
        List<FelNode> children = node.getChildren();
        Object left = children.get(0);
        if (left instanceof Expression) {
            Expression exp = (Expression)left;
            left = exp.eval(context);
        }
        FelNode exp = right = children.get(1);
        Class[] argsType = new Class[]{};
        Object[] args = CommonFunction.evalArgs(right, context);
        if (!ArrayUtils.isEmpty(args)) {
            argsType = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argsType[i] = args[i] == null ? Null.class : args[i].getClass();
                ++i;
            }
        }
        Method method = null;
        Class<?> cls = left instanceof Class ? (Class<?>)left : left.getClass();
        method = this.findMethod(cls, methodName = right.getText(), argsType);
        if (method == null) {
            String getMethod = "get";
            method = this.findMethod(cls, getMethod, new Class[]{String.class});
            args = new Object[]{exp.getText()};
        }
        if (method != null) {
            return Dot.invoke(left, method, args);
        }
        return null;
    }

    private Method findMethod(Class<?> cls, String methodName, Class<?>[] argsType) {
        Method method = ReflectUtil.findMethod(cls, methodName, argsType);
        return this.getCallableMethod(method);
    }

    private Method getMethod(Class<?> cls, String methodName, Class<?>[] argsType) {
        Method method = ReflectUtil.getMethod(cls, methodName, argsType);
        return this.getCallableMethod(method);
    }

    private Method getCallableMethod(Method m) {
        if (m == null || this.securityMgr.isCallable(m)) {
            return m;
        }
        throw new SecurityException("\u5b89\u5168\u7ba1\u7406\u5668[" + this.securityMgr.getClass().getSimpleName() + "]\u7981\u6b62\u8c03\u7528\u65b9\u6cd5[" + m.toString() + "]");
    }

    public static Object invoke(Object obj, Method method, Object[] args) {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public FelMethod toMethod(FelNode node, FelContext context) {
        StringBuilder sb = new StringBuilder();
        List<FelNode> children = node.getChildren();
        FelNode l = children.get(0);
        SourceBuilder leftMethod = l.toMethod(context);
        Class<?> cls = leftMethod.returnType(context, l);
        String leftSrc = leftMethod.source(context, l);
        if (cls.isPrimitive()) {
            Class<?> wrapperClass = ReflectUtil.toWrapperClass(cls);
            sb.append("((").append(wrapperClass.getSimpleName()).append(")").append(leftSrc).append(")");
        } else {
            sb.append(leftSrc);
        }
        sb.append(DOT);
        Method method = null;
        FelNode rightNode = children.get(1);
        List<FelNode> params = rightNode.getChildren();
        ArrayList<SourceBuilder> paramMethods = new ArrayList<SourceBuilder>();
        Class[] paramValueTypes = null;
        boolean hasParam = params != null && !params.isEmpty();
        String rightMethod = rightNode.getText();
        String rightMethodParam = "";
        if (hasParam) {
            paramValueTypes = new Class[params.size()];
            int i = 0;
            while (i < params.size()) {
                FelNode p = params.get(i);
                SourceBuilder paramMethod = p.toMethod(context);
                paramMethods.add(paramMethod);
                paramValueTypes[i] = paramMethod.returnType(context, p);
                ++i;
            }
            method = this.findMethod(cls, rightNode.getText(), paramValueTypes);
            if (method != null) {
                Class<?>[] paramTypes = method.getParameterTypes();
                int i2 = 0;
                while (i2 < paramTypes.length) {
                    Class<?> paramType = paramTypes[i2];
                    FelNode p = params.get(i2);
                    String paramCode = Dot.getParamCode(paramType, p, context);
                    rightMethodParam = String.valueOf(rightMethodParam) + paramCode + ",";
                    ++i2;
                }
                rightMethod = method.getName();
            }
        } else {
            method = this.findMethod(cls, rightNode.getText(), new Class[0]);
            if (method == null) {
                method = this.getMethod(cls, "get", new Class[]{String.class});
                if (method != null) {
                    rightMethod = "get";
                    rightMethodParam = "\"" + rightNode.getText() + "\"";
                }
            } else {
                rightMethod = method.getName();
            }
        }
        if (rightMethodParam.endsWith(",")) {
            rightMethodParam = rightMethodParam.substring(0, rightMethodParam.length() - 1);
        }
        rightMethod = String.valueOf(rightMethod) + "(" + rightMethodParam + ")";
        sb.append(rightMethod);
        FelMethod returnMe = new FelMethod(method == null ? null : method.getReturnType(), sb.toString());
        return returnMe;
    }

    public static String getParamCode(Class<?> paramType, FelNode node, FelContext ctx) {
        String paramCode = "";
        SourceBuilder paramMethod = node.toMethod(ctx);
        Class<?> paramValueType = paramMethod.returnType(ctx, node);
        if (ReflectUtil.isTypeMatch(paramType, paramValueType)) {
            paramCode = paramMethod.source(ctx, node);
        } else {
            String className = null;
            Class<?> wrapperClass = ReflectUtil.toWrapperClass(paramType);
            className = wrapperClass != null ? wrapperClass.getName() : paramType.getName();
            paramCode = "(" + className + ")" + paramMethod.source(ctx, node);
        }
        return paramCode;
    }
}

