/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.Null;
import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.exception.EvalException;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.function.TolerantFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class And
extends StableFunction {
    public String toJavaOper() {
        return this.getName();
    }

    @Override
    public Object call(FelNode node, FelContext context) {
        List<FelNode> children = node.getChildren();
        if (children != null && children.size() == 2) {
            return this.logic(context, children);
        }
        throw new EvalException("\u4f20\u5165\u53c2\u6570\u6570\u7ec4\u4e3a\u7a7a\u6216\u8005\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e!");
    }

    Boolean logic(FelContext context, List<FelNode> children) {
        Boolean leftValue = this.toBoolean(context, children.get(0));
        if (!leftValue.booleanValue()) {
            return leftValue;
        }
        return this.toBoolean(context, children.get(1));
    }

    Boolean toBoolean(FelContext context, Object node) {
        node = TolerantFunction.eval(context, node);
        return NumberUtil.toBooleanObj(node);
    }

    @Override
    public String getName() {
        return "&&";
    }

    @Override
    public FelMethod toMethod(FelNode node, FelContext ctx) {
        String code = String.valueOf(this.toBoolean(node, ctx, 0)) + this.toJavaOper() + this.toBoolean(node, ctx, 1);
        return new FelMethod(Boolean.class, code);
    }

    public String toBoolean(FelNode node, FelContext ctx, int index) {
        List<FelNode> children = node.getChildren();
        FelNode child = children.get(index);
        SourceBuilder method = child.toMethod(ctx);
        Class<?> type = method.returnType(ctx, child);
        if (Boolean.class.isAssignableFrom(type)) {
            return "(" + method.source(ctx, child) + ")";
        }
        if (String.class.isAssignableFrom(type)) {
            return "Boolean.valueOf(" + method.source(ctx, child) + ")";
        }
        if (Null.class.isAssignableFrom(type)) {
            return "false";
        }
        return "false";
    }
}

