/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function.operator;

import com.greenpineyu.fel.common.NumberUtil;
import com.greenpineyu.fel.common.ObjectUtils;
import com.greenpineyu.fel.common.ReflectUtil;
import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.StableFunction;
import com.greenpineyu.fel.parser.FelNode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class Add
extends StableFunction {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    /*
     * WARNING - void declaration
     */
    public Object call(FelNode node, FelContext context) {
        Object returnMe = null;
        for (FelNode felNode : node.getChildren()) {
            Object r;
            void var5_5;
            if (felNode instanceof FelNode) {
                FelNode childNode = felNode;
                Object object = childNode.eval(context);
            }
            if (var5_5 instanceof String) {
                if (returnMe == null) {
                    returnMe = var5_5;
                    continue;
                }
                returnMe = String.valueOf(returnMe) + (String)var5_5;
            }
            if (!(var5_5 instanceof Number)) continue;
            if (returnMe == null) {
                returnMe = var5_5;
                continue;
            }
            Number value = (Number)var5_5;
            if (returnMe instanceof Number) {
                r = (Number)returnMe;
                returnMe = NumberUtil.toDouble((Number)r) + NumberUtil.toDouble(value);
                continue;
            }
            if (!(returnMe instanceof String)) continue;
            r = (String)returnMe;
            returnMe = String.valueOf(r) + value;
        }
        if (returnMe instanceof Number) {
            return NumberUtil.parseNumber(returnMe.toString());
        }
        return returnMe;
    }

    public String getName() {
        return "+";
    }

    public FelMethod toMethod(FelNode node, FelContext ctx) {
        Class<Object> type = null;
        List<FelNode> children = node.getChildren();
        StringBuilder sb = new StringBuilder();
        if (children.size() == 2) {
            FelNode left = children.get(0);
            SourceBuilder lm = left.toMethod(ctx);
            this.appendArg(sb, lm, ctx, left);
            Class<?> leftType = lm.returnType(ctx, left);
            FelNode right = children.get(1);
            sb.append("+");
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            type = CharSequence.class.isAssignableFrom(leftType) ? leftType : (CharSequence.class.isAssignableFrom(rightType) ? rightType : (ReflectUtil.isPrimitiveOrWrapNumber(leftType) && ReflectUtil.isPrimitiveOrWrapNumber(rightType) ? NumberUtil.arithmeticClass(leftType, rightType) : String.class));
            this.appendArg(sb, rm, ctx, right);
        } else if (children.size() == 1) {
            FelNode right = children.get(0);
            SourceBuilder rm = right.toMethod(ctx);
            Class<?> rightType = rm.returnType(ctx, right);
            if (ReflectUtil.isPrimitiveOrWrapNumber(rightType)) {
                this.appendArg(sb, rm, ctx, right);
            }
            type = rightType;
        }
        FelMethod m = new FelMethod(type, sb.toString());
        return m;
    }

    private void appendArg(StringBuilder sb, SourceBuilder argMethod, FelContext ctx, FelNode node) {
        Class<?> t = argMethod.returnType(ctx, node);
        sb.append("(");
        if (ReflectUtil.isPrimitiveOrWrapNumber(t) || CharSequence.class.isAssignableFrom(t)) {
            sb.append(argMethod.source(ctx, node));
        } else {
            sb.append("ObjectUtils.toString(").append(argMethod.source(ctx, node)).append(")");
        }
        sb.append(")");
    }

    public static Object add(Object left, Object right) {
        if (left == null || right == null) {
            throw new NullPointerException("\u8c03\u7528add()\u65b9\u6cd5\u51fa\u9519\uff01,\u539f\u56e0\uff1a\u5f53\u524d\u53c2\u6570\u4e3a\u7a7a");
        }
        try {
            if (left instanceof Object[]) {
                left = NumberUtil.calArray(left);
            }
            if (right instanceof Object[]) {
                right = NumberUtil.calArray(right);
            }
            if (NumberUtil.isFloatingPointNumber(left) || NumberUtil.isFloatingPointNumber(right)) {
                double l = NumberUtil.toDouble(left);
                double r = NumberUtil.toDouble(right);
                return new Double(l + r);
            }
            if (left instanceof BigInteger && right instanceof BigInteger) {
                BigInteger l = NumberUtil.toBigInteger(left);
                BigInteger r = NumberUtil.toBigInteger(right);
                return l.add(r);
            }
            if (left instanceof BigDecimal || right instanceof BigDecimal) {
                BigDecimal l = NumberUtil.toBigDecimal(left);
                BigDecimal r = NumberUtil.toBigDecimal(right);
                return l.add(r);
            }
            if (left instanceof String && right instanceof Date) {
                return left + DATE_FORMAT.format((Date)right);
            }
            if (left instanceof Date && right instanceof String) {
                return String.valueOf(DATE_FORMAT.format((Date)left)) + right;
            }
            BigInteger l = NumberUtil.toBigInteger(left);
            BigInteger r = NumberUtil.toBigInteger(right);
            BigInteger result = l.add(r);
            return NumberUtil.narrowBigInteger(left, right, result);
        }
        catch (Exception e) {
            return ObjectUtils.toString(left).concat(ObjectUtils.toString(right));
        }
    }
}

