/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function;

import com.greenpineyu.fel.compile.FelMethod;
import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.compile.VarBuffer;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.function.CommonFunction;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.function.operator.Dot;
import com.greenpineyu.fel.parser.FelNode;
import java.lang.reflect.Method;
import java.util.List;

public class JavaMethod
implements Function {
    private String name;
    private Object obj;
    private Method method;

    public JavaMethod(String name, Method method, Object obj) {
        this.name = name;
        this.method = method;
        this.obj = obj;
    }

    public Object call(FelNode node, FelContext context) {
        Object[] args = CommonFunction.evalArgs(node, context);
        return Dot.invoke(this.obj, this.method, args);
    }

    public String getName() {
        return this.name;
    }

    public SourceBuilder toMethod(FelNode node, FelContext context) {
        StringBuilder code = new StringBuilder();
        String classOrObjCode = this.getClassOrObjCode();
        code.append(classOrObjCode);
        code.append(".");
        String methodName = this.method.getName();
        code.append(methodName);
        StringBuilder methodParams = this.getParamsCode(node, context);
        code.append("(").append((CharSequence)methodParams).append(")");
        FelMethod returnMe = new FelMethod(this.method.getReturnType(), code.toString());
        return returnMe;
    }

    private String getClassOrObjCode() {
        if (this.obj == null) {
            Class<?> cls = this.method.getDeclaringClass();
            return cls.getCanonicalName();
        }
        String varName = VarBuffer.push(this.obj);
        return varName;
    }

    private StringBuilder getParamsCode(FelNode node, FelContext context) {
        StringBuilder methodParams = new StringBuilder();
        List<FelNode> params = node.getChildren();
        boolean hasParam = params != null && !params.isEmpty();
        Class<?>[] paramTypes = this.method.getParameterTypes();
        if (hasParam) {
            int i = 0;
            while (i < paramTypes.length) {
                Class<?> paramType = paramTypes[i];
                FelNode p = params.get(i);
                String paramCode = Dot.getParamCode(paramType, p, context);
                methodParams.append(paramCode);
                if (i < paramTypes.length - 1) {
                    methodParams.append(",");
                }
                ++i;
            }
        }
        return methodParams;
    }

    public static void main(String[] args) throws SecurityException, NoSuchMethodException {
    }
}

