/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.function;

import com.greenpineyu.fel.function.Dollar;
import com.greenpineyu.fel.function.Function;
import com.greenpineyu.fel.function.operator.Add;
import com.greenpineyu.fel.function.operator.And;
import com.greenpineyu.fel.function.operator.CollectionGet;
import com.greenpineyu.fel.function.operator.Cond;
import com.greenpineyu.fel.function.operator.Div;
import com.greenpineyu.fel.function.operator.Dot;
import com.greenpineyu.fel.function.operator.Equal;
import com.greenpineyu.fel.function.operator.GreaterThan;
import com.greenpineyu.fel.function.operator.GreaterThenEqual;
import com.greenpineyu.fel.function.operator.LessThen;
import com.greenpineyu.fel.function.operator.LessThenEqual;
import com.greenpineyu.fel.function.operator.Mod;
import com.greenpineyu.fel.function.operator.Mul;
import com.greenpineyu.fel.function.operator.NotEqual;
import com.greenpineyu.fel.function.operator.NotOper;
import com.greenpineyu.fel.function.operator.Or;
import com.greenpineyu.fel.function.operator.Sub;
import java.util.HashMap;
import java.util.Map;

public class FunMgr {
    private Map<String, Function> userFunMap;
    private Map<String, Function> funcMap = new HashMap<String, Function>();

    public FunMgr() {
        this.addFun(new Dot());
        this.addFun(new CollectionGet());
        this.addFun(new Cond());
        this.addFun(new Dollar());
        this.addFun(new NotOper());
        this.addFun(new Add());
        this.addFun(new Sub());
        this.addFun(new Equal());
        this.addFun(new NotEqual());
        this.addFun(new Mul());
        this.addFun(new Div());
        this.addFun(new Mod());
        this.addFun(new LessThen());
        this.addFun(new LessThenEqual());
        this.addFun(new GreaterThan());
        this.addFun(new GreaterThenEqual());
        this.addFun(new And());
        this.addFun(new Or());
        this.userFunMap = new HashMap<String, Function>();
    }

    private void addFun(Function fun) {
        this.funcMap.put(fun.getName(), fun);
    }

    public Function getFun(String funName) {
        if (funName != null) {
            String newFunName = this.getLowerCaseName(funName);
            Function userFun = this.userFunMap.get(newFunName);
            if (userFun != null) {
                return userFun;
            }
            return this.funcMap.get(newFunName);
        }
        return null;
    }

    private String getLowerCaseName(String funName) {
        return funName.toLowerCase();
    }

    public void add(Function fun) {
        if (fun != null) {
            String name = fun.getName();
            if (name == null || "".equals(name)) {
                throw new IllegalArgumentException("\u51fd\u6570\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.userFunMap.put(this.getLowerCaseName(name), fun);
        }
    }

    public void remove(String name) {
        if (name != null) {
            this.userFunMap.remove(this.getLowerCaseName(name));
        }
    }
}

