/*
 * Decompiled with CFR 0.152.
 */
package com.greenpineyu.fel.compile;

import com.greenpineyu.fel.compile.SourceBuilder;
import com.greenpineyu.fel.compile.VarBuffer;
import com.greenpineyu.fel.context.AbstractContext;
import com.greenpineyu.fel.context.FelContext;
import com.greenpineyu.fel.interpreter.Interpreter;
import com.greenpineyu.fel.parser.FelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterSourceBuilder
implements SourceBuilder {
    private static final SourceBuilder instance = new InterpreterSourceBuilder();

    public static SourceBuilder getInstance() {
        return instance;
    }

    @Override
    public Class<?> returnType(FelContext ctx, FelNode node) {
        return AbstractContext.getVarType(node.getInterpreter().interpret(ctx, node));
    }

    @Override
    public String source(FelContext ctx, FelNode node) {
        Interpreter inte = node.getInterpreter();
        SourceBuilder nodeBuilder = node.toMethod(ctx);
        Class<?> type = nodeBuilder.returnType(ctx, node);
        String code = "(" + type.getName() + ")";
        String varName = VarBuffer.push(inte, Interpreter.class);
        String nodeVarName = VarBuffer.push(node, FelNode.class);
        code = String.valueOf(code) + varName + ".interpret(context," + nodeVarName + ")";
        boolean isNumber = Number.class.isAssignableFrom(type);
        if (isNumber) {
            code = "(" + code + ").doubleValue()";
        }
        return code;
    }
}

