/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eweb4j.util.xml.Attrs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tags {
    private String xml = null;
    private Boolean empty = false;
    private Collection<String> kps = new HashSet<String>();
    private Collection<String> rms = new HashSet<String>();

    public static void main(String[] args) {
        String html = "<p><strong>What You Get</strong></p>For $38 per pax, you get a 5D4N Beijing Guided Tour with International 5-Star Hotel Stays, Meals and 2 way Airport Transfer (worth $888).\t<a href=\"https://static.groupon.sg/97/77/1357554037797.jpg\" target=\"_blank\">View tour itinerary</a>.\t<p><strong>Deal Attractions</strong></p><p>Jump headfirst into the middle of the Middle Kingdom for the full experience \u2013 be filled to the gills with offerings of traditional Chinese cuisine and a bounty of sightseeing opportunities unique to the East.\t<img src=\"https://static.groupon.sg/60/36/1346664173660.jpg\" /></p>Enjoy a feast for the senses as well, with a tour around iconic attractions such as Tiananmen Square, The Forbidden City, Summer Place and the Great Wall of China. Tourists will trot through Tiananmen Square, a large city square at the center of Beijing named after the Tiananmen Gate that separates the Forbidden City with the rest of China.<img src=\"https://static.groupon.sg/15/67/1312803396715.jpg\" /> \the Forbidden City is the historic Chinese imperial palace that housed China\u2019s ancient dynasties: Juyongguan Great Wall, a series of stone fortifications that protected China from conquering nomadic tribes, and Olympic Village, an accommodation built for the premier athletes of the world during the 2008 Olympics.<img src=\"https://static.groupon.sg/62/88/1340596698862.jpg\" />\t<p>Indulge in a spot of retail therapy at Donghuamen night market and large departmental stores if conditions permit, and rest travel-weary feet in comfort at the 5-Star Xinyuan Hotel, with a coach and guide to keep from straying off the Great Wall into unfamiliar territory.</p><p><img src=\"https://static.groupon.sg/35/87/1340596698735.jpg\" /><img src=\"https://static.groupon.sg/30/91/1340596699130.jpg\" /></p>Before and after the guided tours, Groupon holders may walk at their own pace to visit the splendor of Beijing\u2019s streets or ride vintage sidecars to cover more land and see more sightseeables. Eating authentic Chinese cuisine and more shopping adventures may also be done along the way.<h2><font color=\"#0981be\"><img src=\"https://static.groupon.sg/48/23/1340603452348.jpg\" /></font></h2><img src=\"https://static.groupon.sg/55/32/1357876073255.jpg\" /> <map name=\"grouponsg_map\"> <area shape=\"rect\" coords=\" 355, 101, 462, 148\" href=\"http://www.groupon.sg/deals/singapore-exclusive?utm_source=banner&utm_medium=cp_sgx_side&utm_campaign=fbanners\" target=\"_blank\" /> <area shape=\"rect\" coords=\" 137, 92, 244, 140\" href=\"http://www.groupon.sg/deals/shopping?utm_source=banner&utm_medium=cp_goods&utm_campaign=fbanners\" target=\"_blank\" /> <area shape=\"rect\" coords=\" 211, 10, 319, 59\" href=\"http://www.groupon.sg/deals/singapore?utm_source=banner&utm_medium=cp_singapore&utm_campaign=fbanners\" target=\"_blank\" /> <area shape=\"rect\" coords=\" 23, 73, 129, 121\" href=\"http://www.groupon.sg/deals/deals-near-me?utm_source=banner&utm_medium=cp_nearme&utm_campaign=fbanners\" target=\"_blank\" /> <area shape=\"rect\" coords=\" 3, 4, 110, 53\" href=\"http://www.groupon.sg/deals/travel-deals?utm_source=banner&utm_medium=cp_travel&utm_campaign=fbanners\" target=\"_blank\" /> <area shape=\"default\" /> </map>";
        html = "<div>Tick off more than one city from your must-visit list of 2013 with today's Groupon to either Eastern or Western Europe. Choose between 2 options:<p><strong>What You Get</strong></p><ul><li>For $1,998 per pax, you get a 10D8N Eastern or Western Europe Tour via China Eastern Airlines (worth $2,888).</li><li>For $2,398 per pax, you get a 10D8N Eastern or Western Europe Tour via Singapore Airlines (worth $3,250).</li></ul><div>\tView Eastern Europe tour itinerary <a href=\"https://static.groupon.sg/60/45/1357723144560.jpg\" target=\"_blank\">page 1</a>, <a href=\"https://static.groupon.sg/99/34/1357724203499.jpg\" target=\"_blank\">page 2</a> & <a href=\"https://static.groupon.sg/89/47/1357723144789.jpg\" target=\"_blank\">page 3</a>.\tView Western Europe tour itinerary <a href=\"https://static.groupon.sg/75/68/1357723206875.jpg\" target=\"_blank\">page 1</a>, <a href=\"https://static.groupon.sg/95/69/1357723206995.jpg\" target=\"_blank\">page 2</a> & <a href=\"https://static.groupon.sg/12/71/1357723207112.jpg\" target=\"_blank\">page 3</a>.</div><p><strong>Deal Attractions</strong></p>Must-see on Europe's maps, faraway cities the likes of Prague, Frankfurt and Budapest are amongst the world's emerging capitals of cosmopolitan culture, enticing history and all-encompassing visual wonderment. Architectural splendours are commonplace on the streets of these fascinating cities, and each exhibits its own rendering of form and beauty with buildings dating back to the middle ages. <img src=\"https://static.groupon.sg/48/21/1357721932148.jpg\" />\t<em>Prague\t<img src=\"https://static.groupon.sg/70/21/1357721932170.jpg\" />\tVienna Opera House\t</em>In Prague, both the new and old parts of the city present a medley of urban wonders, with medieval lanes and Gothic and Renaissance buildings artfully spread throughout. Vienna, revered for its elegance, buzzes with alfresco diners and expansive greens once walked on by notable former residents such as Sigmund Freud. With its eclectic culture, famed Turkish baths and exciting nightlife, Budapest is centre of creativity and buzz that resides within impressive neoclassical and art nouveau walls. \t<em><img src=\"https://static.groupon.sg/90/21/1357721932190.jpg\" />\tBudapest</em>\tBetween transfers from one hotel to the next, Grouponers will be guided on an edifying journey through a comprehensive sightseeing tour of the old town and the new. Those who venture east will find themselves meandering through the land's notable landmarks, including the Vienna Concert Hall, The Palace of Buda Fisherman\u2019s Fort in Budapest and the well known ski city, Innsbruck, where the Winter Olympic Games was held in 1964 and 1976.\t<img src=\"https://static.groupon.sg/38/46/1357722274638.jpg\" />\t<em>Milan\t<img src=\"https://static.groupon.sg/62/46/1357722274662.jpg\" />\tLucerne\t<img src=\"https://static.groupon.sg/99/46/1357722274699.jpg\" />\tAmsterdam</em>\tThe tour of the west will similarly take guests on a voyage through streets resplendent in eclectic neoclassical and baroque influences, as well as beautiful parks and museums. These would include pit stops at fashion capital Milan, scenic Lucerne in Switzerland, and more familiar places like Paris and Amsterdam.<img src=\"https://static.groupon.sg/29/86/1354788668629.jpg\" />\tWith an knowledgeable tour guide shining the leading light for the full duration of the tour, and excursions, tours, inter-city transfers and breakfast each morning, Groupon galivanters will find most bases aptly covered in this truly once-in-a-lifetime Euro trip\t<h2> </h2><img src=\"https://static.groupon.sg/55/32/1357876073255.jpg\" /> </div>";
        System.out.println(Tags.me().xml(html).kp("h1").kp("h2").kp("h3").kp("h4").kp("h5").kp("h6").kp("table").kp("th").kp("tr").kp("td").kp("img").kp("p").kp("a").kp("ul").kp("ol").kp("li").kp("td").kp("em").kp("i").kp("u").kp("er").kp("b").kp("strong").ok());
    }

    public static void mains(String[] args) {
        String xml = "<div>This is div.</div><p>This is p.<ul><li>This is li.<a href='http://www.baidu.com'>This is link.</a></li></ul></p>";
        String rs = Tags.me().xml(xml).rm().ok();
        System.out.println("This is div.This is p.This is li.This is link.".equals(rs));
        String rs2 = Tags.me().xml(xml).rm("div", "a").empty().ok();
        System.out.println("<p>This is p.<ul><li>This is li.</li></ul></p>".equals(rs2));
        String kpRs = Tags.me().xml(xml).kp("p", "a").ok();
        System.out.println("This is div.<p>This is p.This is li.<a href='http://www.baidu.com'>This is link.</a></p>".equals(kpRs));
        String rmRs = Tags.me().xml(xml).rm("p", "a").ok();
        System.out.println("<div>This is div.</div>This is p.<ul><li>This is li.This is link.</li></ul>".equals(rmRs));
        String sRs = Tags.me().xml(xml).rm("div", "ul", "li").Attrs().tag("a").rm("href").ok();
        System.out.println("This is div.<p>This is p.This is li.<a>This is link.</a></p>".equals(sRs));
        String sRs2 = Attrs.me().xml(xml).rm("href").Tags().kp("div", "a").ok();
        System.out.println("<div>This is div.</div>This is p.This is li.<a>This is link.</a>".equals(sRs2));
        String html = "<dd class=\"frinfo line_blue\">2013-01-07 08:40:03      <a style=\"font-weight:bold;padding:5px 0px 5px 20px;background:url('http://www.2cto.com/statics/images/icon/user_comment.png') left center no-repeat\" href=\"#comment_iframe\">\u6211\u6765\u8bf4\u4e24\u53e5 </a>    \u6765\u6e90\uff1a\u96e8\u7b80 \u7684BLOG    </dd>";
        System.out.println(Tags.me().xml(html).kp("p").empty().ok());
        List<String> tag = Tags.findByRegex(html, Tags.xmlTagsRegex("a"));
        String regex = String.valueOf(tag.get(0)) + ".*" + tag.get(1);
        System.out.println(regex);
        html = html.replaceAll(regex, "");
        System.out.println(html);
        System.out.println(Attrs.me().xml(html).tag("a").rm().Tags().rm("a").empty().exe().rm("dd").ok());
        System.out.println(Attrs.regex("a", "style"));
    }

    public static Tags me() {
        return new Tags();
    }

    public Tags xml(String xml) {
        this.xml = xml;
        return this;
    }

    public Attrs Attrs() {
        this.exe();
        return Attrs.me().xml(this.xml);
    }

    public Tags empty() {
        this.empty = true;
        return this;
    }

    public Tags rm() {
        this.xml = Tags.cleanXmlTags(this.xml, false, new String[0]);
        return this;
    }

    public Tags rm(String tag) {
        this.rms.add(tag);
        return this;
    }

    public Tags rm(String ... tag) {
        this.rms.addAll(Arrays.asList(tag));
        return this;
    }

    public Tags kp(String tag) {
        this.kps.add(tag);
        return this;
    }

    public Tags kp(String ... tag) {
        this.kps.addAll(Arrays.asList(tag));
        return this;
    }

    public Tags exe() {
        if (!this.rms.isEmpty()) {
            this.xml = Tags.cleanXmlTags(this.xml, this.empty, this.rms.toArray(new String[0]));
            this.rms.clear();
            this.empty = false;
        }
        if (!this.kps.isEmpty()) {
            this.xml = Tags.cleanOtherXmlTags(this.xml, this.empty, this.kps.toArray(new String[0]));
            this.kps.clear();
        }
        return this;
    }

    public String ok() {
        this.exe();
        return this.xml;
    }

    /*
     * Could not resolve type clashes
     */
    public static String cleanOtherXmlTags(String html, boolean isRMCnt, String ... keepTags) {
        if (isRMCnt) {
            String[] stringArray = keepTags;
            int n = keepTags.length;
            int n2 = 0;
            while (n2 < n) {
                String keepTag = stringArray[n2];
                String x = Tags.inverseXmlTagsRegex(keepTag);
                List<String> tag = Tags.findByRegex(html, x);
                if (tag != null && !tag.isEmpty() && tag.size() % 2 == 0) {
                    int size = tag.size() / 2;
                    ArrayList tags = new ArrayList(size);
                    ArrayList<String> _pair = new ArrayList<String>(2);
                    int i = 1;
                    while (i <= tag.size()) {
                        _pair.add(tag.get(i - 1));
                        if (i % 2 == 0) {
                            tags.add(new ArrayList(_pair));
                            _pair.clear();
                        }
                        ++i;
                    }
                    for (List _tag : tags) {
                        String regex = String.valueOf(Tags.resolveRegex((String)_tag.get(0))) + ".*" + Tags.resolveRegex((String)_tag.get(1));
                        html = html.replaceAll(regex, "");
                    }
                }
                ++n2;
            }
            return html;
        }
        return html.replaceAll(Tags.inverseXmlTagsRegex(keepTags), "");
    }

    public static String cleanXmlTags(String html, boolean isRMCnt, String ... delTags) {
        if (isRMCnt) {
            String[] stringArray = delTags;
            int n = delTags.length;
            int n2 = 0;
            while (n2 < n) {
                String delTag = stringArray[n2];
                List<String> tag = Tags.findByRegex(html, Tags.xmlTagsRegex(delTag));
                if (tag != null && !tag.isEmpty() && tag.size() == 2) {
                    String regex = String.valueOf(Tags.resolveRegex(tag.get(0))) + ".*" + Tags.resolveRegex(tag.get(1));
                    html = html.replaceAll(regex, "");
                }
                ++n2;
            }
            return html;
        }
        return html.replaceAll(Tags.xmlTagsRegex(delTags), "");
    }

    public static String resolveRegex(String regex) {
        List<String> cc = Arrays.asList("\\", "^", "$", "*", "+", "?", "{", "}", "(", ")", ".", "[", "]", "|");
        for (String c : cc) {
            regex = regex.replace(c, "\\" + c);
        }
        return regex;
    }

    public static String inverseXmlTagsRegex(String ... keepTags) {
        if (keepTags == null || keepTags.length == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String fmt = "\\b%s\\b";
        StringBuilder sb = new StringBuilder();
        String[] stringArray = keepTags;
        int n = keepTags.length;
        int n2 = 0;
        while (n2 < n) {
            String kt = stringArray[n2];
            if (kt != null && kt.trim().length() != 0) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(String.format(fmt, kt));
            }
            ++n2;
        }
        if (sb.length() == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String pattern = "<[!/]?\\b(?!(" + sb.toString() + "))+\\b\\s*[^>]*>";
        return pattern;
    }

    public static String xmlTagsRegex(String ... tags) {
        if (tags == null || tags.length == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String fmt = "\\b%s\\b";
        StringBuilder sb = new StringBuilder();
        String[] stringArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String kt = stringArray[n2];
            if (kt != null && kt.trim().length() != 0) {
                if (sb.length() > 0) {
                    sb.append("|");
                }
                sb.append(String.format(fmt, kt));
            }
            ++n2;
        }
        if (sb.length() == 0) {
            return "<[!/]?\\b\\w+\\b\\s*[^>]*>";
        }
        String pattern = "<[!/]?(" + sb.toString() + ")\\s*[^>]*>";
        return pattern;
    }

    public static List<String> findByRegex(String input, String regex) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(input);
        while (m.find()) {
            result.add(m.group());
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }
}

