/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static void appendFile(File f, String content) throws Exception {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(f, true));
            writer.write(content);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void writeFile(File f, String content) throws Exception {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "utf-8"));
            writer.write(content);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String readFile(File f) {
        StringBuilder sb;
        block15: {
            BufferedReader reader = null;
            sb = new StringBuilder();
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static String getExt(File f) {
        return f.getName().substring(f.getName().lastIndexOf(".") + 1);
    }

    public static boolean deleteFolder(File folder) {
        return FileUtil.deleteFolderContents(folder) && folder.delete();
    }

    public static boolean deleteFolderContents(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() ? !file.delete() : !FileUtil.deleteFolder(file)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    public static BufferedImage getBufferedImage(String imagePath, boolean isRemote) throws Exception {
        return FileUtil.getBufferedImage(imagePath, isRemote, 0, 1000L);
    }

    public static BufferedImage getBufferedImage(String imagePath) throws Exception {
        return FileUtil.getBufferedImage(imagePath, false, 0, 1000L);
    }

    public static BufferedImage getBufferedImage(String imagePath, int retryTimes, long sleep) throws Exception {
        return FileUtil.getBufferedImage(imagePath, false, retryTimes, sleep);
    }

    /*
     * Loose catch block
     */
    public static BufferedImage getBufferedImage(String imagePath, boolean isRemote, int retryTimes, long sleep) throws Exception {
        if (imagePath == null || imagePath.trim().length() == 0) {
            throw new Exception("image url can not be empty");
        }
        int count = 0;
        while (true) {
            block8: {
                if (!isRemote) break block8;
                return FileUtil.getRemote(imagePath);
                {
                    catch (Throwable e) {
                        if (count >= retryTimes) {
                            throw new Exception(e);
                        }
                        Thread.sleep(sleep);
                        ++count;
                        continue;
                    }
                }
            }
            try {
                return FileUtil.getLocal(imagePath);
            }
            catch (Throwable e) {
                return FileUtil.getRemote(imagePath);
            }
            break;
        }
    }

    private static BufferedImage getLocal(String imagePath) throws IOException {
        try {
            return FileUtil.toBufferedImage(Toolkit.getDefaultToolkit().getImage(imagePath));
        }
        catch (Throwable e) {
            return ImageIO.read(new File(imagePath));
        }
    }

    private static BufferedImage getRemote(String imagePath) throws MalformedURLException, IOException {
        URL url = new URL(imagePath.replace(" ", "%20"));
        try {
            return FileUtil.toBufferedImage(Toolkit.getDefaultToolkit().getImage(url));
        }
        catch (Throwable e1) {
            return ImageIO.read(url);
        }
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException transparency) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean exists(String filePath) {
        File dir = new File(CommonUtil.uriDecoding(filePath));
        return dir.exists();
    }

    public static File[] getFiles(String str) {
        File dir = new File(CommonUtil.uriDecoding(str));
        File[] result = null;
        if (dir.isDirectory()) {
            result = dir.listFiles();
        }
        return result;
    }

    public static String getTopClassPath(Class<?> clazz) {
        String path = CommonUtil.uriDecoding(clazz.getResource("/").getPath());
        return path;
    }

    public static void main(String[] args) throws Exception {
        String c = FileUtil.readFile(new File("d:/seasky.lrc"));
        System.out.println(c);
    }

    public static String getLib() {
        return CommonUtil.uriDecoding(String.valueOf(FileUtil.getParent(FileUtil.getTopClassPath(FileUtil.class), 1)) + "lib");
    }

    public static String[] getChildrenPath(File parent) {
        File[] files = parent.listFiles();
        String[] result = new String[files.length];
        int i = 0;
        while (i < files.length) {
            result[i] = CommonUtil.uriDecoding(files[i].getAbsolutePath());
            ++i;
        }
        return result;
    }

    public static Collection<String> getJars() {
        HashSet<String> jars = new HashSet<String>();
        try {
            Enumeration<URL> urls = FileUtil.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String path = url.getFile().replace("file:/", "").replace("!/META-INF/MANIFEST.MF", "");
                jars.add(CommonUtil.uriDecoding(path));
            }
            File jarDir = new File(FileUtil.getLib());
            if (jarDir.isDirectory() && jarDir.exists()) {
                File[] fileArray = jarDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File jar = fileArray[n2];
                    jars.add(CommonUtil.uriDecoding(jar.getAbsolutePath()));
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return jars;
    }

    public static String getClassPath(String folderName) {
        return String.valueOf(FileUtil.getParent(FileUtil.getTopClassPath(FileUtil.class), 1)) + folderName;
    }

    public static String getCurrPath(Class<?> clazz) {
        return CommonUtil.uriDecoding(String.valueOf(clazz.getResource("/").getPath()) + clazz.getName().replace(".", File.separator));
    }

    public static boolean createDir(String path) {
        boolean flag = false;
        File file = new File(CommonUtil.uriDecoding(path));
        if (!file.exists() && !file.isDirectory()) {
            flag = file.mkdir();
        }
        return flag;
    }

    public static boolean createFile(String path) throws IOException {
        return FileUtil.createFile(path, false);
    }

    public static boolean createFile(File file, boolean isDelete) throws IOException {
        boolean flag = true;
        if (file.exists()) {
            if (isDelete) {
                file.delete();
                file.createNewFile();
            } else {
                flag = false;
            }
        } else {
            file.createNewFile();
        }
        return flag;
    }

    public static boolean createFile(String path, boolean isDelete) throws IOException {
        File file = new File(CommonUtil.uriDecoding(path));
        return FileUtil.createFile(file, isDelete);
    }

    public static boolean moveFileTo(File oldFile, String newDir) {
        StringBuilder sb = new StringBuilder(newDir);
        sb.append(File.separator).append(oldFile.getName());
        File toDir = new File(CommonUtil.uriDecoding(sb.toString()));
        boolean flag = false;
        if (!toDir.exists()) {
            flag = oldFile.renameTo(toDir);
        }
        return flag;
    }

    public static String getParent(File f, int floor) {
        String result = "";
        if (f != null && f.exists()) {
            int i = 0;
            while (i < floor) {
                f = f.getParentFile();
                ++i;
            }
            if (f != null && f.exists()) {
                result = f.getPath();
            }
        }
        return String.valueOf(CommonUtil.uriDecoding(result)) + File.separator;
    }

    public static String getParent(String path, int floor) {
        return FileUtil.getParent(new File(path), floor);
    }

    public static boolean deleteFile(File file) {
        boolean flag = false;
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    FileUtil.deleteFile(f);
                    ++n2;
                }
            }
            flag = file.delete();
        }
        return flag;
    }

    public static boolean isValidFileName(String fileName) {
        if (fileName == null || fileName.length() > 255) {
            return false;
        }
        return fileName.matches("[^\\s\\\\/:\\*\\?\\\"<>\\|](\\x20|[^\\s\\\\/:\\*\\?\\\"<>\\|])*[^\\s\\\\/:\\*\\?\\\"<>\\|\\.]$");
    }

    public static void copy(File src, File dst) {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            try {
                in = new FileInputStream(src);
                out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                int len = -1;
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception e22) {
                            e22.printStackTrace();
                        }
                    }
                }
                finally {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        finally {
            block46: {
                try {
                    try {
                        if (in != null) {
                            ((InputStream)in).close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        try {
                            if (out != null) {
                                out.close();
                            }
                            break block46;
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                        break block46;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            out.close();
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }
}

