/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    public static Class<?> getPojoClass(Method method) {
        Type type = method.getGenericReturnType();
        String clsName = type.toString();
        if (clsName.contains("<") && clsName.contains(">")) {
            int s = clsName.indexOf("<") + 1;
            int e = clsName.indexOf(">");
            String str = clsName.substring(s, e);
            return ClassUtil.getPojoClass(str);
        }
        return method.getReturnType();
    }

    public static Class<?> getPojoClass(String className) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(className);
            if (ClassUtil.isPojo(cls)) {
                return cls;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static boolean isPojo(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (!(Collection.class.isAssignableFrom(cls) || Integer.class.isAssignableFrom(cls) || Integer.TYPE.isAssignableFrom(cls) || Integer[].class.isAssignableFrom(cls) || int[].class.isAssignableFrom(cls) || Long.class.isAssignableFrom(cls) || Long.TYPE.isAssignableFrom(cls) || Long[].class.isAssignableFrom(cls) || long[].class.isAssignableFrom(cls) || Float.class.isAssignableFrom(cls) || Float.TYPE.isAssignableFrom(cls) || Float[].class.isAssignableFrom(cls) || float[].class.isAssignableFrom(cls) || Double.class.isAssignableFrom(cls) || Double.TYPE.isAssignableFrom(cls) || Double[].class.isAssignableFrom(cls) || double[].class.isAssignableFrom(cls) || String.class.isAssignableFrom(cls) || String[].class.isAssignableFrom(cls) || Date.class.isAssignableFrom(cls) || Date[].class.isAssignableFrom(cls))) {
            try {
                cls.newInstance();
                return true;
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public static <T> T injectFieldValue(T pojo, String fieldName, String[] vs) throws Exception {
        if (pojo == null) {
            return null;
        }
        if (vs == null) {
            return pojo;
        }
        ReflectUtil ru = new ReflectUtil(pojo);
        Field f = ru.getField(fieldName);
        if (f == null) {
            return pojo;
        }
        Method setter = ru.getSetter(fieldName);
        if (setter == null) {
            return pojo;
        }
        Class<?> clazz = f.getType();
        if (Object[].class.isAssignableFrom(clazz)) {
            Object obj = ClassUtil.getParamVals(clazz, vs);
            if (obj != null) {
                setter.invoke(pojo, obj);
            }
        } else {
            Object obj = ClassUtil.getParamVal(clazz, vs[0]);
            if (obj != null) {
                setter.invoke(pojo, obj);
            }
        }
        return pojo;
    }

    public static Object getParamVal(Class<?> fieldType, String fieldVal) {
        Class<?> clazz = fieldType;
        String v = fieldVal;
        if (v == null) {
            return null;
        }
        try {
            if (Integer.TYPE.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz)) {
                if ("".equals(v.trim())) {
                    v = "0";
                }
                try {
                    return Integer.parseInt(v);
                }
                catch (Exception e) {
                    return 0;
                }
            }
            if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
                if ("".equals(v.trim())) {
                    v = "0L";
                }
                try {
                    return Long.parseLong(v);
                }
                catch (Exception e) {
                    return 0L;
                }
            }
            if (Double.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz)) {
                if ("".equals(v.trim())) {
                    v = "0.0D";
                }
                try {
                    return Double.parseDouble(v);
                }
                catch (Exception e) {
                    return 0.0;
                }
            }
            if (Float.TYPE.isAssignableFrom(clazz) || Float.class.isAssignableFrom(clazz)) {
                if ("".equals(v.trim())) {
                    v = "0.0F";
                }
                try {
                    return Float.valueOf(Float.parseFloat(v));
                }
                catch (Exception e) {
                    return Float.valueOf(0.0f);
                }
            }
            if (Boolean.TYPE.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
                if ("".equals(v.trim())) {
                    v = "false";
                }
                try {
                    return Boolean.parseBoolean(v);
                }
                catch (Exception e) {
                    return false;
                }
            }
            if (String.class.isAssignableFrom(clazz)) {
                return v;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getParamVals(Class<?> fieldType, String[] fieldVals) {
        Class<?> clazz = fieldType;
        String[] vs = fieldVals;
        if (vs == null) {
            return null;
        }
        try {
            int length = vs.length;
            if (Integer[].class.isAssignableFrom(clazz)) {
                Integer[] args = new Integer[length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0";
                    }
                    try {
                        args[i] = Integer.parseInt(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = 0;
                    }
                    ++i;
                }
                return args;
            }
            if (int[].class.isAssignableFrom(clazz)) {
                int[] args = new int[length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0";
                    }
                    try {
                        args[i] = Integer.parseInt(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = 0;
                    }
                    ++i;
                }
                return args;
            }
            if (Long[].class.isAssignableFrom(clazz)) {
                Long[] args = new Long[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0";
                    }
                    try {
                        args[i] = Long.parseLong(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = 0L;
                    }
                    ++i;
                }
                return args;
            }
            if (long[].class.isAssignableFrom(clazz)) {
                long[] args = new long[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0";
                    }
                    try {
                        args[i] = Long.parseLong(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = 0L;
                    }
                    ++i;
                }
                return args;
            }
            if (Double[].class.isAssignableFrom(clazz)) {
                Double[] args = new Double[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0.0";
                    }
                    try {
                        args[i] = Double.parseDouble(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = 0.0;
                    }
                    ++i;
                }
                return args;
            }
            if (double[].class.isAssignableFrom(clazz)) {
                double[] args = new double[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0.0";
                    }
                    try {
                        args[i] = Double.parseDouble(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = 0.0;
                    }
                    ++i;
                }
                return args;
            }
            if (Float[].class.isAssignableFrom(clazz)) {
                Float[] args = new Float[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0.0";
                    }
                    try {
                        args[i] = Float.valueOf(Float.parseFloat(vs[i]));
                    }
                    catch (Exception e) {
                        args[i] = Float.valueOf(0.0f);
                    }
                    ++i;
                }
                return args;
            }
            if (float[].class.isAssignableFrom(clazz)) {
                float[] args = new float[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "0.0";
                    }
                    try {
                        args[i] = Float.parseFloat(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = 0.0f;
                    }
                    ++i;
                }
                return args;
            }
            if (Boolean[].class.isAssignableFrom(clazz)) {
                Boolean[] args = new Boolean[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "false";
                    }
                    try {
                        args[i] = Boolean.parseBoolean(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = false;
                    }
                    ++i;
                }
                return args;
            }
            if (boolean[].class.isAssignableFrom(clazz)) {
                boolean[] args = new boolean[vs.length];
                int i = 0;
                while (i < vs.length) {
                    if ("".equals(vs[i].trim())) {
                        vs[i] = "false";
                    }
                    try {
                        args[i] = Boolean.parseBoolean(vs[i]);
                    }
                    catch (Exception e) {
                        args[i] = false;
                    }
                    ++i;
                }
                return args;
            }
            if (String[].class.isAssignableFrom(clazz)) {
                return vs;
            }
        }
        catch (Exception e) {
            return null;
        }
        catch (Error e) {
            return null;
        }
        return null;
    }

    public static Class<?> getGenericType(Field f) {
        Class<?> cls = f.getType();
        if (!Collection.class.isAssignableFrom(cls)) {
            return cls;
        }
        ParameterizedType pt = (ParameterizedType)f.getGenericType();
        Type type = pt.getActualTypeArguments()[0];
        Class<?> targetCls = ClassUtil.getPojoClass(type.toString().replace("class ", "").replace("interface ", "").trim());
        if (targetCls == null) {
            return cls;
        }
        return targetCls;
    }

    public static boolean isListClass(Field f) {
        Class<?> cls = f.getType();
        if (!Collection.class.isAssignableFrom(cls)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)f.getGenericType();
        Type type = pt.getActualTypeArguments()[0];
        Class<?> targetCls = ClassUtil.getPojoClass(type.toString().replace("class ", ""));
        return targetCls != null;
    }

    public static boolean isListString(Field f) {
        Class<?> cls = f.getType();
        if (!Collection.class.isAssignableFrom(cls)) {
            return false;
        }
        ParameterizedType pt = (ParameterizedType)f.getGenericType();
        Type type = pt.getActualTypeArguments()[0];
        return "class java.lang.String".equals(type.toString());
    }
}

