/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.sql.OrderColumnUtil;
import org.eweb4j.orm.sql.SqlCreateException;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectSqlCreator<T> {
    private T t;
    private Class<?> clazz;
    private String table;
    private String idColumn;
    private String idField;
    private String dbType;
    private String selectAllColumn;

    public void setSelectAllColumn(String selectAllColumn) {
        this.selectAllColumn = selectAllColumn;
    }

    public SelectSqlCreator(T t, String dbType) {
        this.t = t;
        this.clazz = t.getClass();
        if (Map.class.isAssignableFrom(this.clazz)) {
            HashMap map = (HashMap)t;
            this.table = String.valueOf(map.get("table"));
            this.idColumn = map.containsKey("idColumn") ? (String)map.get("idColumn") : "id";
            this.idField = this.idColumn;
            if (map.containsKey("columns")) {
                StringBuilder sb = new StringBuilder();
                String[] stringArray = (String[])map.get("columns");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String column = stringArray[n2];
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(column);
                    ++n2;
                }
                this.selectAllColumn = sb.toString();
            } else {
                this.selectAllColumn = "*";
            }
        } else {
            this.selectAllColumn = ORMConfigBeanUtil.getSelectAllColumn(this.clazz);
            this.table = ORMConfigBeanUtil.getTable(this.clazz, true);
            this.idColumn = ORMConfigBeanUtil.getIdColumn(this.clazz);
            this.idField = ORMConfigBeanUtil.getIdField(this.clazz);
        }
        this.dbType = dbType;
    }

    public String select(String condition) {
        return String.format("SELECT %s FROM %s WHERE %s ;", this.selectAllColumn, this.table, condition);
    }

    public String selectCount(String condition) {
        if (condition == null) {
            return String.format("SELECT COUNT(*) FROM %s ;", this.table);
        }
        return String.format("SELECT COUNT(*) FROM %s WHERE %s ;", this.table, condition);
    }

    public String selectWhere(String[] fields, String[] values, int likeType, boolean isLike, boolean isNot, boolean isOR, String orderField, int oType, int currentPage, int numPerPage) throws SqlCreateException {
        String orderType;
        String oper = " = ";
        String connector = " AND ";
        String left = " '";
        String right = "' ";
        if (isNot) {
            oper = "<>";
        }
        if (isLike) {
            oper = " LIKE ";
            left = " '%";
            right = "%' ";
            if (isNot) {
                oper = " NOT LIKE ";
            }
            switch (likeType) {
                case -1: {
                    left = " '";
                    break;
                }
                case 1: {
                    right = "' ";
                }
            }
        }
        if (isOR) {
            connector = " OR ";
        }
        String[] type = new String[]{oper, connector, left, right};
        if (orderField == null) {
            orderField = this.idColumn;
            orderField = OrderColumnUtil.getOrderColumn(orderField, this.dbType);
        } else {
            orderField = ORMConfigBeanUtil.getColumn(this.clazz, orderField);
        }
        StringBuilder condition = new StringBuilder();
        String[] columns = ORMConfigBeanUtil.getColumns(this.clazz, fields);
        int i = 0;
        while (i < columns.length) {
            block31: {
                if (values != null) {
                    if (condition.length() > 0) {
                        condition.append(type[1]).append(columns[i]).append(" ").append(type[0]).append(type[2]).append(values[i]).append(type[3]);
                    } else {
                        condition.append(columns[i]).append(" ").append(type[0]).append(type[2]).append(values[i]).append(type[3]);
                    }
                } else {
                    ReflectUtil ru = new ReflectUtil(this.t);
                    Method getter = ru.getGetter(fields[i]);
                    if (getter != null) {
                        try {
                            Object _value = getter.invoke(this.t, new Object[0]);
                            if (_value == null) break block31;
                            Object value = null;
                            if (ClassUtil.isPojo(_value.getClass())) {
                                Field f = ru.getField(fields[i]);
                                OneToOne oneAnn = getter.getAnnotation(OneToOne.class);
                                if (oneAnn == null) {
                                    oneAnn = f.getAnnotation(OneToOne.class);
                                }
                                ManyToOne manyToOneAnn = null;
                                if (oneAnn == null && (manyToOneAnn = getter.getAnnotation(ManyToOne.class)) == null) {
                                    manyToOneAnn = f.getAnnotation(ManyToOne.class);
                                }
                                if (oneAnn != null || manyToOneAnn != null) {
                                    JoinColumn joinColAnn = getter.getAnnotation(JoinColumn.class);
                                    if (joinColAnn == null) {
                                        joinColAnn = f.getAnnotation(JoinColumn.class);
                                    }
                                    if (joinColAnn != null && joinColAnn.referencedColumnName().trim().length() > 0) {
                                        String refCol = joinColAnn.referencedColumnName();
                                        String refField = ORMConfigBeanUtil.getField(_value.getClass(), refCol);
                                        ReflectUtil tarRu = new ReflectUtil(_value);
                                        Method tarFKGetter = tarRu.getGetter(refField);
                                        value = tarFKGetter.invoke(_value, new Object[0]);
                                    } else {
                                        ReflectUtil tarRu = new ReflectUtil(_value);
                                        String tarFKField = ORMConfigBeanUtil.getIdField(_value.getClass());
                                        if (tarFKField != null) {
                                            Method tarFKGetter = tarRu.getGetter(tarFKField);
                                            value = tarFKGetter.invoke(_value, new Object[0]);
                                        }
                                    }
                                }
                                if (value == null) {
                                    break block31;
                                }
                            } else {
                                value = _value;
                            }
                            if (condition.length() > 0) {
                                condition.append(type[1]).append(columns[i]).append(" ").append(type[0]).append(type[2]).append(value).append(type[3]);
                            } else {
                                condition.append(columns[i]).append(" ").append(type[0]).append(type[2]).append(value).append(type[3]);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            throw new SqlCreateException(getter + " invoke exception " + e.toString());
                        }
                    }
                }
            }
            ++i;
        }
        String string = orderType = 1 == oType ? "ASC" : "DESC";
        if (currentPage > 0 && numPerPage > 0) {
            return this.divPage(currentPage, numPerPage, orderField, oType, condition.toString());
        }
        return String.format("SELECT %s FROM %s WHERE %s ORDER BY %s %s ;", this.selectAllColumn, this.table, condition.toString(), orderField, orderType);
    }

    public String selectWhere(String[] fields, String[] values, int likeType, boolean isLike, boolean isNot, String orderField, int oType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, isLike, isNot, false, orderField, oType, currentPage, numPerPage);
    }

    public String selectWhere(String[] fields, int likeType, boolean isLike, boolean isNot, boolean isOR, String orderField, int oType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, isLike, isNot, isOR, orderField, oType, currentPage, numPerPage);
    }

    public String selectWhere(String[] fields, String[] values, int likeType, boolean isLike, String orderField, int oType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, isLike, false, orderField, oType, currentPage, numPerPage);
    }

    public String selectWhere(String[] fields, String[] values, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, false, orderField, orderType, -1, -1);
    }

    public String selectWhereNot(String[] fields, String[] values, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, true, orderField, orderType, -1, -1);
    }

    public String selectWhere(String[] fields, String[] values, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, false, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhereNot(String[] fields, String[] values, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, true, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhere(String[] fields, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, false, orderField, orderType, -1, -1);
    }

    public String selectWhereNot(String[] fields, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, true, orderField, orderType, -1, -1);
    }

    public String selectWhere(String[] fields, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, false, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhereNot(String[] fields, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, true, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhere(String[] fields, String[] values, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, false, null, orderType, -1, -1);
    }

    public String selectWhereNot(String[] fields, String[] values, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, true, null, orderType, -1, -1);
    }

    public String selectWhere(String[] fields, String[] values, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, false, null, orderType, currentPage, numPerPage);
    }

    public String selectWhereNot(String[] fields, String[] values, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, true, null, orderType, currentPage, numPerPage);
    }

    public String selectWhere(String[] fields, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, false, null, orderType, -1, -1);
    }

    public String selectWhereNot(String[] fields, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, true, null, orderType, -1, -1);
    }

    public String selectWhere(String[] fields, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, false, null, orderType, currentPage, numPerPage);
    }

    public String selectWhereNot(String[] fields, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, true, null, orderType, currentPage, numPerPage);
    }

    public String selectWhere(String[] fields, String[] values) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, false, null, -1, -1, -1);
    }

    public String selectWhereNot(String[] fields, String[] values) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, true, null, -1, -1, -1);
    }

    public String selectWhere(String[] fields, String[] values, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, false, null, -1, currentPage, numPerPage);
    }

    public String selectWhereNot(String[] fields, String[] values, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, 0, false, true, null, -1, currentPage, numPerPage);
    }

    public String selectWhere(String ... fields) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, false, null, -1, -1, -1);
    }

    public String selectWhereNot(String ... fields) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, true, null, -1, -1, -1);
    }

    public String selectWhere(String[] fields, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, false, null, -1, currentPage, numPerPage);
    }

    public String selectWhereNot(String[] fields, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, false, true, null, -1, currentPage, numPerPage);
    }

    public String selectWhereLike(String[] fields, String[] values, int likeType, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, false, orderField, orderType, -1, -1);
    }

    public String selectWhereNotLike(String[] fields, String[] values, int likeType, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, true, orderField, orderType, -1, -1);
    }

    public String selectWhereLike(String[] fields, String[] values, int likeType, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, false, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhereNotLike(String[] fields, String[] values, int likeType, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, true, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhereLike(String[] fields, int likeType, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, false, orderField, orderType, -1, -1);
    }

    public String selectWhereNotLike(String[] fields, int likeType, String orderField, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, true, orderField, orderType, -1, -1);
    }

    public String selectWhereLike(String[] fields, int likeType, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, false, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhereNotLike(String[] fields, int likeType, String orderField, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, true, orderField, orderType, currentPage, numPerPage);
    }

    public String selectWhereLike(String[] fields, String[] values, int likeType, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, false, null, orderType, -1, -1);
    }

    public String selectWhereNotLike(String[] fields, String[] values, int likeType, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, true, null, orderType, -1, -1);
    }

    public String selectWhereLike(String[] fields, String[] values, int likeType, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, false, null, orderType, currentPage, numPerPage);
    }

    public String selectWhereNotLike(String[] fields, String[] values, int likeType, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, true, null, orderType, currentPage, numPerPage);
    }

    public String selectWhereLike(String[] fields, int likeType, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, false, null, orderType, -1, -1);
    }

    public String selectWhereNotLike(String[] fields, int likeType, int orderType) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, true, null, orderType, -1, -1);
    }

    public String selectWhereLike(String[] fields, int likeType, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, false, null, orderType, currentPage, numPerPage);
    }

    public String selectWhereNotLike(String[] fields, int likeType, int orderType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, true, null, orderType, currentPage, numPerPage);
    }

    public String selectWhereLike(String[] fields, String[] values, int likeType) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, false, null, -1, -1, -1);
    }

    public String selectWhereNotLike(String[] fields, String[] values, int likeType) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, true, null, -1, -1, -1);
    }

    public String selectWhereLike(String[] fields, String[] values, int likeType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, false, null, -1, currentPage, numPerPage);
    }

    public String selectWhereNotLike(String[] fields, String[] values, int likeType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, values, likeType, true, true, null, -1, currentPage, numPerPage);
    }

    public String selectWhereLike(String[] fields, int likeType) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, false, null, -1, -1, -1);
    }

    public String selectWhereNotLike(String[] fields, int likeType) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, true, null, -1, -1, -1);
    }

    public String selectWhereLike(String[] fields, int likeType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, false, null, -1, currentPage, numPerPage);
    }

    public String selectWhereNotLike(String[] fields, int likeType, int currentPage, int numPerPage) throws SqlCreateException {
        return this.selectWhere(fields, null, likeType, true, true, null, -1, currentPage, numPerPage);
    }

    public String selectWhereLike(String ... fields) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, true, false, null, -1, -1, -1);
    }

    public String selectWhereNotLike(String ... fields) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, true, true, null, -1, -1, -1);
    }

    public String selectWhereLike(int currentPage, int numPerPage, String[] fields) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, true, false, null, -1, -1, -1);
    }

    public String selectWhereNotLike(int currentPage, int numPerPage, String[] fields) throws SqlCreateException {
        return this.selectWhere(fields, null, 0, true, true, null, -1, -1, -1);
    }

    public String selectAll(String orderField, int oType) {
        if (orderField == null) {
            orderField = this.idColumn;
            orderField = OrderColumnUtil.getOrderColumn(orderField, this.dbType);
        } else {
            orderField = ORMConfigBeanUtil.getColumn(this.clazz, orderField);
        }
        String orderType = 1 == oType ? "ASC" : "DESC";
        return String.format("SELECT %s FROM %s ORDER BY %s %s ;", this.selectAllColumn, this.table, orderField, orderType);
    }

    public String selectAll(int oType) {
        return this.selectAll(null, oType);
    }

    public String selectAll() {
        return this.selectAll(null, -1);
    }

    public String selectOne() throws SqlCreateException {
        ReflectUtil ru = new ReflectUtil(this.t);
        StringBuilder condition = new StringBuilder();
        Method m = ru.getGetter(this.idField);
        if (m == null) {
            throw new SqlCreateException("can not find id getter");
        }
        try {
            condition.append(this.idColumn).append(" = '").append(m.invoke(this.t, new Object[0])).append("'");
        }
        catch (Exception e) {
            throw new SqlCreateException(m + " invoke exception " + e.toString());
        }
        return String.format("SELECT * FROM %s WHERE %s ;", this.selectAllColumn, this.table, condition.toString());
    }

    public String nextOne() throws SqlCreateException {
        return this.nextOrPre(1, true);
    }

    public String nextOne(String orderField, int value) throws SqlCreateException {
        return this.nextOrPre(orderField, value, 1, true);
    }

    public String preOne(String orderField, int value) throws SqlCreateException {
        return this.nextOrPre(orderField, value, 1, false);
    }

    public String preOne() throws SqlCreateException {
        return this.nextOrPre(1, false);
    }

    public String nextOrPre(int num, boolean isNext) throws SqlCreateException {
        Method m = new ReflectUtil(this.t).getGetter(this.idField);
        if (m == null) {
            throw new SqlCreateException("can not fine id getter");
        }
        String idVal = "";
        try {
            idVal = String.valueOf(m.invoke(this.t, new Object[0]));
        }
        catch (Exception e) {
            throw new SqlCreateException(m + " invoke exception " + e.toString());
        }
        return this.nextOrPre(null, Integer.parseInt(idVal), num, isNext);
    }

    public String nextOrPre(String orderField, int offset, int num, boolean isNext) throws SqlCreateException {
        String type;
        String oType = isNext ? "ASC" : "DESC";
        String string = type = isNext ? ">" : "<";
        if (orderField == null) {
            orderField = this.idColumn;
            orderField = OrderColumnUtil.getOrderColumn(orderField, this.dbType);
        } else {
            orderField = ORMConfigBeanUtil.getColumn(this.clazz, orderField);
        }
        if ("MYSQL".equalsIgnoreCase(this.dbType)) {
            return String.format("SELECT %s FROM %s WHERE %s %s %s ORDER BY %s %s LIMIT %s;", this.selectAllColumn, this.table, orderField, type, offset, orderField, oType, String.valueOf(num));
        }
        if ("MSSQL2000".equalsIgnoreCase(this.dbType) || "MSSQL2005".equalsIgnoreCase(this.dbType)) {
            return String.format("SELECT TOP (%s) %s FROM %s WHERE %s IN (SELECT %s FROM %s  WHERE %s %s %s ) ;", String.valueOf(num), this.selectAllColumn, this.table, orderField, orderField, this.table, orderField, type, offset);
        }
        if ("ORACLE".equalsIgnoreCase(this.dbType)) {
            return String.format("SELECT %s FROM ( SELECT A.%s, ROWNUM RN FROM (SELECT %s FROM %s WHERE %s %s %s ORDER BY %s %s) A WHERE ROWNUM <= %s ) WHERE RN >= 1 ;", this.selectAllColumn, this.selectAllColumn, this.selectAllColumn, this.table, orderField, type, offset, orderField, oType, num, 1);
        }
        throw new SqlCreateException("do not support dataBase. only mysql | mssql");
    }

    public String divPage(int currPage, int numPerPage, String orderField, int oType, String condition) throws SqlCreateException {
        return this.divPage(currPage, numPerPage, orderField, this.clazz, oType, condition);
    }

    public String divPage(int currPage, int numPerPage, String orderField, Class<?> orderFieldCls, int oType, String condition) throws SqlCreateException {
        String orderType;
        String sql = null;
        if (orderField == null) {
            orderField = this.idColumn;
            orderField = OrderColumnUtil.getOrderColumn(orderField, this.dbType);
        } else {
            orderField = ORMConfigBeanUtil.getColumn(orderFieldCls, orderField);
        }
        String string = orderType = 1 == oType ? "ASC" : "DESC";
        if ("MYSQL".equalsIgnoreCase(this.dbType)) {
            sql = "SELECT ${allColumn} FROM ${table} ${condition} ORDER BY ${orderField} ${orderType} LIMIT ${first}, ${numPerPage} ;";
            if (currPage > 0 && numPerPage > 0) {
                sql = sql.replace("${first}", String.valueOf((currPage - 1) * numPerPage));
                sql = sql.replace("${numPerPage}", String.valueOf(numPerPage));
            }
        } else if ("MSSQL2000".equalsIgnoreCase(this.dbType) || "MSSQL2005".equalsIgnoreCase(this.dbType)) {
            sql = "SELECT TOP ${numPerPage} ${allColumn} FROM ${table} WHERE ${orderField} NOT IN (SELECT TOP ${first} ${orderField} FROM ${table} ORDER BY ${orderField} ${orderType}) ${condition} ORDER BY ${orderField} ${orderType} ;";
            if (currPage > 0 && numPerPage > 0) {
                sql = sql.replace("${numPerPage}", String.valueOf(numPerPage));
                sql = sql.replace("${first}", String.valueOf(numPerPage * (currPage - 1)));
            }
        } else if ("ORACLE".equalsIgnoreCase(this.dbType)) {
            if (currPage > 0 && numPerPage > 0) {
                int max = currPage * numPerPage;
                int min = (currPage - 1) * numPerPage + 1;
                String format = "SELECT ${allColumn} FROM ( SELECT A.${allColumn}, ROWNUM RN FROM (SELECT ${allColumn} FROM ${table} ${condition} ORDER BY ${orderField} ${orderType}) A WHERE ROWNUM <= %s ) WHERE RN >= %s ;";
                sql = String.format(format, max, min);
            }
        } else {
            throw new SqlCreateException("can not support dataBase. only mysql mssql");
        }
        if (currPage <= 0 || numPerPage <= 0) {
            sql = "SELECT ${allColumn} FROM ${table} ${condition} ORDER BY ${orderField} ${orderType} ;";
        }
        sql = sql.replace("${allColumn}", this.selectAllColumn);
        sql = sql.replace("${table}", this.table);
        sql = sql.replace("${orderField}", orderField);
        sql = sql.replace("${orderType}", orderType);
        sql = condition != null && condition.trim().length() > 0 ? ("MYSQL".equalsIgnoreCase(this.dbType) || "ORACLE".equalsIgnoreCase(this.dbType) ? sql.replace("${condition}", " WHERE " + condition) : sql.replace("${condition}", " AND " + condition)) : sql.replace("${condition}", "");
        return sql;
    }

    public String divPage(int currPage, int numPerPage, int oType) throws SqlCreateException {
        return this.divPage(currPage, numPerPage, null, oType, null);
    }

    public String divPage(int currPage, int numPerPage, String orderField, int oType) throws SqlCreateException {
        return this.divPage(currPage, numPerPage, orderField, oType, null);
    }

    public String divPage(int currPage, int numPerPage, int oType, String condition) throws SqlCreateException {
        return this.divPage(currPage, numPerPage, null, oType, condition);
    }

    public String divPage(int currPage, int numPerPage) throws SqlCreateException {
        return this.divPage(currPage, numPerPage, null, -1, null);
    }

    public String divPage(int currPage, int numPerPage, String condition) throws SqlCreateException {
        return this.divPage(currPage, numPerPage, null, -1, condition);
    }

    public T getT() {
        return this.t;
    }

    public void setT(T t) {
        this.t = t;
    }

    public void setTable(String table) {
        this.table = table;
    }
}

