/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.cascade;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OrderBy;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.DAOFactory;
import org.eweb4j.orm.jdbc.transaction.Trans;
import org.eweb4j.orm.jdbc.transaction.Transaction;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManyToManyDAO {
    private String dsName;
    private Object t;
    private List<Field> fields;
    private ReflectUtil ru;
    private String table;
    private String idVal;

    public ManyToManyDAO(String dsName) {
        this.dsName = dsName;
    }

    public void init(Object t, List<Field> fields) throws DAOException {
        this.t = t;
        this.fields = fields;
        this.ru = new ReflectUtil(this.t);
        this.table = ORMConfigBeanUtil.getTable(this.t.getClass(), true);
        String idField = ORMConfigBeanUtil.getIdField(this.t.getClass());
        Method idGetter = this.ru.getGetter(idField);
        if (idGetter != null) {
            try {
                Object _idVal = idGetter.invoke(this.t, new Object[0]);
                this.idVal = _idVal == null ? null : String.valueOf(_idVal);
            }
            catch (Exception e) {
                throw new DAOException(idGetter + " invoke exception ", e);
            }
        }
    }

    public void insert() throws DAOException {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        Transaction.execute(new Trans(){

            public void run(Object ... args) throws Exception {
                if (ManyToManyDAO.this.idVal == null || "0".equals(ManyToManyDAO.this.idVal) || "".equals(ManyToManyDAO.this.idVal)) {
                    Number _idVal = DAOFactory.getInsertDAO(ManyToManyDAO.this.dsName).insert(ManyToManyDAO.this.t);
                    if (_idVal == null || _idVal.intValue() <= 0) {
                        throw new Exception("can not inster the main obj into db");
                    }
                    ManyToManyDAO.this.idVal = _idVal.toString();
                } else if (DAOFactory.getSelectDAO(ManyToManyDAO.this.dsName).selectOneById(ManyToManyDAO.this.t) == null) {
                    throw new Exception("the main object'id val is invalid!");
                }
                String format = "INSERT INTO %s(%s,%s) VALUES(?,?) ";
                for (Field f : ManyToManyDAO.this.fields) {
                    JoinColumn[] tos;
                    JoinColumn[] froms;
                    JoinTable join;
                    ManyToMany ann;
                    String name = f.getName();
                    Method tarGetter = ManyToManyDAO.this.ru.getGetter(name);
                    if (tarGetter == null || (ann = tarGetter.getAnnotation(ManyToMany.class)) == null && (ann = f.getAnnotation(ManyToMany.class)) == null || (join = tarGetter.getAnnotation(JoinTable.class)) == null && (join = f.getAnnotation(JoinTable.class)) == null || (froms = join.joinColumns()) == null || froms.length == 0 || (tos = join.inverseJoinColumns()) == null || tos.length == 0) continue;
                    Class<?> tarClass = ann.targetEntity();
                    if (Void.TYPE.isAssignableFrom(tarClass)) {
                        tarClass = ClassUtil.getGenericType(f);
                    }
                    String relTable = join.name();
                    Object _tarObj = null;
                    try {
                        _tarObj = tarGetter.invoke(ManyToManyDAO.this.t, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new DAOException(tarGetter + " invoke exception ", e);
                    }
                    if (_tarObj == null) continue;
                    List tarList = (List)_tarObj;
                    int i = 0;
                    while (i < tarList.size()) {
                        Object tarObj = tarList.get(i);
                        String from = froms[0].name();
                        String fromRefCol = froms[0].referencedColumnName();
                        if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                            fromRefCol = ORMConfigBeanUtil.getIdColumn(ManyToManyDAO.this.t);
                        }
                        String fromRefField = ORMConfigBeanUtil.getField(ManyToManyDAO.this.t.getClass(), fromRefCol);
                        Method fromRefFieldGetter = ManyToManyDAO.this.ru.getGetter(fromRefField);
                        if (fromRefFieldGetter == null) {
                            throw new Exception("can not find the 'from ref field -> " + fromRefField + "' of " + ManyToManyDAO.this.t.getClass() + " 's getter method");
                        }
                        Object _obj = fromRefFieldGetter.invoke(ManyToManyDAO.this.t, new Object[0]);
                        if (_obj != null) {
                            String toRefField;
                            Method toRefFieldGetter;
                            String fromRefVal = String.valueOf(_obj);
                            ReflectUtil tarRu = new ReflectUtil(tarObj);
                            String to = tos[0].name();
                            String toRefCol = tos[0].referencedColumnName();
                            if (toRefCol == null || toRefCol.trim().length() == 0) {
                                toRefCol = ORMConfigBeanUtil.getIdColumn(tarClass);
                            }
                            if ((toRefFieldGetter = tarRu.getGetter(toRefField = ORMConfigBeanUtil.getField(tarClass, toRefCol))) == null) {
                                throw new Exception("can not find the 'to ref field -> " + toRefField + "' of " + tarClass + " 's getter method");
                            }
                            Object _obj2 = toRefFieldGetter.invoke(tarObj, new Object[0]);
                            if (_obj2 != null) {
                                Number _tarIdVal;
                                String toRefVal = String.valueOf(_obj2);
                                Object tempObj = DAOFactory.getSelectDAO(ManyToManyDAO.this.dsName).selectOneById(tarObj);
                                if (tempObj == null && ((_tarIdVal = DAOFactory.getInsertDAO(ManyToManyDAO.this.dsName).insert(tarObj)) == null || _tarIdVal.intValue() <= 0)) {
                                    throw new Exception("can not insert the " + tarObj + " into db");
                                }
                                String _format = "select %s, %s from %s where %s = ? and %s = ? ";
                                String _sql = String.format(_format, from, to, relTable, from, to);
                                if (DAOFactory.getSelectDAO(ManyToManyDAO.this.dsName).selectBySQL(Map.class, _sql, fromRefVal, toRefVal) == null) {
                                    String sql = String.format(format, relTable, from, to);
                                    DAOFactory.getUpdateDAO(ManyToManyDAO.this.dsName).updateBySQLWithArgs(sql, fromRefVal, toRefVal);
                                }
                            }
                        }
                        ++i;
                    }
                }
            }
        }, new Object[0]);
    }

    public void delete() throws DAOException {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        String format = "delete from %s WHERE %s = ? ";
        for (Field f : this.fields) {
            String fromRefField;
            Method fromRefFieldGetter;
            JoinColumn[] tos;
            JoinColumn[] froms;
            JoinTable join;
            ManyToMany ann;
            Method tarGetter = this.ru.getGetter(f.getName());
            if (tarGetter == null || (ann = tarGetter.getAnnotation(ManyToMany.class)) == null && (ann = f.getAnnotation(ManyToMany.class)) == null || (join = tarGetter.getAnnotation(JoinTable.class)) == null && (join = f.getAnnotation(JoinTable.class)) == null || (froms = join.joinColumns()) == null || froms.length == 0 || (tos = join.inverseJoinColumns()) == null || tos.length == 0) continue;
            String relTable = join.name();
            String from = froms[0].name();
            String fromRefCol = froms[0].referencedColumnName();
            if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                fromRefCol = ORMConfigBeanUtil.getIdColumn(this.t);
            }
            if ((fromRefFieldGetter = this.ru.getGetter(fromRefField = ORMConfigBeanUtil.getField(this.t.getClass(), fromRefCol))) == null) {
                throw new DAOException("can not find the 'from ref field -> " + fromRefField + "' of " + this.t.getClass() + " 's getter method", null);
            }
            String fromRefVal = null;
            try {
                Object _obj = fromRefFieldGetter.invoke(this.t, new Object[0]);
                if (_obj == null) continue;
                fromRefVal = String.valueOf(_obj);
            }
            catch (Exception e) {
                throw new DAOException("can not get the from ref val of " + this.t.getClass(), e);
            }
            List tarList = null;
            try {
                tarList = (List)tarGetter.invoke(this.t, new Object[0]);
            }
            catch (Exception e) {
                throw new DAOException(tarGetter + " invoke exception, can not get the " + f.getName() + " objs ", e);
            }
            if (tarList == null || tarList.size() == 0) {
                String sql = String.format(format, relTable, from);
                DAOFactory.getUpdateDAO(this.dsName).updateBySQLWithArgs(sql, fromRefVal);
                continue;
            }
            Class<?> tarClass = ann.targetEntity();
            if (Void.TYPE.isAssignableFrom(tarClass)) {
                tarClass = ClassUtil.getGenericType(f);
            }
            String to = tos[0].name();
            String toRefCol = tos[0].referencedColumnName();
            if (toRefCol == null || toRefCol.trim().length() == 0) {
                toRefCol = ORMConfigBeanUtil.getIdColumn(tarClass);
            }
            String toRefField = ORMConfigBeanUtil.getField(tarClass, toRefCol);
            String _format = "delete from %s where %s = ? and %s = ?";
            int i = 0;
            while (i < tarList.size()) {
                block17: {
                    Object tarObj = tarList.get(i);
                    if (tarObj != null) {
                        ReflectUtil tarRu = new ReflectUtil(tarObj);
                        Method toRefFieldGetter = tarRu.getGetter(toRefField);
                        if (toRefFieldGetter == null) {
                            throw new DAOException("can not find the 'to ref field -> " + toRefField + "' of " + tarClass + " 's getter method", null);
                        }
                        String toRefVal = null;
                        try {
                            Object _obj = toRefFieldGetter.invoke(tarObj, new Object[0]);
                            if (_obj == null) break block17;
                            toRefVal = String.valueOf(_obj);
                        }
                        catch (Exception e) {
                            throw new DAOException("can not get the to ref val of " + tarClass, e);
                        }
                        if (DAOFactory.getSelectDAO(this.dsName).selectOne(tarClass, new String[]{toRefField}, new String[]{toRefVal}) != null) {
                            String _sql = String.format(_format, relTable, from, to);
                            DAOFactory.getUpdateDAO(this.dsName).updateBySQLWithArgs(_sql, fromRefVal, toRefVal);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public void select() throws DAOException {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        String format = "select %s from %s, %s r where r.%s = %s.%s and r.%s = ? %s ";
        for (Field f : this.fields) {
            String toRefCol;
            JoinColumn[] tos;
            JoinColumn[] froms;
            JoinTable join;
            ManyToMany ann;
            Method tarGetter = this.ru.getGetter(f.getName());
            if (tarGetter == null || (ann = tarGetter.getAnnotation(ManyToMany.class)) == null && (ann = f.getAnnotation(ManyToMany.class)) == null || (join = tarGetter.getAnnotation(JoinTable.class)) == null && (join = f.getAnnotation(JoinTable.class)) == null || (froms = join.joinColumns()) == null || froms.length == 0 || (tos = join.inverseJoinColumns()) == null || tos.length == 0) continue;
            Class<?> tarClass = ann.targetEntity();
            if (Void.TYPE.isAssignableFrom(tarClass)) {
                tarClass = ClassUtil.getGenericType(f);
            }
            String tarTable = ORMConfigBeanUtil.getTable(tarClass, true);
            OrderBy orderAnn = tarGetter.getAnnotation(OrderBy.class);
            if (orderAnn == null) {
                orderAnn = f.getAnnotation(OrderBy.class);
            }
            String orderBy = "";
            if (orderAnn != null) {
                orderBy = " ORDER BY " + orderAnn.value().replace("t.", String.valueOf(tarClass.getSimpleName().toLowerCase()) + ".");
            }
            if ((toRefCol = tos[0].referencedColumnName()) == null || toRefCol.trim().length() == 0) {
                toRefCol = ORMConfigBeanUtil.getIdColumn(tarClass);
            }
            String toRefField = ORMConfigBeanUtil.getField(tarClass, toRefCol);
            String to = tos[0].name();
            String relTable = join.name();
            String from = froms[0].name();
            String fromRefCol = froms[0].referencedColumnName();
            if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                fromRefCol = ORMConfigBeanUtil.getIdColumn(this.t);
            }
            String fromRefField = ORMConfigBeanUtil.getField(this.t.getClass(), fromRefCol);
            try {
                List<?> tarList = null;
                tarList = (List<?>)tarGetter.invoke(this.t, new Object[0]);
                if (tarList != null && tarList.size() > 0) {
                    int i = 0;
                    while (i < tarList.size()) {
                        Object tarObj = tarList.get(i);
                        ReflectUtil tarRu = new ReflectUtil(tarObj);
                        Method toRefFieldGetter = tarRu.getGetter(toRefField);
                        if (toRefFieldGetter == null) {
                            throw new DAOException("can not find the 'to ref field -> " + toRefField + "' of " + tarClass + " 's getter method", null);
                        }
                        Object _obj = toRefFieldGetter.invoke(tarObj, new Object[0]);
                        if (_obj != null) {
                            String toRefVal = String.valueOf(_obj);
                            tarObj = DAOFactory.getSelectDAO(this.dsName).selectOne(tarClass, new String[]{toRefField}, new String[]{toRefVal});
                        }
                        ++i;
                    }
                } else {
                    String sql = String.format("select %s from %s, %s r where r.%s = %s.%s and r.%s = ? %s ", ORMConfigBeanUtil.getSelectAllColumn(tarClass), tarTable, relTable, to, tarClass.getSimpleName().toLowerCase(), toRefCol, from, orderBy);
                    Method fromRefFieldGetter = this.ru.getGetter(fromRefField);
                    if (fromRefFieldGetter == null) {
                        throw new DAOException("can not find the 'from ref field -> " + fromRefField + "' of " + this.t.getClass() + " 's getter method", null);
                    }
                    Object _obj = fromRefFieldGetter.invoke(this.t, new Object[0]);
                    String fromRefVal = null;
                    if (_obj != null) {
                        fromRefVal = String.valueOf(_obj);
                    }
                    tarList = DAOFactory.getSelectDAO(this.dsName).selectBySQL(tarClass, sql, fromRefVal);
                }
                Method tarSetter = this.ru.getSetter(f.getName());
                tarSetter.invoke(this.t, tarList);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DAOException("", e);
            }
        }
    }

    public void update(Long newFromRefVal) {
        if (this.fields == null || this.fields.size() == 0) {
            return;
        }
        String format = "update %s set %s = %s where %s = %s ;";
        for (Field f : this.fields) {
            JoinColumn[] froms;
            JoinTable join;
            ManyToMany ann;
            Method tarGetter = this.ru.getGetter(f.getName());
            if (tarGetter == null || (ann = tarGetter.getAnnotation(ManyToMany.class)) == null && (ann = f.getAnnotation(ManyToMany.class)) == null || (join = tarGetter.getAnnotation(JoinTable.class)) == null && (join = f.getAnnotation(JoinTable.class)) == null || (froms = join.joinColumns()) == null || froms.length == 0) continue;
            String relTable = join.name();
            String from = froms[0].name();
            String fromRefCol = froms[0].referencedColumnName();
            if (fromRefCol == null || fromRefCol.trim().length() == 0) {
                fromRefCol = ORMConfigBeanUtil.getIdColumn(this.t);
            }
            String fromRefField = ORMConfigBeanUtil.getField(this.t.getClass(), fromRefCol);
            try {
                Method fromRefFieldGetter = this.ru.getGetter(fromRefField);
                if (fromRefFieldGetter == null) {
                    throw new DAOException("can not find the 'from ref field -> " + fromRefField + "' of " + this.t.getClass() + " 's getter method", null);
                }
                Object _obj = fromRefFieldGetter.invoke(this.t, new Object[0]);
                if (_obj == null) continue;
                String fromRefVal = String.valueOf(_obj);
                final String sql1 = String.format(format, this.table, fromRefCol, newFromRefVal, fromRefCol, fromRefVal);
                final String sql2 = String.format(format, relTable, from, newFromRefVal, from, fromRefVal);
                Transaction.execute(new Trans(){

                    public void run(Object ... args) throws Exception {
                        DAOFactory.getUpdateDAO(ManyToManyDAO.this.dsName).updateBySQL(sql1);
                        DAOFactory.getUpdateDAO(ManyToManyDAO.this.dsName).updateBySQL(sql2);
                    }
                }, new Object[0]);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
    }
}

