/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FetchType;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.sql.DataSource;
import org.eweb4j.cache.DBInfoConfigBeanCache;
import org.eweb4j.cache.ORMConfigBeanCache;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.orm.Page;
import org.eweb4j.orm.PageImpl;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.dao.DAO;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.DAOFactory;
import org.eweb4j.orm.jdbc.DataSourceWrapCache;
import org.eweb4j.orm.jdbc.JdbcUtil;
import org.eweb4j.orm.sql.SqlFactory;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAOImpl
implements DAO {
    private static Log log = LogFactory.getORMLogger(DAO.class);
    private Map<String, Object> buffer = new HashMap<String, Object>();
    private String orderStr = "";
    private StringBuilder groupBy = new StringBuilder();
    private boolean express = false;
    private Map<String, Object> map;
    private Class<?> clazz;
    private Class<?> targetEntity;
    private String dsName;
    private StringBuilder sql = new StringBuilder();
    private StringBuilder condition = new StringBuilder();
    private List<Object> args = new ArrayList<Object>();
    private String dbType;
    private DataSource ds;
    private Set<String> joins = new HashSet<String>();
    private String table = null;
    private String selectAllColumn;
    private Set<String> unFetch = new HashSet<String>();
    private Set<String> fetch = new HashSet<String>();
    private List<String> updateFields = new ArrayList<String>();
    private Map<String, _AliasField> aliasMap = new HashMap<String, _AliasField>();

    public DAOImpl(String dsName) {
        this.dsName = dsName;
        this.dsName = dsName;
        this.ds = DataSourceWrapCache.get(dsName);
        this.dbType = DBInfoConfigBeanCache.get(dsName).getDataBaseType();
    }

    private void init(Class<?> clazz, String dsName) {
        if (dsName == null) {
            dsName = "myDBInfo";
        }
        this.clazz = clazz;
        this.dsName = dsName;
        this.ds = DataSourceWrapCache.get(dsName);
        this.dbType = DBInfoConfigBeanCache.get(dsName).getDataBaseType();
        if (Map.class.isAssignableFrom(clazz)) {
            if (this.map != null) {
                this.selectAllColumn = ORMConfigBeanUtil.getSelectAllColumn(this.map);
                this.table = String.valueOf((String)this.map.get("table")) + " map";
            }
        } else {
            this.table = ORMConfigBeanUtil.getTable(clazz, true);
            this.selectAllColumn = ORMConfigBeanUtil.getSelectAllColumn(clazz);
        }
        if (this.selectAllColumn == null || this.selectAllColumn.trim().length() == 0) {
            this.selectAllColumn = "*";
        }
        if (ORMConfigBeanUtil.getIdField(clazz) == null) {
            return;
        }
        this.buffer.put("orderField", ORMConfigBeanUtil.getIdField(clazz));
        this.buffer.put("orderType", -1);
    }

    public DAOImpl(Map<String, Object> map) {
        this.map = map;
        this.init(Map.class, null);
    }

    public DAOImpl(Map<String, Object> map, String dsName) {
        this.map = map;
        this.init(Map.class, dsName);
    }

    public DAOImpl(Class<?> clazz) {
        this.init(clazz, null);
    }

    public DAOImpl(Class<?> clazz, String dsName) {
        this.init(clazz, dsName);
    }

    @Override
    public DAO append(String query) {
        Map<String, Object> map = this.handleFieldAlias(query);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        if (column == null) {
            column = query;
        }
        query = ORMConfigBeanUtil.parseQuery(column, this.clazz);
        this.condition.append(" ").append(query).append(" ");
        return this;
    }

    @Override
    public DAO field(String fieldName) {
        Map<String, Object> map = this.handleFieldAlias(fieldName);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        this.condition.append(" ").append(column).append(" ");
        return this;
    }

    private Map<String, Object> handleFieldAlias(String fieldName) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        result.put("field", fieldName);
        result.put("class", this.clazz);
        int dotIndex = fieldName.indexOf(".");
        if (dotIndex > 0 && dotIndex < fieldName.length() - 1) {
            String[] dots = fieldName.split("\\.");
            StringBuilder builder = new StringBuilder();
            Class<?> lastCls = null;
            String[] stringArray = dots;
            int n = dots.length;
            int n2 = 0;
            while (n2 < n) {
                String dot = stringArray[n2];
                if (this.aliasMap.containsKey(dot)) {
                    _AliasField a = this.aliasMap.get(dot);
                    dot = a.getField();
                    lastCls = a.getCls();
                }
                if (builder.length() > 0) {
                    builder.append(".");
                }
                builder.append(dot);
                ++n2;
            }
            if (builder.length() > 0) {
                fieldName = builder.toString();
                result.put("field", fieldName);
                result.put("class", lastCls);
            }
        }
        return result;
    }

    @Override
    public DAO notLike(Object value) {
        if (!this.express) {
            this.condition.append(" NOT LIKE ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" NOT LIKE ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO notEqual(Object value) {
        if (!this.express) {
            this.condition.append(" <> ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" <> ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO equal(Object value) {
        if (!this.express) {
            this.condition.append(" = ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" = ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO moreThan(Object value) {
        if (!this.express) {
            this.condition.append(" > ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" > ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO moreEqual(Object value) {
        if (!this.express) {
            this.condition.append(" >= ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" >= ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO lessThan(Object value) {
        if (!this.express) {
            this.condition.append(" < ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            if (map == null) {
                return this;
            }
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" < ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO lessEqual(Object value) {
        if (!this.express) {
            this.condition.append(" <= ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            if (map == null) {
                return this;
            }
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" <= ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO or(String fieldName) {
        Map<String, Object> map = this.handleFieldAlias(fieldName);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        this.condition.append(" OR ").append(column).append(" ");
        return this;
    }

    @Override
    public DAO and(String fieldName) {
        Map<String, Object> map = this.handleFieldAlias(fieldName);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        this.condition.append(" AND ").append(column).append(" ");
        return this;
    }

    @Override
    public DAO orderBy(String fieldName) {
        Map<String, Object> map = this.handleFieldAlias(fieldName);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        this.orderStr = " ORDER BY " + column;
        this.buffer.put("orderField", column);
        return this;
    }

    @Override
    public DAO desc() {
        this.orderStr = String.valueOf(this.orderStr) + " DESC ";
        this.buffer.put("orderType", -1);
        return this;
    }

    @Override
    public DAO asc() {
        this.orderStr = String.valueOf(this.orderStr) + " ASC ";
        this.buffer.put("orderType", 1);
        return this;
    }

    @Override
    public DAO order(String fieldName, String orderType) {
        Map<String, Object> map = this.handleFieldAlias(fieldName);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        this.orderStr = " ORDER BY " + column + " DESC ";
        this.buffer.put("orderField", column);
        if ("asc".equalsIgnoreCase(orderType)) {
            this.buffer.put("orderType", 1);
        } else {
            this.buffer.put("orderType", -1);
        }
        return this;
    }

    @Override
    public DAO desc(String fieldName) {
        Map<String, Object> map = this.handleFieldAlias(fieldName);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        this.orderStr = " ORDER BY " + column + " DESC ";
        this.buffer.put("orderField", column);
        this.buffer.put("orderType", -1);
        return this;
    }

    @Override
    public DAO asc(String fieldName) {
        Map<String, Object> map = this.handleFieldAlias(fieldName);
        String _fieldName = (String)map.get("field");
        Class cls = (Class)map.get("class");
        String column = ORMConfigBeanUtil.getColumn(cls, _fieldName);
        this.orderStr = " ORDER BY " + column + " ASC ";
        this.buffer.put("orderField", column);
        this.buffer.put("orderType", 1);
        return this;
    }

    @Override
    public DAO sql(String sql) {
        if (sql == null) {
            return this;
        }
        this.sql = new StringBuilder(sql);
        return this;
    }

    @Override
    public <T> DAO rowMapping(Class<T> targetEntity) {
        if (targetEntity == null) {
            return this;
        }
        this.targetEntity = targetEntity;
        return this;
    }

    @Override
    public <T> T queryOne() {
        Collection<T> list = this.query();
        T result = list == null ? null : (list.size() > 0 ? (T)new ArrayList<T>(list).get(0) : null);
        return result;
    }

    @Override
    public <T> Collection<T> query() {
        return this.queryBySql(this.toSql());
    }

    @Override
    public <T> Collection<T> query(int max) {
        return this.queryPage(1, max);
    }

    @Override
    public <T> Collection<T> query(int page, int length) {
        return this.queryPage(page, length);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private <T> Collection<T> queryPage(int page, int length) {
        block9: {
            block10: {
                _sql = null;
                orderField = (String)this.buffer.get("orderField");
                oType = (Integer)this.buffer.get("orderType");
                query = String.valueOf(this.condition.toString().replace("'?'", "?")) + this.groupBy.toString();
                try {
                    obj /* !! */  = null;
                    if (Map.class.isAssignableFrom(this.clazz)) {
                        obj /* !! */  = new HashMap<K, V>();
                        ((Map)obj /* !! */ ).put("table", this.table);
                    } else {
                        obj /* !! */  = this.clazz.newInstance();
                    }
                    select = SqlFactory.getSelectSql(obj /* !! */ , this.dbType);
                    if (this.joins != null && !this.joins.isEmpty()) {
                        sb = new StringBuilder();
                        for (String j : this.joins) {
                            if (sb.length() > 0) {
                                sb.append(", ");
                            }
                            sb.append(j);
                        }
                        select.setTable(String.valueOf(this.table) + ", " + sb.toString());
                    }
                    select.setSelectAllColumn(this.selectAllColumn);
                    a = this.handleFieldAlias(orderField);
                    _sql = select.divPage(page, length, orderField, (Class)a.get("class"), oType, query.replace("WHERE", ""));
                    break block9;
                }
                catch (Exception e) {
                    _table = this.table;
                    if (this.joins == null || this.joins.isEmpty()) break block10;
                    sb = new StringBuilder();
                    ** for (j : this.joins)
                }
lbl-1000:
                // 1 sources

                {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(j);
                    continue;
                }
lbl39:
                // 1 sources

                _table = String.valueOf(this.table) + ", " + sb.toString();
            }
            _sql = this.sql.append(this.orderStr).append(" LIMIT ").append((page - 1) * length).append(", ").append(length).toString().replace("${_TABLES_}", _table).replace("${_where_}", query);
        }
        return this.queryBySql(_sql);
    }

    public <T> Collection<T> queryBySql(String sql) {
        Class<?> mappingCls = null;
        mappingCls = this.targetEntity == null ? this.clazz : this.targetEntity;
        List<?> result = null;
        try {
            if (Map.class.isAssignableFrom(mappingCls)) {
                Connection con = this.ds.getConnection();
                result = this.args != null && this.args.size() > 0 ? JdbcUtil.getListWithArgs(con, mappingCls, sql, this.args.toArray(new Object[0])) : JdbcUtil.getList(con, mappingCls, sql);
            } else {
                result = this.args != null && this.args.size() > 0 ? DAOFactory.getSelectDAO(this.dsName).selectBySQL(mappingCls, sql, this.args.toArray(new Object[0])) : DAOFactory.getSelectDAO(this.dsName).selectBySQL(mappingCls, sql, new Object[0]);
            }
            if (result != null && result.size() > 0) {
                for (Object t : result) {
                    ReflectUtil ru = new ReflectUtil(t);
                    Field[] fieldArray = ru.getFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        String f = field.getName();
                        OneToOne o2o = field.getAnnotation(OneToOne.class);
                        ManyToOne m2o = field.getAnnotation(ManyToOne.class);
                        OneToMany o2m = field.getAnnotation(OneToMany.class);
                        ManyToMany m2m = field.getAnnotation(ManyToMany.class);
                        FetchType fetchType = null;
                        boolean is2One = false;
                        if (o2o != null) {
                            fetchType = o2o.fetch();
                            is2One = true;
                        }
                        if (m2o != null) {
                            fetchType = m2o.fetch();
                            is2One = true;
                        }
                        if (o2m != null) {
                            fetchType = o2m.fetch();
                        }
                        if (m2m != null) {
                            fetchType = m2m.fetch();
                        }
                        if (fetchType != null) {
                            boolean isEntity;
                            String beanId = field.getType().getName();
                            if (!is2One) {
                                beanId = ClassUtil.getGenericType(field).getName();
                            }
                            if ((isEntity = ORMConfigBeanCache.containsKey(beanId)) && !this.unFetch.contains(f)) {
                                if (this.fetch.contains(f)) {
                                    log.debug("cascade select -> " + t.getClass().getName() + "." + f);
                                    DAOFactory.getCascadeDAO(this.dsName).select(t, f);
                                } else if (!FetchType.LAZY.equals((Object)fetchType)) {
                                    log.debug("cascade select -> " + t.getClass().getName() + "." + f);
                                    DAOFactory.getCascadeDAO(this.dsName).select(t, f);
                                }
                            }
                        }
                        ++n2;
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            log.error("sql-->" + sql + "exception:" + CommonUtil.getExceptionString(e));
            throw new DAOException(String.valueOf(sql) + " execute exception", e);
        }
    }

    @Override
    public long count() {
        String query = this.condition.toString().replace("WHERE", "").replace("'?'", "?");
        String _table = this.table;
        if (this.joins != null && !this.joins.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String j : this.joins) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(j);
            }
            _table = String.valueOf(this.table) + ", " + sb.toString();
        }
        String sql = "SELECT COUNT(*) as count FROM " + _table;
        if (query != null && query.trim().length() > 0) {
            sql = String.valueOf(sql) + " WHERE " + ORMConfigBeanUtil.parseQuery(query, this.clazz);
        }
        List<Map> maps = null;
        maps = this.args != null && this.args.size() > 0 ? DAOFactory.getSelectDAO(this.dsName).selectBySQL(Map.class, sql, this.args) : DAOFactory.getSelectDAO(this.dsName).selectBySQL(Map.class, sql, new Object[0]);
        if (maps == null || maps.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(String.valueOf(maps.get(0).get("count")));
    }

    @Override
    public DAO selectStr(String str) {
        if (str == null || this.clazz == null) {
            return this;
        }
        this.sql.append(" SELECT ").append(str).append(" FROM ").append(" ${_TABLES_} ").append(" ");
        return this;
    }

    @Override
    public DAO insert(String ... fields) {
        if (this.clazz == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        String[] columns = fields == null ? ORMConfigBeanUtil.getColumns(this.clazz) : ORMConfigBeanUtil.getColumns(this.clazz, fields);
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String col = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(col);
            ++n2;
        }
        this.sql.append(" INSERT INTO ").append(this.table.replace(" " + this.clazz.getSimpleName().toLowerCase(), "")).append("(").append(sb.toString()).append(") ");
        return this;
    }

    @Override
    public DAO values(Object ... values) {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object val = objectArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("?");
            this.args.add(val);
            ++n2;
        }
        this.sql.append(" VALUES(").append(sb.toString()).append(") ");
        return this;
    }

    @Override
    public DAO insert(Map<String, Object> map) {
        int size = map.size();
        ArrayList<String> fields = new ArrayList<String>(size);
        ArrayList<Object> values = new ArrayList<Object>(size);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            fields.add(entry.getKey());
            values.add(entry.getValue());
        }
        this.insert(fields.toArray(new String[0])).values(values.toArray(new Object[0]));
        return this;
    }

    @Override
    public DAO where() {
        this.sql.append("${_where_}");
        this.condition.append(" WHERE ");
        return this;
    }

    @Override
    public DAO isNull() {
        this.condition.append(" IS NULL ");
        return this;
    }

    @Override
    public DAO isNotNull() {
        this.condition.append(" IS NOT NULL ");
        return this;
    }

    @Override
    public Number execute() {
        Number rs = 0;
        String sql = this.sql.toString().replace("${_where_}", this.condition.toString()).replace("'?'", "?");
        DataSource ds = DataSourceWrapCache.get(this.dsName);
        try {
            rs = this.args != null && this.args.size() > 0 ? (Number)JdbcUtil.updateWithArgs(ds.getConnection(), sql, this.args.toArray(new Object[0])) : (Number)JdbcUtil.update(ds.getConnection(), sql);
        }
        catch (SQLException e) {
            log.error("sql-->" + sql + "exception:" + CommonUtil.getExceptionString(e));
            throw new DAOException(String.valueOf(sql) + " execute exception", e);
        }
        return rs;
    }

    @Override
    public DAO update(String ... fields) {
        if (this.clazz == null) {
            return this;
        }
        if (fields == null || fields.length == 0) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        String[] columns = ORMConfigBeanUtil.getColumns(this.clazz, fields);
        int i = 0;
        while (i < columns.length) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String col = columns[i];
            this.updateFields.add(col);
            ++i;
        }
        this.sql.append(" UPDATE ").append(this.table.replace(" " + this.clazz.getSimpleName().toLowerCase(), "")).append(" ");
        return this;
    }

    @Override
    public DAO set(Object ... values) {
        if (this.updateFields == null || values == null || this.updateFields.size() == 0 || values.length == 0 || this.updateFields.size() != values.length) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < values.length) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            String col = this.updateFields.get(i);
            Object val = values[i];
            sb.append(col).append(" = ? ");
            this.args.add(val);
            ++i;
        }
        this.sql.append("SET ").append(sb.toString()).append(" ");
        return this;
    }

    @Override
    public DAO update(Map<String, Object> map) {
        int size = map.size();
        ArrayList<String> fields = new ArrayList<String>(size);
        ArrayList<Object> values = new ArrayList<Object>(size);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            fields.add(entry.getKey());
            values.add(entry.getValue());
        }
        this.update(fields.toArray(new String[0])).set(values.toArray(new Object[0]));
        return this;
    }

    @Override
    public DAO delete() {
        if (this.clazz == null) {
            return this;
        }
        this.sql.append(" DELETE FROM ").append(this.table.replace(" " + this.clazz.getSimpleName().toLowerCase(), "")).append(" ");
        return this;
    }

    @Override
    public DAO selectAll() {
        this.sql.append(" SELECT ").append(this.selectAllColumn).append(" FROM ").append(" ${_TABLES_} ").append(" ");
        return this;
    }

    @Override
    public DAO select(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return this;
        }
        this.sql.append(" SELECT ");
        StringBuilder sb = new StringBuilder();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            String _selectAllColumn = ORMConfigBeanUtil.getSelectAllColumn(cls);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(_selectAllColumn);
            ++n2;
        }
        if (sb.length() > 0) {
            this.selectAllColumn = sb.toString();
        }
        this.sql.append(this.selectAllColumn).append(" FROM ").append(" ${_TABLES_} ").append(" ");
        this.rowMapping(classes[0]);
        return this;
    }

    @Override
    public DAO select(String ... fields) {
        if (fields == null || this.clazz == null) {
            return this;
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            Map<String, Object> map = this.handleFieldAlias(field);
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            sb.append(col);
            ++n2;
        }
        this.sql.append(" SELECT ").append(sb.toString()).append(" FROM ").append(" ${_TABLES_} ").append(" ");
        return this;
    }

    @Override
    public DAO likeLeft(Object value) {
        if (!this.express) {
            this.condition.append(" LIKE ? ");
            this.args.add(value + "%");
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" LIKE ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO likeRight(Object value) {
        if (!this.express) {
            this.condition.append(" LIKE ? ");
            this.args.add("%" + value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" LIKE ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO like(Object value) {
        if (!this.express) {
            this.condition.append(" LIKE ? ");
            this.args.add("%" + value + "%");
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" LIKE ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public DAO clear() {
        this.sql = null;
        this.sql = new StringBuilder();
        this.buffer.clear();
        if (ORMConfigBeanUtil.getIdField(this.clazz) != null) {
            this.buffer.put("orderField", ORMConfigBeanUtil.getIdField(this.clazz));
            this.buffer.put("orderType", -1);
        }
        this.condition = null;
        this.condition = new StringBuilder();
        this.args.clear();
        this.orderStr = "";
        this.joins.clear();
        this.express = false;
        this.aliasMap.clear();
        this.unFetch.clear();
        this.fetch.clear();
        this.updateFields.clear();
        this.targetEntity = null;
        return this;
    }

    @Override
    public DAO in(Object ... values) {
        if (values == null) {
            return this;
        }
        this.condition.append(" in(");
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (!this.express) {
                sb.append("?");
                this.args.add(o);
            } else {
                Map<String, Object> map = this.handleFieldAlias(String.valueOf(o));
                String _fieldName = (String)map.get("field");
                Class cls = (Class)map.get("class");
                String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
                sb.append(col);
            }
            ++n2;
        }
        this.condition.append(sb.toString());
        this.condition.append(") ");
        return this;
    }

    @Override
    public DAO notIn(Object ... values) {
        if (values == null) {
            return this;
        }
        this.condition.append(" not in(");
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (!this.express) {
                sb.append("?");
                this.args.add(o);
            } else {
                Map<String, Object> map = this.handleFieldAlias(String.valueOf(o));
                String _fieldName = (String)map.get("field");
                Class cls = (Class)map.get("class");
                String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
                sb.append(col);
            }
            ++n2;
        }
        this.condition.append(sb.toString());
        this.condition.append(") ");
        return this;
    }

    @Override
    public DAO inSql(String sql) {
        if (sql == null) {
            return this;
        }
        this.condition.append(" in(").append(sql).append(") ");
        return this;
    }

    @Override
    public DAO notInSql(String sql) {
        if (sql == null) {
            return this;
        }
        this.condition.append(" not in(").append(sql).append(") ");
        return this;
    }

    @Override
    public String toSql() {
        String _table = this.table;
        if (this.joins != null && !this.joins.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String j : this.joins) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(j);
            }
            _table = String.valueOf(this.table) + ", " + sb.toString();
        }
        return this.sql.append(this.orderStr).toString().replace("${_TABLES_}", _table).replace("${_where_}", String.valueOf(this.condition.toString()) + this.groupBy.toString()).replace("'?'", "?");
    }

    @Override
    public DAO fillArgs(Object ... args) {
        if (args != null) {
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                this.args.add(arg);
                ++n2;
            }
        }
        return this;
    }

    @Override
    public DAO setTable(String table) {
        this.table = table;
        return this;
    }

    @Override
    public DAO setClass(Class<?> clazz) {
        this.clazz = clazz;
        if (Map.class.isAssignableFrom(clazz)) {
            if (this.map != null) {
                this.selectAllColumn = ORMConfigBeanUtil.getSelectAllColumn(this.map);
                this.table = (String)this.map.get("table");
            }
        } else {
            this.table = ORMConfigBeanUtil.getTable(clazz, true);
            this.selectAllColumn = ORMConfigBeanUtil.getSelectAllColumn(clazz);
        }
        if (this.selectAllColumn == null || this.selectAllColumn.trim().length() == 0) {
            this.selectAllColumn = "*";
        }
        return this;
    }

    @Override
    public DAO setMap(Map<String, Object> map) {
        this.map = map;
        return this;
    }

    @Override
    public String getDsName() {
        return this.dsName;
    }

    @Override
    public <T> Page<T> getPage(int pageIndex, int pageSize) {
        PageImpl page = new PageImpl(pageIndex, pageSize, this);
        return page;
    }

    @Override
    public DAO enableExpress(boolean flag) {
        this.express = flag;
        return this;
    }

    @Override
    public DAO alias(String alias) {
        if (alias == null || alias.trim().length() == 0) {
            return this;
        }
        _AliasField a = new _AliasField(alias, this.clazz.getSimpleName().toLowerCase(), this.clazz);
        this.aliasMap.put(alias, a);
        return this;
    }

    @Override
    public DAO join(String fieldName) {
        return this.join(fieldName, fieldName);
    }

    @Override
    public DAO join(String fieldName, String alias) {
        if (fieldName == null || alias == null) {
            return this;
        }
        this.handleJoin(0, fieldName, alias);
        return this;
    }

    @Override
    public DAO leftJoin(String fieldName) {
        return this.leftJoin(fieldName, fieldName);
    }

    @Override
    public DAO leftJoin(String fieldName, String alias) {
        if (fieldName == null || alias == null) {
            return this;
        }
        this.handleJoin(1, fieldName, alias);
        return this;
    }

    @Override
    public DAO rightJoin(String fieldName) {
        return this.rightJoin(fieldName, fieldName);
    }

    @Override
    public DAO rightJoin(String fieldName, String alias) {
        if (fieldName == null || alias == null) {
            return this;
        }
        this.handleJoin(2, fieldName, alias);
        return this;
    }

    @Override
    public DAO fullJoin(String fieldName) {
        return this.fullJoin(fieldName, fieldName);
    }

    @Override
    public DAO fullJoin(String fieldName, String alias) {
        if (fieldName == null || alias == null) {
            return this;
        }
        this.handleJoin(3, fieldName, alias);
        return this;
    }

    private void handleJoin(int type, String _fieldName, String _alias) {
        String[] fDots = _fieldName.split("\\.");
        String[] aDots = _alias.split("\\.");
        Class<?> currentClazz = this.clazz;
        int i = 0;
        while (i < fDots.length) {
            String fieldName = fDots[i];
            String alias = aDots[i];
            ReflectUtil ru = null;
            try {
                ru = new ReflectUtil(currentClazz);
                Field field = ru.getField(fieldName);
                if (field == null) {
                    throw new Exception("field->" + fieldName + " invalid");
                }
                Class<?> cls = ClassUtil.getGenericType(field);
                if (cls == null) {
                    throw new Exception("can not get the field->" + fieldName + " class");
                }
                if (!ORMConfigBeanCache.containsKey(cls.getName())) {
                    throw new Exception("field->" + fieldName + " of " + cls.getName() + " is not entity");
                }
                String table = ORMConfigBeanUtil.getTable(cls, true);
                this.joins.add(table);
                _AliasField a = new _AliasField(alias, cls.getSimpleName().toLowerCase(), cls);
                this.aliasMap.put(alias, a);
                currentClazz = cls;
            }
            catch (Exception e) {
                log.error(e.toString());
            }
            ++i;
        }
    }

    @Override
    public DAO on() {
        return null;
    }

    @Override
    public DAO groupBy(String ... fieldNames) {
        if (fieldNames == null || fieldNames.length == 0) {
            return this;
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            Map<String, Object> map = this.handleFieldAlias(field);
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(col);
            ++n2;
        }
        this.groupBy.append(" group by ").append(builder.toString()).append(" ");
        return this;
    }

    @Override
    public DAO fetch(String ... fields) {
        if (fields == null) {
            return this;
        }
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            this.fetch.add(field);
            ++n2;
        }
        return this;
    }

    @Override
    public DAO unfetch(String ... fields) {
        if (fields == null) {
            return this;
        }
        String[] stringArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            this.unFetch.add(field);
            ++n2;
        }
        return this;
    }

    @Override
    public DAO likeEqual(Object value) {
        if (value == null) {
            return this;
        }
        if (!this.express) {
            this.condition.append(" LIKE ? ");
            this.args.add(value);
        } else {
            Map<String, Object> map = this.handleFieldAlias(String.valueOf(value));
            String _fieldName = (String)map.get("field");
            Class cls = (Class)map.get("class");
            String col = ORMConfigBeanUtil.getColumn(cls, _fieldName);
            this.condition.append(" LIKE ").append(col).append(" ");
        }
        return this;
    }

    @Override
    public List<Object> getArgs() {
        return this.args;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class _AliasField {
        private String alias;
        private String field;
        private Class<?> cls;

        public _AliasField() {
        }

        public _AliasField(String alias, String field, Class<?> cls) {
            this.alias = alias;
            this.field = field;
            this.cls = cls;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Class<?> getCls() {
            return this.cls;
        }

        public void setCls(Class<?> cls) {
            this.cls = cls;
        }
    }
}

