/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.eweb4j.cache.ORMConfigBeanCache;
import org.eweb4j.config.Log;
import org.eweb4j.config.ScanPackage;
import org.eweb4j.orm.annotation.Ignore;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.config.bean.ORMConfigBean;
import org.eweb4j.orm.config.bean.Property;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoAnnotationConfig
extends ScanPackage {
    @Override
    public boolean handleClass(String clsName) {
        Class<?> clazz = PojoAnnotationConfig.getClass(clsName);
        if (clazz == null) {
            return false;
        }
        if (clazz.isInterface()) {
            return false;
        }
        Entity entity = clazz.getAnnotation(Entity.class);
        if (!(entity != null || clsName.endsWith("PO") || clsName.endsWith("POJO") || clsName.endsWith("Entity") || clsName.endsWith("Model"))) {
            return false;
        }
        Table tableAnn = clazz.getAnnotation(Table.class);
        String table = tableAnn == null ? "" : tableAnn.name();
        String string = table = "".equals(table.trim()) ? clazz.getSimpleName().replace("PO", "").replace("POJO", "").replace("Entity", "").replace("Model", "") : table;
        if (table == null || table.trim().length() == 0) {
            return false;
        }
        try {
            List<Property> pList = PojoAnnotationConfig.getProperties(clazz, null, false, log);
            ArrayList<Property> superList = new ArrayList<Property>();
            Class<?> superClazz = clazz.getSuperclass();
            while (superClazz != Object.class && superClazz != null) {
                List<Property> list;
                if (superClazz.isAnnotationPresent(MappedSuperclass.class) && (list = PojoAnnotationConfig.getProperties(superClazz, pList, true, log)) != null) {
                    superList.addAll(list);
                }
                superClazz = superClazz.getSuperclass();
            }
            ArrayList<Property> properties = new ArrayList<Property>(superList);
            properties.addAll(pList);
            ORMConfigBean ormBean = new ORMConfigBean();
            ormBean.setClazz(clazz.getName());
            ormBean.setId(clazz.getSimpleName());
            ormBean.setTable(table);
            ormBean.setProperty(properties);
            ORMConfigBeanCache.add(clazz.getName(), ormBean);
        }
        catch (Error er) {
            log.warn("the entity class new instance failued -> " + clsName + " | " + er.toString());
            return false;
        }
        catch (Exception e) {
            log.warn("the entity class new instance failued -> " + clsName + " | " + e.toString());
            return false;
        }
        return true;
    }

    private static boolean hasIdProperty(List<Property> list) {
        for (Property p : list) {
            if (!"1".equals(p.getAutoIncrement()) || !"1".equals(p.getPk())) continue;
            return true;
        }
        return false;
    }

    private static List<Property> getProperties(Class<?> clazz, List<Property> pList, boolean requireSuper, Log log) throws Exception {
        ReflectUtil ru;
        ArrayList<Property> result = new ArrayList<Property>();
        try {
            ru = new ReflectUtil(clazz);
            ru.setRequiredSuper(requireSuper);
        }
        catch (Error e) {
            log.warn(e.toString());
            throw e;
        }
        catch (Exception e) {
            log.warn(e.toString());
            throw e;
        }
        Field[] fieldArray = ru.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            block31: {
                Column colAnn;
                Property p;
                String name;
                Method getter;
                Field f;
                block32: {
                    ManyToMany manyManyAnn;
                    OneToMany manyAnn;
                    f = fieldArray[n2];
                    if (Collection.class.isAssignableFrom(f.getType()) || (getter = ru.getGetter(name = f.getName())) == null) break block31;
                    Ignore igAnn = f.getAnnotation(Ignore.class);
                    if (igAnn == null) {
                        igAnn = getter.getAnnotation(Ignore.class);
                    }
                    if (igAnn != null) break block31;
                    Transient trans = f.getAnnotation(Transient.class);
                    if (trans == null) {
                        trans = getter.getAnnotation(Transient.class);
                    }
                    if (trans != null || (manyAnn = getter.getAnnotation(OneToMany.class)) != null || (manyAnn = f.getAnnotation(OneToMany.class)) != null || (manyManyAnn = getter.getAnnotation(ManyToMany.class)) != null || (manyManyAnn = f.getAnnotation(ManyToMany.class)) != null) break block31;
                    p = new Property();
                    if (Long.class.isAssignableFrom(f.getType()) || Long.TYPE.isAssignableFrom(f.getType())) {
                        p.setSize("20");
                    } else if (Integer.class.isAssignableFrom(f.getType()) || Integer.TYPE.isAssignableFrom(f.getType())) {
                        p.setSize("8");
                    } else if (String.class.isAssignableFrom(f.getType())) {
                        p.setSize("255");
                    } else if (Boolean.class.isAssignableFrom(f.getType()) || Boolean.TYPE.isAssignableFrom(f.getType())) {
                        p.setSize("");
                    } else if (Float.class.isAssignableFrom(f.getType()) || Float.TYPE.isAssignableFrom(f.getType())) {
                        p.setSize("8");
                    }
                    Id idAnn = getter.getAnnotation(Id.class);
                    if (idAnn == null) {
                        idAnn = f.getAnnotation(Id.class);
                    }
                    if (idAnn == null) break block32;
                    if (pList != null && PojoAnnotationConfig.hasIdProperty(pList)) break block31;
                    p.setAutoIncrement("1");
                    p.setPk("1");
                    p.setSize("20");
                }
                if ((colAnn = getter.getAnnotation(Column.class)) == null) {
                    colAnn = f.getAnnotation(Column.class);
                }
                String column = colAnn == null ? "" : colAnn.name();
                column = "".equals(column.trim()) ? name : column;
                p.setName(name);
                p.setColumn(column);
                p.setType(f.getType().getName());
                p.setNotNull("false");
                if (colAnn != null) {
                    p.setNotNull(String.valueOf(!colAnn.nullable()));
                    p.setUnique(String.valueOf(colAnn.unique()));
                }
                if (ClassUtil.isPojo(f.getType())) {
                    OneToOne oneAnn = getter.getAnnotation(OneToOne.class);
                    if (oneAnn == null) {
                        oneAnn = f.getAnnotation(OneToOne.class);
                    }
                    ManyToOne manyToOneAnn = null;
                    if (oneAnn == null && (manyToOneAnn = getter.getAnnotation(ManyToOne.class)) == null) {
                        manyToOneAnn = f.getAnnotation(ManyToOne.class);
                    }
                    if (oneAnn != null || manyToOneAnn != null) {
                        String relField;
                        if (oneAnn != null) {
                            p.setType("oneOne");
                        } else {
                            p.setType("manyOne");
                        }
                        JoinColumn joinColumn = getter.getAnnotation(JoinColumn.class);
                        if (joinColumn == null) {
                            joinColumn = f.getAnnotation(JoinColumn.class);
                        }
                        if (joinColumn != null && joinColumn.name().trim().length() > 0) {
                            p.setColumn(joinColumn.name());
                        } else {
                            p.setColumn(String.valueOf(f.getName()) + "_id");
                        }
                        p.setRelProperty(null);
                        String refCol = null;
                        if (joinColumn != null && joinColumn.referencedColumnName().trim().length() > 0 && (refCol = joinColumn.referencedColumnName()) != null && refCol.trim().length() > 0 && (relField = ORMConfigBeanUtil.getField(f.getType(), refCol)) != null && relField.trim().length() > 0) {
                            p.setRelProperty(relField);
                        }
                        p.setRelClass(f.getType());
                        p.setSize("20");
                    }
                }
                result.add(p);
            }
            ++n2;
        }
        return result;
    }

    private static Class<?> getClass(String clsName) {
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(clsName);
        }
        catch (Error e) {}
        catch (Exception e) {}
        finally {
            return null;
        }
        return clazz;
    }

    @Override
    protected void onOk() throws Exception {
        for (Map.Entry<Object, ORMConfigBean> e : ORMConfigBeanCache.entrySet()) {
            ORMConfigBean orm = e.getValue();
            Class<?> clazz = null;
            ReflectUtil ru = null;
            for (Property p : orm.getProperty()) {
                String type = p.getType();
                if (!"oneOne".equals(type) && !"manyOne".equals(type) || p.getRelProperty() != null && p.getRelProperty().trim().length() > 0) continue;
                if (clazz == null) {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(orm.getClazz());
                }
                if (ru == null) {
                    ru = new ReflectUtil(clazz);
                }
                Field f = ru.getField(p.getName());
                String refCol = ORMConfigBeanUtil.getIdColumn(f.getType());
                p.setRelProperty(ORMConfigBeanUtil.getField(f.getType(), refCol));
            }
        }
    }
}

