/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.config;

import java.io.File;
import java.util.List;
import org.eweb4j.cache.ORMConfigBeanCache;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.CheckConfigBean;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.orm.config.ORMConfigBeanCreator;
import org.eweb4j.orm.config.bean.ORMConfigBean;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.FileUtil;
import org.eweb4j.util.xml.BeanXMLUtil;
import org.eweb4j.util.xml.XMLReader;
import org.eweb4j.util.xml.XMLWriter;

public class ORMConfig {
    private static Log log = LogFactory.getORMLogger(ORMConfig.class);

    public static synchronized String check() {
        String error = null;
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        if (cb == null) {
            return null;
        }
        List<String> ormXmlFilePaths = cb.getOrm().getOrmXmlFiles().getPath();
        for (String filePath : ormXmlFilePaths) {
            if (filePath == null || filePath.length() == 0) continue;
            File configFile = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + filePath);
            try {
                XMLReader reader = BeanXMLUtil.getBeanXMLReader(configFile);
                reader.setBeanName("orm");
                reader.setClass("orm", ORMConfigBean.class);
                List<ORMConfigBean> ormList = reader.read();
                if (ormList == null || ormList.isEmpty()) {
                    error = ORMConfig.rebuildXmlFile(configFile, "can not read any configuration! now it has bean repaired, please restart.");
                    continue;
                }
                for (ORMConfigBean orm : ormList) {
                    String error2;
                    String error1 = CheckConfigBean.checkORM(orm, filePath);
                    if (error1 != null) {
                        error = error == null ? error1 : String.valueOf(error) + error1;
                    }
                    if ((error2 = CheckConfigBean.checkORMProperty(orm.getProperty(), ormList, orm.getId(), filePath)) == null) continue;
                    error = error == null ? error2 : String.valueOf(error) + error2;
                }
                if (error != null) continue;
                for (ORMConfigBean orm : ormList) {
                    if ("".equals(orm.getClazz())) continue;
                    ORMConfigBeanCache.add(orm.getClazz(), orm);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error = ORMConfig.rebuildXmlFile(configFile, CommonUtil.getExceptionString(e));
            }
        }
        if (error != null) {
            ORMConfigBeanCache.clear();
        } else {
            log.debug("start configuration has bean validated and pushed to the cache");
        }
        return error;
    }

    private static String rebuildXmlFile(File configFile, String err) {
        String error;
        try {
            File tf = new File(String.valueOf(configFile.getAbsolutePath()) + ".back" + CommonUtil.getNowTime("_MMddHHmmss"));
            FileUtil.copy(configFile, tf);
            log.debug("backup file ->" + tf.getAbsolutePath());
            XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(configFile, (Object)ORMConfigBeanCreator.getORMBean());
            writer.setBeanName("orm");
            writer.setClass("orm", ORMConfigBean.class);
            writer.write();
            StringBuilder sb = new StringBuilder("configuration error, now it has bean reparied. exception\uff1a");
            sb.append(err);
            error = sb.toString();
            log.error(error);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            StringBuilder sb3 = new StringBuilder(CommonUtil.getExceptionString(e1));
            sb3.append("can not write any configuration, exception:");
            error = sb3.toString();
            log.error(error);
        }
        return error;
    }
}

