/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.validator;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eweb4j.mvc.action.Validation;
import org.eweb4j.mvc.config.bean.FieldConfigBean;
import org.eweb4j.mvc.config.bean.ValidatorConfigBean;
import org.eweb4j.mvc.validator.ValidatorIF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorHelper
implements ValidatorIF {
    private String regex;

    public ValidatorHelper(String regex) {
        this.regex = regex;
    }

    @Override
    public Validation validate(ValidatorConfigBean val, Map<String, String[]> map, HttpServletRequest request) {
        HashMap<String, String> valError = new HashMap<String, String>();
        for (FieldConfigBean f : val.getField()) {
            String key = f.getName();
            String[] value = map.get(key);
            if (value == null || value.length == 0) continue;
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.matches(this.regex)) {
                    String mess = f.getMessage();
                    if (mess.length() == 0) {
                        mess = " %s-validator : your input { %s = %s } must matches [ %s ]";
                    }
                    valError.put(key, String.format(mess, val.getName(), key, v, this.regex));
                    break;
                }
                ++n2;
            }
            request.setAttribute(key, (Object)value);
        }
        Validation validation = new Validation();
        if (!valError.isEmpty()) {
            validation.getErrors().put(val.getName(), valError);
        }
        return validation;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }
}

