/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.validator;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.mvc.action.Validation;
import org.eweb4j.mvc.config.bean.ValidatorConfigBean;
import org.eweb4j.mvc.validator.ValidatorFactory;
import org.eweb4j.mvc.validator.ValidatorIF;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidateExecution {
    private static Log log = LogFactory.getMVCLogger(ValidateExecution.class);

    public static Validation checkValidate(List<ValidatorConfigBean> valList, Map<String, String[]> paramMap, HttpServletRequest req) {
        Validation validation = new Validation();
        if (valList == null || valList.isEmpty()) {
            return validation;
        }
        int i = valList.size() - 1;
        while (i > -1) {
            ValidatorConfigBean val = valList.get(i);
            ValidatorIF validator = null;
            if (!"".equals(val.getName()) && (validator = ValidatorFactory.getValidator(val.getName())) == null) {
                try {
                    validator = (ValidatorIF)Thread.currentThread().getContextClassLoader().loadClass(val.getClazz()).newInstance();
                }
                catch (Exception e) {
                    log.error(CommonUtil.getExceptionString(e));
                }
            }
            if (validator != null) {
                Map<String, Map<String, String>> err = validator.validate(val, paramMap, req).getErrors();
                for (Map.Entry<String, Map<String, String>> en : err.entrySet()) {
                    String key = en.getKey();
                    Map<String, String> value = en.getValue();
                    if (validation.getErrors().containsKey(key)) {
                        validation.getErrors().get(key).putAll(value);
                        continue;
                    }
                    validation.getErrors().put(key, value);
                }
            }
            --i;
        }
        return validation;
    }
}

