/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.interceptor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eweb4j.cache.ActionConfigBeanCache;
import org.eweb4j.cache.InterConfigBeanCache;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.action.ActionExecution;
import org.eweb4j.mvc.config.MVCConfigConstant;
import org.eweb4j.mvc.config.bean.ActionConfigBean;
import org.eweb4j.mvc.config.bean.InterConfigBean;
import org.eweb4j.mvc.config.bean.Uri;
import org.eweb4j.mvc.interceptor.InterPriorityComparator;
import org.eweb4j.mvc.view.JSPRendererImpl;
import org.eweb4j.mvc.view.RenderFactory;
import org.eweb4j.mvc.view.Renderer;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterExecution {
    private static Log log = LogFactory.getMVCLogger(InterExecution.class);
    private String interType = null;
    private Context context = null;
    private String error = null;

    public InterExecution(String interType, Context context) {
        this.interType = interType;
        this.context = context;
        Map<String, List<?>> map = null;
        if ((ActionConfigBeanCache.containsKey(this.context.getUri()) || (map = ActionConfigBeanCache.getByMatches(this.context.getUri(), context.getHttpMethod())) != null) && map.containsKey("mvcBean")) {
            ActionConfigBean acb = (ActionConfigBean)((List)map.get("mvcBean")).get(0);
            this.context.setActionConfigBean(acb);
        }
    }

    public boolean findAndExecuteInter() throws Exception {
        List<InterConfigBean> list = InterConfigBeanCache.getList();
        Collections.sort(list, new InterPriorityComparator());
        int listSize = list.size();
        int index = 0;
        while (index < listSize) {
            InterConfigBean inter = list.get(index);
            String _interType = inter.getType();
            if (this.interType.equals(_interType)) {
                String uri = this.context.getUri();
                if (uri.length() == 0) {
                    uri = " ";
                }
                if (!inter.getExcept().contains(uri)) {
                    String policy = inter.getPolicy();
                    boolean isOR = "or".equalsIgnoreCase(policy);
                    List<Uri> uris = inter.getUri();
                    int size = uris.size();
                    boolean canProcess = false;
                    int i = 0;
                    while (i < size) {
                        Uri u = uris.get(i);
                        String type = u.getType();
                        String value = u.getValue();
                        boolean found = true;
                        if (!("start".equalsIgnoreCase(type) && uri.startsWith(value) || "end".equalsIgnoreCase(type) && uri.endsWith(value) || "contains".equalsIgnoreCase(type) && uri.contains(value) || "all".equalsIgnoreCase(type) && uri.equals(value) || "regex".equalsIgnoreCase(type) && uri.matches(value))) {
                            if ("actions".equalsIgnoreCase(type)) {
                                if (!this.findActionUriMapping()) {
                                    found = false;
                                }
                            } else if (!("!start".equalsIgnoreCase(type) && !uri.startsWith(value) || "!end".equalsIgnoreCase(type) && !uri.endsWith(value) || "!contains".equalsIgnoreCase(type) && !uri.contains(value) || "!all".equalsIgnoreCase(type) && !uri.equals(value) || "!regex".equalsIgnoreCase(type) && !uri.matches(value))) {
                                if ("!actions".equalsIgnoreCase(type)) {
                                    if (ActionConfigBeanCache.containsKey(uri) || ActionConfigBeanCache.getByMatches(uri, this.context.getHttpMethod()) != null) {
                                        found = false;
                                    }
                                } else if (!"*".equals(type)) {
                                    found = false;
                                }
                            }
                        }
                        log.debug("uri -> " + value + " found -> " + found);
                        if (isOR) {
                            if (found) {
                                canProcess = true;
                                break;
                            }
                        } else {
                            if (!found) {
                                canProcess = false;
                                break;
                            }
                            canProcess = true;
                        }
                        ++i;
                    }
                    if (canProcess) {
                        this.doIntercept(inter);
                        if (this.error != null) {
                            log.debug("do interceptor -> " + inter.getClazz() + " error -> " + this.error);
                            this.logErr();
                            return true;
                        }
                    }
                }
            }
            ++index;
        }
        return false;
    }

    private void doIntercept(InterConfigBean inter) throws Exception {
        ReflectUtil ru;
        Method intercept;
        Object interceptor = null;
        if ("singleton".equalsIgnoreCase(inter.getScope())) {
            interceptor = SingleBeanCache.get(inter.getClazz());
        }
        if (interceptor == null) {
            interceptor = Thread.currentThread().getContextClassLoader().loadClass(inter.getClazz()).newInstance();
            if ("singleton".equalsIgnoreCase(inter.getScope())) {
                SingleBeanCache.add(inter.getClazz(), interceptor);
            }
        }
        if ((intercept = (ru = new ReflectUtil(interceptor)).getMethod(inter.getMethod())) == null) {
            this.error = null;
            return;
        }
        Method setter = ru.getSetter("Context");
        if (setter != null) {
            setter.invoke(interceptor, this.context);
        }
        Object err = null;
        Class<?>[] paramCls = intercept.getParameterTypes();
        err = paramCls.length == 1 && paramCls[0].isAssignableFrom(Context.class) ? intercept.invoke(interceptor, this.context) : intercept.invoke(interceptor, new Object[0]);
        if (err == null) {
            this.error = null;
            return;
        }
        this.error = String.valueOf(err);
    }

    public void execute(Class<?> _interceptor) throws Exception {
        Object interceptor = _interceptor.newInstance();
        for (InterConfigBean inter : InterConfigBeanCache.getList()) {
            if (!inter.getClazz().equals(interceptor.getClass().getName())) continue;
            this.doIntercept(inter);
            return;
        }
    }

    private boolean findActionUriMapping() {
        boolean result = false;
        Map<String, List<?>> map = null;
        if ((ActionConfigBeanCache.containsKey(this.context.getUri()) || (map = ActionConfigBeanCache.getByMatches(this.context.getUri(), this.context.getHttpMethod())) != null) && map.containsKey("mvcBean")) {
            ActionConfigBean acb = (ActionConfigBean)((List)map.get("mvcBean")).get(0);
            this.context.setActionConfigBean(acb);
            result = true;
        }
        return result;
    }

    public void showErr() throws Exception {
        String re = this.error;
        String baseUrl = (String)this.context.getServletContext().getAttribute(MVCConfigConstant.BASE_URL_KEY);
        if (re.startsWith("redirect:")) {
            String url;
            String location = url = re.substring("redirect:".length());
            this.context.getResponse().sendRedirect(CommonUtil.replaceChinese2Utf8(location));
            return;
        }
        if (re.startsWith("action:")) {
            String path = re.substring("action:".length());
            ActionExecution.handleActionRedirect(this.context, path, baseUrl);
            return;
        }
        if (re.startsWith("out:")) {
            String location = re.substring("out:".length());
            this.context.getWriter().print(location);
            this.context.getWriter().flush();
            return;
        }
        if (re.startsWith("forward:") || re.startsWith("jsp:") || re.endsWith(".jsp")) {
            String[] str = re.split("@");
            String location = re = str[0];
            if (re.startsWith("forward:")) {
                location = re.substring("forward:".length());
            } else if (re.startsWith("jsp:")) {
                location = re.substring("jsp:".length());
            }
            JSPRendererImpl render = new JSPRendererImpl();
            render.setContext(this.context);
            if (str.length > 1) {
                render.layout(str[1]);
            }
            render.target(location).render(this.context.getWriter(), this.context.getModel());
            return;
        }
        if (re.startsWith("fmt:") || re.startsWith("fm:") || re.endsWith(".fm")) {
            String[] str = re.split("@");
            String location = re = str[0];
            if (re.startsWith("fmt:")) {
                location = re.substring("fmt:".length());
            } else if (re.startsWith("fm:")) {
                location = re.substring("fm:".length());
            }
            Renderer render = RenderFactory.create("fmt").target(location);
            if (str.length > 1) {
                render.layout(str[1]);
            }
            render.render(this.context.getWriter(), this.context.getModel());
            this.context.getWriter().flush();
            return;
        }
        if (re.startsWith("vt:") || re.startsWith("vm:") || re.endsWith(".vm")) {
            String[] str = re.split("@");
            String location = re = str[0];
            if (re.startsWith("vt:")) {
                location = re.substring("vt:".length());
            } else if (re.startsWith("vm:")) {
                location = re.substring("vm:".length());
            }
            Renderer render = RenderFactory.create("vt").target(location);
            if (str.length > 1) {
                render.layout(str[1]);
            }
            render.render(this.context.getWriter(), this.context.getModel());
            this.context.getWriter().flush();
            return;
        }
        this.context.getWriter().print(re);
        this.context.getWriter().flush();
    }

    private void logErr() {
        StringBuilder sb = new StringBuilder();
        sb.append("intercepte -> ").append(this.context.getUri());
        sb.append(" error info -> ").append(this.error);
        log.debug(sb.toString());
    }

    public String getError() {
        return this.error;
    }
}

