/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.config;

import java.io.File;
import java.util.List;
import org.eweb4j.cache.ActionConfigBeanCache;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.CheckConfigBean;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.mvc.config.MVCConfigBeanCreator;
import org.eweb4j.mvc.config.MVCConfigConstant;
import org.eweb4j.mvc.config.bean.ActionConfigBean;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.FileUtil;
import org.eweb4j.util.xml.BeanXMLUtil;
import org.eweb4j.util.xml.XMLReader;
import org.eweb4j.util.xml.XMLWriter;

public class ActionConfig {
    private static Log log = LogFactory.getMVCLogger(ActionConfig.class);

    public static synchronized String check() {
        String error = null;
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        if (cb == null) {
            return null;
        }
        List<String> xmlFilePaths = cb.getMvc().getActionXmlFiles().getPath();
        for (String filePath : xmlFilePaths) {
            if (filePath == null || filePath.length() == 0) continue;
            File configFile = new File(String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + filePath);
            try {
                XMLReader reader = BeanXMLUtil.getBeanXMLReader(configFile);
                reader.setBeanName("action");
                reader.setClass("action", ActionConfigBean.class);
                List mvcList = reader.read();
                if (mvcList == null || mvcList.isEmpty()) {
                    error = ActionConfig.rebuildXmlFile(configFile, "can not read any configuration! now it has bean repaired, please restart.");
                    continue;
                }
                for (ActionConfigBean mvc : mvcList) {
                    String error4;
                    String error2;
                    String error1 = CheckConfigBean.checkMVCAction(mvc, filePath);
                    if (error1 != null) {
                        error = error != null ? String.valueOf(error) + error1 : error1;
                    }
                    if ((error2 = CheckConfigBean.checkMVCResultPart(mvc.getResult(), mvc.getUriMapping(), filePath)) != null) {
                        error = error != null ? String.valueOf(error) + error2 : error2;
                    }
                    if ((error4 = CheckConfigBean.checkMVCValidator(mvc.getValidator(), mvc.getUriMapping(), filePath)) == null) continue;
                    error = error != null ? String.valueOf(error) + error4 : error4;
                }
                if (error != null) continue;
                for (ActionConfigBean mvc : mvcList) {
                    if ("".equals(mvc.getClazz()) || "".equals(mvc.getUriMapping())) continue;
                    ActionConfigBeanCache.add(mvc.getUriMapping(), mvc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error = ActionConfig.rebuildXmlFile(configFile, CommonUtil.getExceptionString(e));
            }
        }
        if (error != null) {
            ActionConfigBeanCache.clear();
        }
        return error;
    }

    private static String rebuildXmlFile(File configFile, String err) {
        String error;
        try {
            File tf = new File(String.valueOf(configFile.getAbsolutePath()) + ".back" + CommonUtil.getNowTime("_MMddHHmmss"));
            FileUtil.copy(configFile, tf);
            log.debug("backup file->" + tf.getAbsolutePath());
            XMLWriter writer = BeanXMLUtil.getBeanXMLWriter(configFile, (Object)MVCConfigBeanCreator.getActionBean());
            writer.setBeanName("action");
            writer.setClass("action", ActionConfigBean.class);
            writer.write();
            StringBuilder tsb = new StringBuilder("configuration error, now it has bean reparied. exception\uff1a");
            tsb.append(err);
            error = tsb.toString();
            log.error(error);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            StringBuilder sb2 = new StringBuilder("can not write any configuration, exception:");
            sb2.append(CommonUtil.getExceptionString(e1));
            error = sb2.toString();
            log.error(error);
        }
        return error;
    }

    public static void setLAYOUT_SCREEN_CONTENT_KEY(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        MVCConfigConstant.LAYOUT_SCREEN_CONTENT_KEY = key;
    }

    public static void setBASE_URL_KEY(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        MVCConfigConstant.BASE_URL_KEY = key;
    }

    public static void setREQ_PARAM_SCOPE_KEY(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        MVCConfigConstant.REQ_PARAM_SCOPE_KEY = key;
    }

    public static void setFORWARD_BASE_PATH(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        MVCConfigConstant.FORWARD_BASE_PATH = key;
    }

    public static void setHTTP_METHOD_PARAM(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        MVCConfigConstant.HTTP_METHOD_PARAM = key;
    }

    public static void setHTTP_HEADER_ACCEPT_PARAM(String key) {
        if (key == null || key.trim().length() == 0) {
            return;
        }
        MVCConfigConstant.HTTP_HEADER_ACCEPT_PARAM = key;
    }
}

