/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.config;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eweb4j.cache.ActionConfigBeanCache;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.ScanPackage;
import org.eweb4j.mvc.action.annotation.ActionLevel;
import org.eweb4j.mvc.action.annotation.Controller;
import org.eweb4j.mvc.action.annotation.Result;
import org.eweb4j.mvc.action.annotation.ShowValMess;
import org.eweb4j.mvc.action.annotation.Singleton;
import org.eweb4j.mvc.config.ActionClassCache;
import org.eweb4j.mvc.config.ActionUrlUtil;
import org.eweb4j.mvc.config.JAXWSUtil;
import org.eweb4j.mvc.config.PathUtil;
import org.eweb4j.mvc.config.ProducesUtil;
import org.eweb4j.mvc.config.ResultAnnUtil;
import org.eweb4j.mvc.config.bean.ActionConfigBean;
import org.eweb4j.mvc.config.bean.ResultConfigBean;
import org.eweb4j.mvc.config.bean.ValidatorConfigBean;
import org.eweb4j.mvc.config.creator.ValidatorUtil;
import org.eweb4j.mvc.validator.annotation.Validate;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionAnnotationConfig
extends ScanPackage {
    public static final Log log = LogFactory.getMVCLogger(ActionAnnotationConfig.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleClass(String clsName) {
        Class<?> cls = null;
        try {
            ReflectUtil ru;
            Method[] ms;
            Object obj;
            String moduleName;
            block20: {
                cls = Thread.currentThread().getContextClassLoader().loadClass(clsName);
                if (cls == null) {
                    return false;
                }
                String simpleName = cls.getSimpleName();
                Controller controlAnn = cls.getAnnotation(Controller.class);
                if (!(controlAnn != null || simpleName.endsWith("Controller") || simpleName.endsWith("Action") || simpleName.endsWith("Control"))) {
                    return false;
                }
                moduleName = CommonUtil.toLowCaseFirst(simpleName.replace("Controller", "").replace("Control", ""));
                if (simpleName.endsWith("Action")) {
                    moduleName = "";
                }
                if ("application".equals(moduleName)) {
                    moduleName = "/";
                }
                obj = null;
                try {
                    if (cls.getAnnotation(Singleton.class) != null) {
                        obj = SingleBeanCache.get(cls.getName());
                        if (obj == null) {
                            obj = cls.newInstance();
                            SingleBeanCache.add(cls.getName(), obj);
                        }
                        break block20;
                    }
                    obj = cls.newInstance();
                }
                catch (Error er) {
                    log.warn("the action class new instance failued -> " + clsName + " | " + er.toString());
                    return false;
                }
                catch (Exception e) {
                    log.warn("the action class new instance failued -> " + clsName + " | " + e.toString());
                    return false;
                }
            }
            if ((ms = (ru = new ReflectUtil(obj)).getMethods()) == null) {
                return false;
            }
            Method[] methodArray = ms;
            int n = ms.length;
            int n2 = 0;
            while (true) {
                block21: {
                    Method m;
                    block22: {
                        if (n2 >= n) {
                            return true;
                        }
                        m = methodArray[n2];
                        if (m.getModifiers() != 1) break block21;
                        boolean hasPath = JAXWSUtil.hasPath(m);
                        if (hasPath) break block22;
                        String methodName = m.getName();
                        Method getter = ru.getGetter(methodName.replace("get", ""));
                        Method setter = ru.getSetter(methodName.replace("set", ""));
                        if (getter != null || setter != null) break block21;
                    }
                    this.handleActionConfigInfo(ru, cls, m, moduleName);
                }
                ++n2;
            }
        }
        catch (Error e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void handleActionConfigInfo(ReflectUtil ru, Class<?> controller, Method method, String moduleName) {
        String actionConfigKey;
        List<ValidatorConfigBean> vals;
        Result resultAnn;
        String uriMapping;
        ActionConfigBean action = this.parseUriMappingSuffix(moduleName, method);
        if (action == null) {
            return;
        }
        action.setClazz(controller.getName());
        action.setMethod(method.getName());
        String httpMethod = ActionAnnotationConfig.parseHttpMethodByAnnotation(controller, method);
        if (httpMethod != null && httpMethod.trim().length() > 0) {
            action.setHttpMethod(httpMethod);
        }
        if ((uriMapping = ActionAnnotationConfig.parseUriMapping(controller, moduleName, action.getUriMapping())) != null && uriMapping.trim().length() > 0) {
            action.setUriMapping(uriMapping);
        }
        if ((resultAnn = method.getAnnotation(Result.class)) != null) {
            action.getResult().addAll(ResultAnnUtil.readResultAnn(resultAnn));
        }
        int level = ActionAnnotationConfig.parseActionLevel(controller, method);
        action.setLevel(String.valueOf(level));
        List<String> pcbs = ActionAnnotationConfig.parseProduces(method);
        if (pcbs != null) {
            action.getProduces().addAll(pcbs);
        }
        if ((vals = ActionAnnotationConfig.parseValidators(ru, method)) != null) {
            action.getValidator().addAll(vals);
        }
        if ((actionConfigKey = ActionAnnotationConfig.parseFullUriMapping(controller, method, action.getHttpMethod(), action.getUriMapping())) == null) {
            return;
        }
        ActionConfigBeanCache.add(actionConfigKey, action);
        ActionClassCache.add(action.getClazz(), controller);
    }

    private ActionConfigBean parseUriMappingSuffix(String moduleName, Method m) {
        ActionConfigBean acb = new ActionConfigBean();
        String methodName = m.getName();
        String fullName = m.toString();
        boolean hasPath = JAXWSUtil.hasPath(m);
        String uriMapping = null;
        if (methodName.startsWith("do")) {
            uriMapping = methodName.substring("do".length());
            String at = null;
            int indexOfAt = methodName.indexOf("At");
            if (indexOfAt != -1) {
                at = methodName.substring(indexOfAt + "At".length());
                if (methodName.startsWith("do")) {
                    uriMapping = uriMapping.substring(0, uriMapping.indexOf("At"));
                }
                String[] httpMethods = at.split("Or");
                StringBuilder sb = new StringBuilder();
                String[] stringArray = httpMethods;
                int n = httpMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    String httpMethod = stringArray[n2];
                    if (sb.length() > 0) {
                        sb.append("|");
                    }
                    sb.append(httpMethod.toUpperCase());
                    ++n2;
                }
                if (sb.length() > 0) {
                    acb.setHttpMethod(sb.toString());
                }
            }
            String join = "";
            int indexOfBind = methodName.indexOf("Bind");
            if (indexOfBind != -1) {
                String[] joins;
                String bind = indexOfAt != -1 && indexOfAt > indexOfBind ? methodName.substring(indexOfBind + "Bind".length(), indexOfAt) : methodName.substring(indexOfBind + "Bind".length());
                uriMapping = uriMapping.substring(0, uriMapping.indexOf("Bind"));
                int indexOfJoin = bind.indexOf("Join");
                if (indexOfJoin != -1 && (joins = bind.split("Join")).length > 1) {
                    bind = joins[0];
                    join = joins[1];
                }
                String[] pathParams = bind.split("And");
                StringBuilder pathParamSB = new StringBuilder();
                int i = 0;
                while (i < pathParams.length) {
                    pathParams[i] = CommonUtil.toLowCaseFirst(pathParams[i]);
                    pathParamSB.append("/{").append(pathParams[i]).append("}");
                    ++i;
                }
                if (pathParamSB.length() > 0) {
                    uriMapping = String.valueOf(uriMapping) + pathParamSB.toString();
                }
                acb.setPathParams(pathParams);
            }
            uriMapping = CommonUtil.toLowCaseFirst(uriMapping);
            uriMapping = CommonUtil.hump2ohter(uriMapping, "-");
            if (join.length() > 0) {
                join = CommonUtil.toLowCaseFirst(join);
                join = CommonUtil.hump2ohter(join, "-");
                uriMapping = String.valueOf(uriMapping) + "/" + join;
            }
        } else if (!hasPath) {
            ActionConfigBean defaultAcb = ActionAnnotationConfig.parseDefaultActionConfig(methodName, moduleName);
            if (defaultAcb != null) {
                acb.setHttpMethod(defaultAcb.getHttpMethod());
                acb.getResult().addAll(defaultAcb.getResult());
                uriMapping = defaultAcb.getUriMapping();
            } else {
                String info = String.valueOf(fullName) + " does not starts with '" + "do" + "' so that can not be a valid action uri mapping";
                return null;
            }
        }
        if (hasPath) {
            uriMapping = CommonUtil.parsePropValue(PathUtil.getPathValue(m));
        }
        acb.setUriMapping(uriMapping);
        return acb;
    }

    private static ActionConfigBean parseDefaultActionConfig(String methodName, String modelName) {
        String moduleName = null;
        moduleName = modelName.equals("/") ? "" : (modelName.endsWith("/") ? modelName.substring(0, modelName.lastIndexOf("/")) : modelName);
        String uriMapping = null;
        String httpMethod = null;
        ActionConfigBean acb = new ActionConfigBean();
        if ("index".equals(methodName)) {
            uriMapping = "/";
            httpMethod = "GET";
            ResultConfigBean rcb = new ResultConfigBean();
            rcb.setName("jsp");
            rcb.setLocation(String.valueOf(moduleName) + "/view/index.jsp");
            acb.getResult().add(rcb);
            ResultConfigBean rcb2 = new ResultConfigBean();
            rcb2.setName("html");
            rcb2.setType("fmt");
            rcb2.setLocation(String.valueOf(moduleName) + "/view/index.html");
            acb.getResult().add(rcb2);
        } else if ("create".equals(methodName)) {
            uriMapping = "/";
            httpMethod = "POST";
            ResultConfigBean rcb = new ResultConfigBean();
            rcb.setName("index");
            rcb.setLocation(moduleName);
            rcb.setType("action");
            acb.getResult().add(rcb);
        } else if ("update".equals(methodName)) {
            uriMapping = "/{id}";
            httpMethod = "PUT";
            ResultConfigBean rcb = new ResultConfigBean();
            rcb.setName("index");
            rcb.setLocation(moduleName);
            rcb.setType("action");
            acb.getResult().add(rcb);
        } else if ("show".equals(methodName)) {
            uriMapping = "/{id}";
            httpMethod = "GET";
            ResultConfigBean rcb = new ResultConfigBean();
            rcb.setName("jsp");
            rcb.setLocation(String.valueOf(moduleName) + "/view/show.jsp");
            acb.getResult().add(rcb);
            ResultConfigBean rcb2 = new ResultConfigBean();
            rcb2.setName("html");
            rcb2.setType("fmt");
            rcb2.setLocation(String.valueOf(moduleName) + "/view/show.html");
            acb.getResult().add(rcb2);
        } else if ("edit".equals(methodName)) {
            uriMapping = "/{id}/edit";
            httpMethod = "GET";
            ResultConfigBean rcb = new ResultConfigBean();
            rcb.setName("jsp");
            rcb.setLocation(String.valueOf(moduleName) + "/view/edit.jsp");
            acb.getResult().add(rcb);
            ResultConfigBean rcb2 = new ResultConfigBean();
            rcb2.setName("html");
            rcb2.setType("fmt");
            rcb2.setLocation(String.valueOf(moduleName) + "/view/edit.html");
            acb.getResult().add(rcb2);
        } else if ("destroy".equals(methodName)) {
            uriMapping = "/{id}";
            httpMethod = "DELETE";
            ResultConfigBean rcb = new ResultConfigBean();
            rcb.setName("index");
            rcb.setLocation(moduleName);
            rcb.setType("action");
            acb.getResult().add(rcb);
        } else if ("editNew".equals(methodName)) {
            uriMapping = "/new";
            httpMethod = "GET";
            ResultConfigBean rcb = new ResultConfigBean();
            rcb.setName("jsp");
            rcb.setLocation(String.valueOf(moduleName) + "/view/new.jsp");
            acb.getResult().add(rcb);
            ResultConfigBean rcb2 = new ResultConfigBean();
            rcb2.setName("html");
            rcb2.setType("fmt");
            rcb2.setLocation(String.valueOf(moduleName) + "/view/new.html");
            acb.getResult().add(rcb2);
        } else {
            acb = null;
        }
        if (acb != null) {
            acb.setHttpMethod(httpMethod);
            acb.setUriMapping(uriMapping);
        }
        return acb;
    }

    private static String parseHttpMethodByClazz(Class<?> cls) {
        String GET = "GET";
        String POST = "POST";
        String PUT = "PUT";
        String DELETE = "DELETE";
        String[] methods = new String[]{JAXWSUtil.hasGET(cls) ? "GET" : "", JAXWSUtil.hasPOST(cls) ? "POST" : "", JAXWSUtil.hasDELETE(cls) ? "DELETE" : "", JAXWSUtil.hasPUT(cls) ? "PUT" : ""};
        StringBuilder m_sb = new StringBuilder();
        String[] stringArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (m_sb.length() > 0 && s.length() > 0) {
                m_sb.append("|");
            }
            m_sb.append(s);
            ++n2;
        }
        if (m_sb.length() == 0) {
            return null;
        }
        return m_sb.toString();
    }

    private static String parseFullUriMapping(Class<?> cls, Method m, String httpMethod, String uriMapping) {
        String actionFullName = ActionUrlUtil.mathersUrlMapping(m, uriMapping, cls);
        if (actionFullName == null) {
            return null;
        }
        if (actionFullName.endsWith("/")) {
            actionFullName.substring(0, actionFullName.length() - 1);
        }
        actionFullName = String.valueOf(actionFullName) + "#" + httpMethod;
        return actionFullName;
    }

    private static List<ValidatorConfigBean> parseValidators(ReflectUtil ru, Method m) {
        List<ValidatorConfigBean> fieldVal;
        ArrayList<ValidatorConfigBean> vals = new ArrayList<ValidatorConfigBean>();
        Validate validate = m.getAnnotation(Validate.class);
        if (validate == null) {
            return vals;
        }
        String[] fields = validate.value();
        String[] excepts = validate.except();
        if (fields != null && (fieldVal = ValidatorUtil.readValidator(fields, excepts, null, ru, null, null)) != null) {
            vals.addAll(fieldVal);
        }
        return vals;
    }

    private static List<String> parseProduces(Method m) {
        boolean hasProduces = JAXWSUtil.hasProduces(m);
        ArrayList<String> pcbs = null;
        if (hasProduces) {
            pcbs = new ArrayList<String>();
            String producesStr = CommonUtil.parsePropValue(ProducesUtil.getProducesValue(m)[0]);
            pcbs.add(producesStr);
        }
        return pcbs;
    }

    private static int parseActionLevel(Class<?> cls, Method m) {
        ActionLevel actionLevel = cls.getAnnotation(ActionLevel.class);
        if (actionLevel == null) {
            actionLevel = m.getAnnotation(ActionLevel.class);
        }
        int level = 1;
        if (actionLevel != null) {
            level = actionLevel.value();
        }
        return level;
    }

    private static String parseShowValErrType(Class<?> cls, Method m) {
        ShowValMess cls_vm = cls.getAnnotation(ShowValMess.class);
        String clsShowValErr = cls_vm == null ? "alert" : cls_vm.value();
        clsShowValErr = CommonUtil.parsePropValue(clsShowValErr);
        String methodShowValErr = clsShowValErr.trim().length() == 0 ? "alert" : clsShowValErr;
        ShowValMess m_vm = m.getAnnotation(ShowValMess.class);
        methodShowValErr = m_vm == null ? methodShowValErr : m_vm.value();
        return methodShowValErr;
    }

    private static String parseHttpMethodByAnnotation(Class<?> cls, Method m) {
        String methodHttpMethod = ActionAnnotationConfig.parseHttpMethodByMethodAnnotation(m);
        if (methodHttpMethod != null) {
            return methodHttpMethod;
        }
        return ActionAnnotationConfig.parseHttpMethodByClazz(cls);
    }

    private static String parseHttpMethodByMethodAnnotation(Method m) {
        String[] _methods = new String[]{JAXWSUtil.hasGET(m) ? "GET" : "", JAXWSUtil.hasPOST(m) ? "POST" : "", JAXWSUtil.hasDELETE(m) ? "DELETE" : "", JAXWSUtil.hasPUT(m) ? "PUT" : ""};
        StringBuilder _sb = new StringBuilder();
        String[] stringArray = _methods;
        int n = _methods.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.trim().length() != 0) {
                if (_sb.length() > 0 && s.length() > 0) {
                    _sb.append("|");
                }
                _sb.append(s);
            }
            ++n2;
        }
        return _sb.toString();
    }

    private static String parseUriMappingPrefix(Class<?> cls, String moduleName) {
        boolean hasPath = JAXWSUtil.hasPath(cls);
        String clazzUriMapping = hasPath ? PathUtil.getPathValue(cls) : moduleName;
        clazzUriMapping = CommonUtil.parsePropValue(clazzUriMapping);
        return clazzUriMapping;
    }

    private static String parseUriMapping(Class<?> cls, String moduleName, String uriMappingSuffix) {
        String uriMapping;
        String uriPrefix = ActionAnnotationConfig.parseUriMappingPrefix(cls, moduleName);
        if (uriPrefix.length() > 0 && !uriMappingSuffix.startsWith("/")) {
            uriPrefix = String.valueOf(uriPrefix) + "/";
        }
        if ((uriMapping = String.valueOf(uriPrefix) + uriMappingSuffix).startsWith("/")) {
            uriMapping = uriMapping.substring(1);
        }
        if (uriMapping.endsWith("/")) {
            uriMapping = uriMapping.substring(0, uriMapping.length() - 1);
        }
        return uriMapping;
    }

    @Override
    protected void onOk() throws Exception {
    }
}

