/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.ioc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eweb4j.cache.IOCConfigBeanCache;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.ioc.config.bean.IOCConfigBean;
import org.eweb4j.ioc.config.bean.Injection;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOC {
    private static Log log = LogFactory.getIOCLogger(IOC.class);

    public static synchronized boolean containsBean(String beanID) {
        return IOCConfigBeanCache.containsKey(beanID);
    }

    public static synchronized Class<?> getType(String beanID) throws Exception {
        return IOCConfigBeanCache.get(beanID).getClass();
    }

    public static synchronized boolean isPrototype(String beanID) throws Exception {
        return "prototype".equals(IOCConfigBeanCache.get(beanID).getScope());
    }

    public static synchronized boolean isSingleton(String beanID) throws Exception {
        return "singleton".equals(IOCConfigBeanCache.get(beanID).getScope());
    }

    public static synchronized boolean isTypeMatch(String beanID, Class<?> targetType) throws Exception {
        return targetType.equals(IOCConfigBeanCache.get(beanID).getClass());
    }

    public static synchronized <T> T getBean(String beanID) {
        if (!IOC.containsBean(beanID)) {
            return null;
        }
        Object t = null;
        try {
            Object[] initargs = null;
            Class[] args = null;
            ArrayList<Object> initargList = new ArrayList<Object>();
            ArrayList argList = new ArrayList();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            if (IOCConfigBeanCache.containsKey(beanID)) {
                IOCConfigBean iocBean = IOCConfigBeanCache.get(beanID);
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(iocBean.getClazz());
                if ("singleton".equalsIgnoreCase(iocBean.getScope()) && SingleBeanCache.containsKey(beanID)) {
                    t = SingleBeanCache.get(beanID);
                    return (T)t;
                }
                for (Injection inj : iocBean.getInject()) {
                    String name;
                    if (inj == null) continue;
                    String ref = inj.getRef();
                    if (ref != null && !"".equals(ref)) {
                        String name2 = inj.getName();
                        if (name2 != null && !"".equals(name2)) {
                            properties.put(name2, IOC.getBean(ref));
                            continue;
                        }
                        T obj = IOC.getBean(ref);
                        initargList.add(obj);
                        String type = inj.getType();
                        if (type != null && type.trim().length() > 0) {
                            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(type);
                            argList.add(cls);
                            continue;
                        }
                        argList.add(obj.getClass());
                        continue;
                    }
                    String type = inj.getType();
                    String value = inj.getValue();
                    if (value == null) {
                        value = "";
                    }
                    if ((name = inj.getName()) != null && !"".equals(name)) {
                        if ("int".equalsIgnoreCase(type) || "java.lang.Integer".equalsIgnoreCase(type)) {
                            if ("".equals(value.trim())) {
                                value = "0";
                            }
                            properties.put(name, Integer.parseInt(value));
                            continue;
                        }
                        if ("string".equalsIgnoreCase(type) || "java.lang.String".equalsIgnoreCase(type)) {
                            properties.put(name, value);
                            continue;
                        }
                        if ("long".equalsIgnoreCase(type) || "java.lang.Long".equalsIgnoreCase(type)) {
                            if ("".equals(value.trim())) {
                                value = "0";
                            }
                            properties.put(name, Long.parseLong(value));
                            continue;
                        }
                        if ("float".equalsIgnoreCase(type) || "java.lang.Float".equalsIgnoreCase(type)) {
                            if ("".equals(value.trim())) {
                                value = "0.0";
                            }
                            properties.put(name, Float.valueOf(Float.parseFloat(value)));
                            continue;
                        }
                        if ("boolean".equalsIgnoreCase(type) || "java.lang.Boolean".equalsIgnoreCase(type)) {
                            if ("".equals(value.trim())) {
                                value = "false";
                            }
                            properties.put(name, Boolean.parseBoolean(value));
                            continue;
                        }
                        if (!"double".equalsIgnoreCase(type) && !"java.lang.Double".equalsIgnoreCase(type)) continue;
                        if ("".equals(value.trim())) {
                            value = "0.0";
                        }
                        properties.put(name, Double.parseDouble(value));
                        continue;
                    }
                    if ("int".equalsIgnoreCase(type) || "java.lang.Integer".equalsIgnoreCase(type)) {
                        if ("".equals(value.trim())) {
                            value = "0";
                        }
                        argList.add(Integer.TYPE);
                        initargList.add(Integer.parseInt(value));
                        continue;
                    }
                    if ("long".equalsIgnoreCase(type) || "java.lang.Long".equalsIgnoreCase(type)) {
                        if ("".equals(value.trim())) {
                            value = "0";
                        }
                        argList.add(Long.TYPE);
                        initargList.add(Long.parseLong(value));
                        continue;
                    }
                    if ("float".equalsIgnoreCase(type) || "java.lang.Float".equalsIgnoreCase(type)) {
                        if ("".equals(value.trim())) {
                            value = "0.0";
                        }
                        argList.add(Float.TYPE);
                        initargList.add(Float.valueOf(Float.parseFloat(value)));
                        continue;
                    }
                    if ("boolean".equalsIgnoreCase(type) || "java.lang.Boolean".equalsIgnoreCase(type)) {
                        if ("".equals(value.trim())) {
                            value = "false";
                        }
                        argList.add(Boolean.TYPE);
                        initargList.add(Boolean.parseBoolean(value));
                        continue;
                    }
                    if ("double".equalsIgnoreCase(type) || "java.lang.Double".equalsIgnoreCase(type)) {
                        if ("".equals(value.trim())) {
                            value = "0.0";
                        }
                        argList.add(Double.TYPE);
                        initargList.add(Double.parseDouble(value));
                        continue;
                    }
                    if (!"string".equalsIgnoreCase(type) && !"java.lang.String".equalsIgnoreCase(type)) continue;
                    argList.add(String.class);
                    initargList.add(value);
                }
                if (argList.size() > 0 && initargList.size() > 0) {
                    args = new Class[argList.size()];
                    initargs = new Object[initargList.size()];
                    int i = 0;
                    while (i < argList.size()) {
                        args[i] = (Class)argList.get(i);
                        initargs[i] = initargList.get(i);
                        ++i;
                    }
                    t = clazz.getDeclaredConstructor(args).newInstance(initargs);
                } else {
                    t = clazz.newInstance();
                    Iterator<Object> it = properties.entrySet().iterator();
                    while (it.hasNext()) {
                        ReflectUtil ru = new ReflectUtil(t);
                        Map.Entry e = (Map.Entry)it.next();
                        String name = (String)e.getKey();
                        Method m = ru.getSetter(name);
                        if (m == null) continue;
                        m.invoke(t, e.getValue());
                    }
                }
                if ("singleton".equalsIgnoreCase(iocBean.getScope()) && !SingleBeanCache.containsKey(beanID)) {
                    SingleBeanCache.add(beanID, t);
                }
            }
        }
        catch (Exception e) {
            log.error("IOC.getBean(" + beanID + ") failed!", e);
        }
        String info = "IOC.getBean(" + beanID + ") \u2014\u2014> " + t;
        log.debug(info);
        return (T)t;
    }
}

