/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.config;

import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScanPackage {
    public static final Log log = LogFactory.getLogger(ScanPackage.class, true);
    private Collection<String> packages = new HashSet<String>();
    private Collection<String> jars = new HashSet<String>();
    private Collection<String> classpaths = new HashSet<String>();
    private String currentClassPath = null;
    private Collection<String> scans = null;
    private Collection<String> jarNames = new HashSet<String>();

    public String readAnnotation(Collection<String> scans) {
        this.scans = scans;
        String error = null;
        try {
            if (scans == null) {
                return error;
            }
            for (String scan : this.scans) {
                if (scan.startsWith("AP:")) {
                    this.classpaths.add(scan.replace("AP:", "").replace("${RootPath}", ConfigConstant.ROOT_PATH.subSequence(0, ConfigConstant.ROOT_PATH.length() - 1)));
                    continue;
                }
                if (scan.startsWith("JAR:")) {
                    this.jarNames.add(scan.replace("JAR:", "").replace(".jar", ""));
                    continue;
                }
                this.packages.add(scan);
            }
            this.classpaths.add(FileUtil.getTopClassPath(ScanPackage.class));
            this.classpaths.add(FileUtil.getLib());
            log.debug("classpaths -> " + this.classpaths);
            log.debug("jarNames -> " + this.jarNames);
            for (String jar : FileUtil.getJars()) {
                this.filterScanJar(this.jarNames, jar);
            }
            this.scanClassPath();
            log.debug("jars -> " + this.jars);
            this.scanJar();
            this.onOk();
        }
        catch (Exception e) {
            error = log.error("", e);
        }
        return error;
    }

    private void filterScanJar(Collection<String> jarNames, String jar) {
        jar = jar.replace("\\", "/");
        String name = new File(jar).getName().replace(".jar", "").replace("\\", "/");
        for (String scan : jarNames) {
            if (scan.equals("*")) {
                this.jars.add(jar);
            } else if (scan.startsWith("*") && scan.endsWith("*")) {
                if (name.contains(scan.subSequence(1, scan.lastIndexOf("*")))) {
                    this.jars.add(jar);
                }
            } else if (scan.startsWith("*")) {
                if (name.endsWith(scan.substring(1))) {
                    this.jars.add(jar);
                }
            } else if (scan.endsWith("*") && name.startsWith(scan.substring(0, scan.lastIndexOf("*")))) {
                this.jars.add(jar);
            }
            if (!scan.equals(name)) continue;
            this.jars.add(jar);
        }
    }

    private void scanClassPath() throws Exception {
        for (String classpath : this.classpaths) {
            this.scanDir(classpath);
        }
    }

    private void scanDir(String classDir) throws Exception {
        File dir = null;
        dir = new File(classDir);
        log.debug("scan classpath -> " + dir);
        if (dir.isDirectory()) {
            this.currentClassPath = dir.getAbsolutePath();
            this.scanFile(dir);
        }
    }

    private void scanFile(File dir) throws Exception {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                this.scanFile(f);
            } else if (f.isFile()) {
                String name = f.getName();
                if (!name.endsWith(".class")) {
                    if (name.endsWith(".jar")) {
                        String jar = f.getAbsolutePath();
                        this.filterScanJar(this.jarNames, jar);
                    }
                } else {
                    String packName = f.getAbsolutePath().replace(this.currentClassPath, "").replace(File.separator, ".");
                    String clsName = packName.substring(1, packName.lastIndexOf("."));
                    boolean isPkg = false;
                    for (String pkg : this.packages) {
                        if (!".".equals(pkg) && !clsName.startsWith(pkg)) continue;
                        isPkg = true;
                        break;
                    }
                    if (!isPkg || !this.handleClass(clsName)) {
                        // empty if block
                    }
                }
            }
            ++n2;
        }
    }

    private void scanJar() {
        if (this.jars == null) {
            return;
        }
        for (String p : this.jars) {
            File f = new File(p);
            ZipInputStream zin = null;
            ZipEntry entry = null;
            try {
                zin = new ZipInputStream(new FileInputStream(f));
                log.debug("scanning jar -> " + f.getAbsolutePath());
                while ((entry = zin.getNextEntry()) != null) {
                    block12: {
                        String entryName = entry.getName().replace('/', '.');
                        boolean isPkg = false;
                        for (String pkg : this.packages) {
                            if (!".".equals(pkg) && !entryName.startsWith(pkg)) continue;
                            isPkg = true;
                            break;
                        }
                        if (isPkg) {
                            if (!entryName.endsWith(".class")) continue;
                            String className = entryName.substring(0, entryName.lastIndexOf("."));
                            try {
                                if (!this.handleClass(className)) {
                                }
                                break block12;
                            }
                            catch (Error e) {
                            }
                            catch (Exception e) {}
                            continue;
                        }
                    }
                    zin.closeEntry();
                }
                zin.close();
            }
            catch (Error e) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        String entryName = "sg.ilovedeals.classifer.Simple.class";
        System.out.println(entryName.substring(0, entryName.lastIndexOf(".")));
    }

    protected abstract boolean handleClass(String var1);

    protected abstract void onOk() throws Exception;
}

