/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.ContrastFilter;
import org.eweb4j.util.FileUtil;
import org.eweb4j.util.SharpenFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThumbUtil {
    public static ByteArrayOutputStream generateThumb(String imagePath, String outputFormat, int failRetryTimes, long sleep, int outputWidth, int outputHeight) throws Exception {
        return ThumbUtil.generateThumb(imagePath, 0, 0.9f, 0.0f, 0.0f, outputFormat, failRetryTimes, sleep, outputWidth, outputHeight, false);
    }

    public static ByteArrayOutputStream generateThumb(String imagePath, String outputFormat, int failRetryTimes, long sleep, int outputWidth, int outputHeight, boolean isCrop) throws Exception {
        return ThumbUtil.generateThumb(imagePath, 0, 0.9f, 0.0f, 0.0f, outputFormat, failRetryTimes, sleep, outputWidth, outputHeight, isCrop);
    }

    public static ByteArrayOutputStream generateThumb(String imagePath, int sharpenTimes, float quality, float contrast, float brightness, String outputFormat, int failRetryTimes, long sleep, int outputWidth, int outputHeight) throws Exception {
        return ThumbUtil.generateThumb(imagePath, sharpenTimes, quality, contrast, brightness, outputFormat, failRetryTimes, sleep, outputWidth, outputHeight, false);
    }

    public static ByteArrayOutputStream generateThumb(String imagePath, int sharpenTimes, float quality, float contrast, float brightness, String outputFormat, int failRetryTimes, long sleep, int outputWidth, int outputHeight, boolean isCrop) throws Exception {
        BufferedImage img = ThumbUtil.generate(imagePath, sharpenTimes, quality, contrast, brightness, outputFormat, failRetryTimes, sleep, outputWidth, outputHeight, isCrop);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)img, outputFormat, os);
        return os;
    }

    public static Thumbnails.Builder<BufferedImage> build(String imagePath, int sharpenTimes, float contrast, float brightness, int x1, int y1, int x2, int y2) throws Exception {
        if (imagePath == null || imagePath.trim().length() == 0) {
            throw new Exception("ImageURL required");
        }
        int failRetryTimes = 1;
        BufferedImage bi = null;
        bi = FileUtil.getBufferedImage(imagePath, failRetryTimes, 1000L);
        if (bi == null) {
            throw new Exception("can not get the image file from -> " + imagePath);
        }
        if (sharpenTimes > 0) {
            bi = ThumbUtil.sharpen(bi, sharpenTimes);
        }
        if (contrast > 0.0f || brightness > 0.0f) {
            ContrastFilter filter = new ContrastFilter();
            if (contrast > 0.0f) {
                filter.setContrast(contrast);
            }
            if (brightness > 0.0f) {
                filter.setBrightness(brightness);
            }
            bi = filter.filter(bi, null);
        }
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{bi}).scale(1.0).sourceRegion(x1, y1, x2 - x1, y2 - y1);
    }

    public static BufferedImage generate(String imagePath, int sharpenTimes, float quality, float contrast, float brightness, String outputFormat, int failRetryTimes, long sleep, int outputWidth, int outputHeight) throws Exception {
        return ThumbUtil.generate(imagePath, sharpenTimes, quality, contrast, brightness, outputFormat, failRetryTimes, sleep, outputWidth, outputHeight, false);
    }

    public static BufferedImage generate(String imagePath, int sharpenTimes, float quality, float contrast, float brightness, String outputFormat, int failRetryTimes, long sleep, int outputWidth, int outputHeight, boolean isCrop) throws Exception {
        if (imagePath == null || imagePath.trim().length() == 0) {
            throw new Exception("ImageURL required");
        }
        if (outputFormat == null || outputFormat.trim().length() == 0) {
            outputFormat = imagePath.substring(imagePath.lastIndexOf(".") + 1, imagePath.length());
        }
        if (outputFormat == null || outputFormat.trim().length() == 0) {
            throw new Exception("can not get the image suffix -> " + imagePath);
        }
        if (failRetryTimes <= 0) {
            failRetryTimes = 1;
        }
        String W = "width";
        String H = "height";
        BufferedImage bi = null;
        bi = FileUtil.getBufferedImage(imagePath, failRetryTimes, sleep);
        if (bi == null) {
            throw new Exception("can not get the image file from -> " + imagePath);
        }
        int sw = bi.getWidth();
        int sh = bi.getHeight();
        if (outputWidth > 0 && outputHeight > 0 && !isCrop) {
            double outputScale;
            double sourceScale = Double.parseDouble(String.valueOf(sw)) / Double.parseDouble(String.valueOf(sh));
            if (sourceScale >= (outputScale = Double.parseDouble(String.valueOf(outputWidth)) / Double.parseDouble(String.valueOf(outputHeight)))) {
                outputHeight = 0;
            } else {
                outputWidth = 0;
            }
        }
        if (sw < outputWidth) {
            outputWidth = sw;
        }
        if (sh < outputHeight) {
            outputHeight = sh;
        }
        HashMap<String, Integer> source = new HashMap<String, Integer>();
        source.put("width", sw);
        source.put("height", sh);
        if (outputWidth <= 0 && outputHeight <= 0) {
            outputWidth = sw;
            outputHeight = sh;
        }
        HashMap<String, Integer> output = new HashMap<String, Integer>();
        if (outputWidth > 0) {
            output.put("width", outputWidth);
        }
        if (outputHeight > 0) {
            output.put("height", outputHeight);
        }
        String min = "width";
        if (sh < sw) {
            min = "height";
        }
        if (!output.containsKey(min)) {
            min = output.containsKey("width") ? "width" : "height";
        }
        if (sharpenTimes > 0) {
            bi = ThumbUtil.sharpen(bi, sharpenTimes);
        }
        if (contrast > 0.0f || brightness > 0.0f) {
            ContrastFilter filter = new ContrastFilter();
            if (contrast > 0.0f) {
                filter.setContrast(contrast);
            }
            if (brightness > 0.0f) {
                filter.setBrightness(brightness);
            }
            bi = filter.filter(bi, null);
        }
        if (output.containsKey("width") && output.containsKey("height") && isCrop) {
            double hScale;
            double wScale = Double.parseDouble(String.valueOf(source.get("width"))) / Double.parseDouble(String.valueOf(output.get("width")));
            double scale = wScale < (hScale = Double.parseDouble(String.valueOf(source.get("height"))) / Double.parseDouble(String.valueOf(output.get("height")))) ? wScale : hScale;
            int sW = new Double((double)((Integer)source.get("width")).intValue() / scale).intValue();
            int sH = new Double((double)((Integer)source.get("height")).intValue() / scale).intValue();
            BufferedImage _bi = Thumbnails.of((BufferedImage[])new BufferedImage[]{bi}).size(sW, sH).outputFormat(outputFormat).asBufferedImage();
            return Thumbnails.of((BufferedImage[])new BufferedImage[]{_bi}).scale(1.0).sourceRegion((Position)Positions.CENTER, ((Integer)output.get("width")).intValue(), ((Integer)output.get("height")).intValue()).outputQuality(quality).outputFormat(outputFormat).asBufferedImage();
        }
        double scale = Double.parseDouble(String.valueOf(source.get(min))) / Double.parseDouble(String.valueOf(output.get(min)));
        int sW = new Double((double)sw / scale).intValue();
        int sH = new Double((double)sh / scale).intValue();
        return Thumbnails.of((BufferedImage[])new BufferedImage[]{bi}).size(sW, sH).outputQuality(quality).outputFormat(outputFormat).asBufferedImage();
    }

    public static BufferedImage sharpen(BufferedImage src) {
        return ThumbUtil.sharpen(src, 2);
    }

    public static BufferedImage sharpen(BufferedImage src, int times) {
        BufferedImage desc = null;
        SharpenFilter filter = new SharpenFilter();
        filter.setUseAlpha(true);
        desc = filter.filter(src, desc);
        int i = 0;
        while (i < times - 1) {
            desc = filter.filter(desc, desc);
            ++i;
        }
        filter = null;
        return desc;
    }

    public static void main(String[] args) throws Exception {
        String remoteImageUrl = "http://www.marinasquare.com.sg/images/msq//tenants/arte.jpg";
        int sharpenTimes = 0;
        float quality = 1.0f;
        String outputFormat = "jpg";
        String name = CommonUtil.getNowTime("yyyyMMddHHmmss");
        int outputWidth = 400;
        int outputHeight = 300;
        boolean isCrop = false;
        float contrast = 0.0f;
        float brightness = 0.0f;
        File file = new File("d:/" + name + "_w" + outputWidth + "h" + outputHeight + "_sharpen" + sharpenTimes + "_contrat" + contrast + "_quality" + quality + "." + outputFormat);
        BufferedImage image = ThumbUtil.generate(remoteImageUrl, sharpenTimes, quality, contrast, brightness, outputFormat, 10, 1000L, outputWidth, outputHeight, isCrop);
        boolean isOK = ImageIO.write((RenderedImage)image, outputFormat, new FileOutputStream(file));
        if (!isOK) {
            throw new Exception("create image fail ");
        }
        File _f = new File(file.getAbsolutePath());
        System.out.println("generate file -> " + _f.getAbsolutePath() + " " + _f.exists());
    }
}

