/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

public class Splitter {
    private StringBuilder result;
    private String source;
    private String[] cons;
    private String[] bys;
    private boolean byUpperCase = false;

    public static Splitter init(String source) {
        return new Splitter(source);
    }

    public Splitter(String source) {
        this.source = source;
        this.result = new StringBuilder(this.source);
    }

    private void splitByUpperCase() {
        char[] chars = this.result.toString().toCharArray();
        int inc = 0;
        int i = 1;
        while (i < chars.length) {
            String s = String.valueOf(chars[i]);
            if (this.byUpperCase && s.matches("[A-Z]")) {
                int index = i + inc;
                this.result.insert(index, this.cons[0]);
                inc += inc + this.cons[0].length();
            }
            ++i;
        }
    }

    public Splitter connect(String ... cons) {
        this.cons = cons;
        return this;
    }

    public Splitter by(String ... bys) {
        this.bys = bys;
        return this;
    }

    public Splitter byUpperCase() {
        this.byUpperCase = true;
        return this;
    }

    public Splitter split() {
        if (this.byUpperCase) {
            this.splitByUpperCase();
        }
        if (this.bys == null) {
            return this;
        }
        int i = 0;
        while (i < this.bys.length) {
            String con = null;
            con = this.bys.length > this.cons.length && this.cons.length == 1 ? this.cons[0] : this.cons[i];
            this.result = new StringBuilder(this.result.toString().replace(this.bys[i], con));
            ++i;
        }
        return this;
    }

    public Splitter upperFirst() {
        if (this.bys == null) {
            this.bys = new String[1];
        }
        int i = 0;
        while (i < this.bys.length) {
            String con = null;
            con = this.bys.length > this.cons.length && this.cons.length == 1 ? this.cons[0] : this.cons[i];
            String[] strs = this.result.toString().replace(con, "_##_").split("_##_");
            StringBuilder sb = new StringBuilder();
            String[] stringArray = strs;
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(con);
                }
                if (s.trim().length() != 0) {
                    if (s.length() <= 1) {
                        sb.append(s.toUpperCase());
                    } else {
                        sb.append(s.replaceFirst(s.substring(0, 1), s.substring(0, 1).toUpperCase()));
                    }
                }
                ++n2;
            }
            this.result = new StringBuilder(sb.toString());
            ++i;
        }
        return this;
    }

    public Splitter lowerFirst() {
        if (this.bys == null) {
            this.bys = new String[1];
        }
        int i = 0;
        while (i < this.bys.length) {
            String con = null;
            con = this.bys.length > this.cons.length && this.cons.length == 1 ? this.cons[0] : this.cons[i];
            String start = null;
            if (this.result.toString().startsWith(con)) {
                start = con;
            }
            String[] strs = this.result.toString().replace(con, "_##_").split("_##_");
            StringBuilder sb = new StringBuilder();
            String[] stringArray = strs;
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (sb.length() > 0) {
                    sb.append(con);
                }
                if (s.trim().length() != 0) {
                    if (s.length() <= 1) {
                        sb.append(s.toLowerCase());
                    } else {
                        sb.append(s.replaceFirst(s.substring(0, 1), s.substring(0, 1).toLowerCase()));
                    }
                }
                ++n2;
            }
            if (start != null) {
                sb.insert(0, start);
            }
            this.result = new StringBuilder(sb.toString());
            ++i;
        }
        return this;
    }

    public String toString() {
        return this.result.toString();
    }

    public static void main(String[] args) {
        System.out.println(Splitter.init("HelloWorld").byUpperCase().connect(" ").split().lowerFirst().toString());
        System.out.println(Splitter.init("HelloWorld").byUpperCase().connect("-").split().lowerFirst().toString());
        System.out.println(Splitter.init("hello-world").by("-").connect(" ").split().upperFirst().toString());
        System.out.println(Splitter.init("hello-world").by("-").connect("#").split().upperFirst().toString());
        System.out.println(Splitter.init("demo.displayName").byUpperCase().by(".").connect(" ").split().upperFirst().toString());
        System.out.println(Splitter.init("demo.displayName_test").byUpperCase().by(".", "_").connect(" ").split().upperFirst().toString());
        System.out.println(Splitter.init("doHelloAtGetOrPost").by("do", "At", "Or").connect("/", "@", "|").split().lowerFirst().toString());
    }
}

