/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.util;

import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.imageio.ImageIO;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.eweb4j.util.FTPListener;
import org.eweb4j.util.ThumbUtil;

public class FTPUtil
implements ProtocolCommandListener {
    public FTPClient client = new FTPClient();
    private String host;
    private int port;
    private String user;
    private String pwd;
    private FTPListener listener;
    private boolean debug;

    public FTPUtil(String host, int port, String user, String pwd) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.pwd = pwd;
    }

    public void setListener(FTPListener listener) {
        this.listener = listener;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void connectAndLogin() throws Exception {
        this.client.addProtocolCommandListener((ProtocolCommandListener)this);
        this.client.connect(this.host, this.port);
        this.client.setControlEncoding("UTF-8");
        this.client.setFileType(2);
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            this.client.disconnect();
            throw new Exception("FTP is not PositiveCompletion");
        }
        if (!this.client.login(this.user, this.pwd)) {
            this.client.disconnect();
            throw new Exception("FTP login fail");
        }
        if (this.listener != null) {
            this.listener.onInfo("FTP login success");
        }
    }

    public void logoutAndDisconnect() {
        block8: {
            if (this.client != null) {
                block7: {
                    try {
                        this.client.logout();
                        if (this.listener != null) {
                            this.listener.onInfo(" ftp logout success");
                        }
                    }
                    catch (Exception e) {
                        if (this.listener == null) break block7;
                        this.listener.onError(" can not logout ftp", e);
                    }
                }
                try {
                    this.client.disconnect();
                    if (this.listener != null) {
                        this.listener.onInfo(" ftp disconnect success");
                    }
                }
                catch (Exception e) {
                    if (this.listener == null) break block8;
                    this.listener.onError(" can not disconnect ftp", e);
                }
            }
        }
    }

    private static String resolvePath(String path) {
        File dir = new File(path);
        return dir.getPath().replace("\\", "/");
    }

    public boolean mkdir(String remoteDir) throws Exception {
        if (remoteDir == null || remoteDir.trim().length() == 0) {
            throw new Exception("remoteDir -> " + remoteDir + " required !");
        }
        String path = FTPUtil.resolvePath(remoteDir);
        String[] remoteDirs = path.split("/");
        StringBuilder builder = new StringBuilder("/");
        String[] stringArray = remoteDirs;
        int n = remoteDirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            if (builder.length() > 1) {
                builder.append("/");
            }
            builder.append(dir);
            boolean isDirOk = this.client.changeWorkingDirectory(builder.toString());
            if (!isDirOk) {
                isDirOk = this.client.makeDirectory(builder.toString());
            }
            if (!isDirOk) {
                throw new Exception("ftp mkdir -> " + builder.toString() + " fail");
            }
            ++n2;
        }
        return true;
    }

    public static void main(String[] args) {
        block12: {
            FTPUtil ftp = new FTPUtil("shoplay.com", 21, "weiwei", "24abcdef");
            try {
                try {
                    ftp.client.setDataTimeout(600000);
                    ftp.client.setConnectTimeout(3600000);
                    ftp.setDebug(true);
                    ftp.setListener(new FTPListener(){

                        public void onInfo(String info) {
                            System.out.println(info);
                        }

                        public void onError(String err, Exception e) {
                            e.printStackTrace();
                        }
                    });
                    ftp.connectAndLogin();
                    ftp.client.setFileTransferMode(3);
                    String root = "/wwwroot/wwwilovedeals/cache/bigpic/20130518/";
                    String filePath = "660811591578957.jpg";
                    String remoteFile = "http://cdn.streetdeal.sg/images/deals/" + filePath;
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)ThumbUtil.generate(remoteFile, 0, 0.2f, 0.0f, 0.0f, "jpg", 2, 1000L, 100, 100), "jpg", os);
                    boolean isOk = ftp.client.storeFile(String.valueOf(root) + filePath, (InputStream)new ByteArrayInputStream(os.toByteArray()));
                    System.out.println("fuck-->" + isOk);
                    ftp.client.logout();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (ftp == null || ftp.client == null || !ftp.client.isConnected()) break block12;
                    try {
                        ftp.client.disconnect();
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (ftp != null && ftp.client != null && ftp.client.isConnected()) {
                    try {
                        ftp.client.disconnect();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public void protocolCommandSent(ProtocolCommandEvent ev) {
        block3: {
            try {
                String info = new String(("sent->" + ev.getReplyCode() + "-" + "c->" + ev.getCommand() + "-" + ev.getMessage()).getBytes("iso8859-1"), "gbk");
                if (this.debug && this.listener != null) {
                    this.listener.onInfo(info);
                }
            }
            catch (UnsupportedEncodingException e) {
                String info = e.toString();
                if (this.listener == null) break block3;
                this.listener.onError(info, e);
            }
        }
    }

    public void protocolReplyReceived(ProtocolCommandEvent ev) {
        block3: {
            try {
                String info = new String(("receive->" + ev.getReplyCode() + "-" + "c->" + ev.getCommand() + "-" + ev.getMessage()).getBytes("iso8859-1"), "gbk");
                if (this.debug && this.listener != null) {
                    this.listener.onInfo(info);
                }
            }
            catch (UnsupportedEncodingException e) {
                String info = e.toString();
                if (this.listener == null) break block3;
                this.listener.onError(info, e);
            }
        }
    }
}

