/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import org.eweb4j.cache.ORMConfigBeanCache;
import org.eweb4j.orm.config.ORMConfigBeanUtil;
import org.eweb4j.orm.config.bean.ORMConfigBean;
import org.eweb4j.orm.sql.Sql;
import org.eweb4j.orm.sql.SqlCreateException;
import org.eweb4j.util.ClassUtil;
import org.eweb4j.util.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteSqlCreator<T> {
    private T[] ts;

    public DeleteSqlCreator() {
    }

    public DeleteSqlCreator(T ... ts) {
        Object[] tmp = null;
        if (ts != null && ts.length > 0) {
            tmp = (Object[])ts.clone();
        }
        this.ts = tmp;
    }

    public Sql deleteWhere(String condition) {
        Sql sql = new Sql();
        if (this.ts != null && this.ts.length > 0) {
            StringBuilder sb = new StringBuilder();
            T[] TArray = this.ts;
            int n = this.ts.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                sb.append(this.makeSQL(t, (String)condition).sql);
                ++n2;
            }
            sql.sql = sb.toString();
        } else {
            sql.sql = "";
        }
        return sql;
    }

    private Sql makeSQL(T t, String condition) {
        Sql sql = new Sql();
        ORMConfigBean ormBean = ORMConfigBeanCache.get(t.getClass().getName());
        String table = ormBean != null ? ormBean.getTable() : t.getClass().getSimpleName();
        sql.sql = String.format("DELETE FROM %s WHERE %s ;", table, condition);
        return sql;
    }

    public Sql[] delete() throws SqlCreateException {
        Sql[] sqls = new Sql[this.ts.length];
        int i = 0;
        while (i < this.ts.length) {
            sqls[i] = this.makeSQL(this.ts[i]);
            ++i;
        }
        return sqls;
    }

    public Sql[] delete(String[] fields, String[] values) throws SqlCreateException {
        Sql[] sqls = new Sql[this.ts.length];
        int i = 0;
        while (i < this.ts.length) {
            sqls[i] = this.makeSQL(this.ts[i], fields, values);
            ++i;
        }
        return sqls;
    }

    public Sql[] delete(String ... fields) throws SqlCreateException {
        Sql[] sqls = new Sql[this.ts.length];
        int i = 0;
        while (i < this.ts.length) {
            sqls[i] = this.makeSQL(this.ts[i], fields);
            ++i;
        }
        return sqls;
    }

    private Sql makeSQL(T t) throws SqlCreateException {
        String table;
        String idColumn;
        Sql sql = new Sql();
        Class<?> clazz = t.getClass();
        HashMap map = null;
        Object idValue = null;
        if (Map.class.isAssignableFrom(clazz)) {
            map = (HashMap)t;
            idColumn = (String)map.get("idColumn");
            if (idColumn == null) {
                idColumn = "id";
            }
            String idField = idColumn;
            table = (String)map.get("table");
            idValue = map.get("idValue");
        } else {
            String idField = ORMConfigBeanUtil.getIdField(clazz);
            idColumn = ORMConfigBeanUtil.getIdColumn(clazz);
            table = ORMConfigBeanUtil.getTable(clazz, false);
            ReflectUtil ru = new ReflectUtil(t);
            Method idGetter = ru.getGetter(idField);
            if (idGetter != null) {
                try {
                    idValue = idGetter.invoke(t, new Object[0]);
                }
                catch (Exception e) {
                    throw new SqlCreateException(idGetter + " invoke exception " + e.toString(), e);
                }
            }
        }
        StringBuilder condition = new StringBuilder();
        condition.append(idColumn).append(" = ? ");
        sql.args.add(idValue);
        sql.sql = String.format("DELETE FROM %s WHERE %s ;", table, condition);
        return sql;
    }

    private Sql makeSQL(T t, String[] fields, String[] values) throws SqlCreateException {
        Class<?> clazz = t.getClass();
        String table = ORMConfigBeanUtil.getTable(clazz, false);
        Sql sql = new Sql();
        StringBuilder condition = new StringBuilder();
        String[] columns = ORMConfigBeanUtil.getColumns(clazz, fields);
        int i = 0;
        while (i < columns.length) {
            if (condition.length() > 0) {
                condition.append(" AND ");
            }
            condition.append(columns[i]).append(" = ? ");
            sql.args.add(values[i]);
            ++i;
        }
        sql.sql = String.format("DELETE FROM %s WHERE %s ;", table, condition);
        return sql;
    }

    private Sql makeSQL(T t, String ... fields) throws SqlCreateException {
        Sql sql = new Sql();
        Class<?> clazz = t.getClass();
        String table = ORMConfigBeanUtil.getTable(clazz, false);
        StringBuilder condition = new StringBuilder();
        ReflectUtil ru = new ReflectUtil(t);
        int i = 0;
        while (i < fields.length) {
            block13: {
                Method getter;
                if (condition.length() > 0) {
                    condition.append(" AND ");
                }
                if ((getter = ru.getGetter(fields[i])) != null) {
                    Object value;
                    block14: {
                        Object _value = null;
                        value = null;
                        try {
                            _value = getter.invoke(t, new Object[0]);
                            if (_value == null) break block13;
                            if (ClassUtil.isPojo(_value.getClass())) {
                                Field f = ru.getField(fields[i]);
                                OneToOne oneAnn = getter.getAnnotation(OneToOne.class);
                                if (oneAnn == null) {
                                    oneAnn = f.getAnnotation(OneToOne.class);
                                }
                                ManyToOne manyToOneAnn = null;
                                if (oneAnn == null && (manyToOneAnn = getter.getAnnotation(ManyToOne.class)) == null) {
                                    manyToOneAnn = f.getAnnotation(ManyToOne.class);
                                }
                                if (oneAnn != null || manyToOneAnn != null) {
                                    JoinColumn joinColAnn = getter.getAnnotation(JoinColumn.class);
                                    if (joinColAnn == null) {
                                        joinColAnn = f.getAnnotation(JoinColumn.class);
                                    }
                                    if (joinColAnn != null && joinColAnn.referencedColumnName().trim().length() > 0) {
                                        String refCol = joinColAnn.referencedColumnName();
                                        String refField = ORMConfigBeanUtil.getField(_value.getClass(), refCol);
                                        ReflectUtil tarRu = new ReflectUtil(_value);
                                        Method tarFKGetter = tarRu.getGetter(refField);
                                        value = tarFKGetter.invoke(_value, new Object[0]);
                                    } else {
                                        ReflectUtil tarRu = new ReflectUtil(_value);
                                        String tarFKField = ORMConfigBeanUtil.getIdField(_value.getClass());
                                        if (tarFKField != null) {
                                            Method tarFKGetter = tarRu.getGetter(tarFKField);
                                            value = tarFKGetter.invoke(_value, new Object[0]);
                                        }
                                    }
                                }
                                if (value != null) break block14;
                                break block13;
                            }
                            value = _value;
                        }
                        catch (Exception e) {
                            throw new SqlCreateException(getter + " invoke exception " + e.toString(), e);
                        }
                    }
                    String column = ORMConfigBeanUtil.getColumn(clazz, fields[i]);
                    condition.append(column).append(" = ? ");
                    sql.args.add(value);
                }
            }
            ++i;
        }
        sql.sql = String.format("DELETE FROM %s WHERE %s ;", table, condition);
        return sql;
    }

    public T[] getTs() {
        Object[] tmp = null;
        if (this.ts != null && this.ts.length > 0) {
            tmp = (Object[])this.ts.clone();
        }
        return tmp;
    }

    public void setTs(T[] ts) {
        Object[] tmp = null;
        if (ts != null && ts.length > 0) {
            tmp = (Object[])ts.clone();
        }
        this.ts = tmp;
    }
}

