/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.jdbc.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConThreadLocal {
    private static final ThreadLocal<Boolean> transLock = new ThreadLocal();
    private static final ThreadLocal<HashMap<String, Connection>> cons = new ThreadLocal();

    public static void lock(boolean value) {
        transLock.set(value);
    }

    public static Boolean isTrans() {
        if (transLock.get() == null) {
            transLock.set(false);
        }
        return transLock.get();
    }

    public static Map<String, Connection> getCons() {
        return cons.get();
    }

    public static void setLevel(int level) throws SQLException {
        Map<String, Connection> cons = ConThreadLocal.getCons();
        if (cons != null) {
            for (Map.Entry<String, Connection> entry : cons.entrySet()) {
                entry.getValue().setTransactionIsolation(level);
            }
        }
    }

    public static void commit() throws SQLException {
        Map<String, Connection> cons = ConThreadLocal.getCons();
        if (cons != null) {
            for (Map.Entry<String, Connection> entry : cons.entrySet()) {
                entry.getValue().commit();
            }
        }
    }

    public static void rollback() throws SQLException {
        Map<String, Connection> cons = ConThreadLocal.getCons();
        if (cons != null) {
            for (Map.Entry<String, Connection> entry : cons.entrySet()) {
                entry.getValue().rollback();
            }
        }
    }

    public static void close() throws SQLException {
        Map<String, Connection> cons = ConThreadLocal.getCons();
        if (cons != null) {
            for (Map.Entry<String, Connection> entry : cons.entrySet()) {
                entry.getValue().close();
            }
        }
        ConThreadLocal.remove();
        ConThreadLocal.lock(false);
    }

    public static Connection getCon(String dsName) {
        if (dsName == null) {
            dsName = "myDBInfo";
        }
        if (cons.get() == null) {
            cons.set(new HashMap());
        }
        return cons.get().get(dsName);
    }

    public static Connection getCon() {
        return ConThreadLocal.getCon(null);
    }

    public static void put(String dsName, Connection con) {
        if (transLock.get().booleanValue()) {
            HashMap<String, Connection> map = cons.get();
            if (map == null) {
                map = new HashMap<String, Connection>();
            }
            map.put(dsName, con);
        }
    }

    public static void remove() {
        cons.remove();
    }
}

