/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.orm.dao.select;

import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.eweb4j.orm.dao.DAOException;
import org.eweb4j.orm.dao.select.SearchDAO;
import org.eweb4j.orm.jdbc.JdbcUtil;
import org.eweb4j.orm.sql.SqlFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchDAOImpl
implements SearchDAO {
    private String dbType;
    private DataSource ds;

    public SearchDAOImpl(DataSource ds, String dbType) {
        this.ds = ds;
        this.dbType = dbType;
    }

    @Override
    public <T> List<T> searchByDivPage(T t, String[] fields, int likeType, boolean isLike, boolean isNot, boolean isOR, String orderField, int oType, int currentPage, int numPerPage) throws DAOException {
        List<?> list = null;
        if (t != null) {
            Connection con = null;
            Class<?> clazz = t.getClass();
            try {
                con = this.ds.getConnection();
                String sql = SqlFactory.getSelectSql(t, this.dbType).selectWhere(fields, likeType, isLike, isNot, isOR, orderField, oType, currentPage, numPerPage);
                list = JdbcUtil.getList(con, clazz, sql);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return list;
    }

    @Override
    public <T> List<T> search(T t, String[] fields, int likeType, boolean isLike, boolean isNot, boolean isOR, String orderField, int oType) throws DAOException {
        List<?> list = null;
        if (t != null) {
            Class<?> clazz = t.getClass();
            Connection con = null;
            try {
                con = this.ds.getConnection();
                String sql = SqlFactory.getSelectSql(t, this.dbType).selectWhere(fields, likeType, isLike, isNot, isOR, orderField, oType, -1, -1);
                list = JdbcUtil.getList(con, clazz, sql);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return list;
    }

    @Override
    public <T> List<T> searchByDivPage(Class<T> clazz, String[] fields, String[] values, int likeType, boolean isLike, boolean isNot, boolean isOR, String orderField, int oType, int currentPage, int numPerPage) throws DAOException {
        List<T> list = null;
        if (clazz != null) {
            Connection con = null;
            try {
                con = this.ds.getConnection();
                T t = clazz.newInstance();
                String sql = SqlFactory.getSelectSql(t, this.dbType).selectWhere(fields, values, likeType, isLike, isNot, isOR, orderField, oType, currentPage, numPerPage);
                list = JdbcUtil.getList(con, clazz, sql);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return list;
    }

    @Override
    public <T> List<T> search(Class<T> clazz, String[] fields, String[] values, int likeType, boolean isLike, boolean isNot, boolean isOR, String orderField, int oType) throws DAOException {
        List<T> list = null;
        if (clazz != null) {
            Connection con = null;
            try {
                con = this.ds.getConnection();
                T t = clazz.newInstance();
                String sql = SqlFactory.getSelectSql(t, this.dbType).selectWhere(fields, values, likeType, isLike, isNot, isOR, orderField, oType, -1, -1);
                list = JdbcUtil.getList(con, clazz, sql);
            }
            catch (Exception e) {
                throw new DAOException("", e);
            }
        }
        return list;
    }

    @Override
    public <T> List<T> searchByExact(Class<T> clazz, String[] fields, String[] values, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(clazz, fields, values, 0, false, false, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByNotExact(Class<T> clazz, String[] fields, String[] values, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(clazz, fields, values, 0, false, true, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByExact(T t, String[] fields, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(t, fields, 0, false, false, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByNotExact(T t, String[] fields, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(t, fields, 0, false, true, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByLike(Class<T> clazz, String[] fields, String[] values, int likeType, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(clazz, fields, values, likeType, true, false, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByNotLike(Class<T> clazz, String[] fields, String[] values, int likeType, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(clazz, fields, values, likeType, true, true, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByLike(T t, String[] fields, int likeType, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(t, fields, likeType, true, false, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByNotLike(T t, String[] fields, int likeType, String orderField, int orderType, boolean isOR) throws DAOException {
        return this.search(t, fields, likeType, true, true, isOR, orderField, orderType);
    }

    @Override
    public <T> List<T> searchByLikeAndOrderByIdField(Class<T> clazz, String[] fields, String[] values, int likeType, int orderType, boolean isOR) throws DAOException {
        return this.searchByLike(clazz, fields, values, likeType, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByNotLikeAndOrderByIdField(Class<T> clazz, String[] fields, String[] values, int likeType, int orderType, boolean isOR) throws DAOException {
        return this.searchByNotLike(clazz, fields, values, likeType, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByLikeAndOrderByIdField(T t, String[] fields, int likeType, int orderType, boolean isOR) throws DAOException {
        return this.searchByLike(t, fields, likeType, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByExactAndOrderByIdField(Class<T> clazz, String[] fields, String[] values, int orderType, boolean isOR) throws DAOException {
        return this.searchByExact(clazz, fields, values, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByNotExactAndOrderByIdField(Class<T> clazz, String[] fields, String[] values, int orderType, boolean isOR) throws DAOException {
        return this.searchByNotExact(clazz, fields, values, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByExactAndOrderByIdField(T t, String[] fields, int orderType, boolean isOR) throws DAOException {
        return this.searchByExact(t, fields, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByNotExactAndOrderByIdField(T t, String[] fields, int orderType, boolean isOR) throws DAOException {
        return this.searchByNotExact(t, fields, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByExactAndOrderByIdFieldDESC(Class<T> clazz, String[] fields, String[] values, boolean isOR) throws DAOException {
        return this.searchByExactAndOrderByIdField(clazz, fields, values, -1, isOR);
    }

    @Override
    public <T> List<T> searchByNotExactAndOrderByIdFieldDESC(Class<T> clazz, String[] fields, String[] values, boolean isOR) throws DAOException {
        return this.searchByNotExactAndOrderByIdField(clazz, fields, values, -1, isOR);
    }

    @Override
    public <T> List<T> searchByExactAndOrderByIdFieldDESC(T t, String[] fields, boolean isOR) throws DAOException {
        return this.searchByExactAndOrderByIdField(t, fields, -1, isOR);
    }

    @Override
    public <T> List<T> searchByNotExactAndOrderByIdFieldDESC(T t, String[] fields, boolean isOR) throws DAOException {
        return this.searchByNotExactAndOrderByIdField(t, fields, -1, isOR);
    }

    @Override
    public <T> List<T> searchByNotLikeAndOrderByIdField(T t, String[] fields, int likeType, int orderType, boolean isOR) throws DAOException {
        return this.searchByNotLike(t, fields, likeType, null, orderType, isOR);
    }

    @Override
    public <T> List<T> searchByLikeAndOrderByIdFieldDESC(Class<T> clazz, String[] fields, String[] values, int likeType, boolean isOR) throws DAOException {
        return this.searchByLikeAndOrderByIdField(clazz, fields, values, likeType, -1, isOR);
    }

    @Override
    public <T> List<T> searchByNotLikeAndOrderByIdFieldDESC(Class<T> clazz, String[] fields, String[] values, int likeType, boolean isOR) throws DAOException {
        return this.searchByNotLikeAndOrderByIdField(clazz, fields, values, likeType, -1, isOR);
    }

    @Override
    public <T> List<T> searchByLikeAndOrderByIdFieldDESC(T t, String[] fields, int likeType, boolean isOR) throws DAOException {
        return this.searchByLikeAndOrderByIdField(t, fields, likeType, -1, isOR);
    }

    @Override
    public <T> List<T> searchByNotLikeAndOrderByIdFieldDESC(T t, String[] fields, int likeType, boolean isOR) throws DAOException {
        return this.searchByNotLikeAndOrderByIdField(t, fields, likeType, -1, isOR);
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public DataSource getDs() {
        return this.ds;
    }

    public void setDs(DataSource ds) {
        this.ds = ds;
    }
}

