/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.view;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.mvc.config.MVCConfigConstant;
import org.eweb4j.mvc.view.Renderer;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityRendererImpl
extends Renderer {
    public static final Log log = LogFactory.getLogger(VelocityRendererImpl.class);
    public VelocityEngine ve = (VelocityEngine)SingleBeanCache.get("velocity");

    public VelocityRendererImpl() {
        if (this.ve == null) {
            File viewsDir = new File(String.valueOf(ConfigConstant.ROOT_PATH) + MVCConfigConstant.FORWARD_BASE_PATH);
            Properties p = new Properties();
            p.setProperty("resource.loader", "file");
            p.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
            p.setProperty("file.resource.loader.path", viewsDir.getAbsolutePath());
            p.setProperty("file.resource.loader.cache", "true");
            p.setProperty("file.resource.loader.modificationCheckInterval", "2");
            p.setProperty("ISO-8859-1", "UTF-8");
            p.setProperty("input.encoding", "UTF-8");
            p.setProperty("output.encoding", "UTF-8");
            this.ve = new VelocityEngine();
            this.ve.init(p);
            SingleBeanCache.add("velocity", this.ve);
        }
    }

    @Override
    public String render(String name, Object value) {
        return this.render(CommonUtil.map(name, value));
    }

    @Override
    public String render() {
        return this.render(new HashMap<String, Object>());
    }

    @Override
    public String render(Map<String, Object> datas) {
        StringWriter writer = new StringWriter();
        this.render(writer, datas);
        return writer.toString();
    }

    @Override
    public void render(Writer writer) {
        this.render(writer, null);
    }

    @Override
    public synchronized void render(Writer writer, Map<String, Object> datas) {
        VelocityContext context = new VelocityContext();
        if (datas != null) {
            for (Map.Entry<String, Object> e : datas.entrySet()) {
                context.put(e.getKey(), e.getValue());
            }
        }
        String tplPath = (String)this.paths.get(MVCConfigConstant.LAYOUT_SCREEN_CONTENT_KEY);
        if (this.layout != null) {
            for (Map.Entry e : this.paths.entrySet()) {
                String paramName = (String)e.getKey();
                String path = (String)e.getValue();
                StringWriter w = new StringWriter();
                this.ve.getTemplate(path).merge((Context)context, (Writer)w);
                String screenContent = w.toString();
                context.put(paramName, (Object)screenContent);
            }
            tplPath = this.layout;
        }
        this.ve.getTemplate(tplPath).merge((Context)context, writer);
    }

    @Override
    public String render(Map<String, Object> datas, String template) {
        Velocity.init();
        VelocityContext context = new VelocityContext();
        for (Map.Entry<String, Object> e : datas.entrySet()) {
            context.put(e.getKey(), e.getValue());
        }
        StringWriter writer = new StringWriter();
        Velocity.evaluate((Context)context, (Writer)writer, (String)"", (String)template);
        return writer.toString();
    }
}

