/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.view;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paging {
    public int start = 1;
    public int end;
    public int nextNum;
    public String nextBtn = "\u4e0b\u4e00\u9875";
    public int preNum;
    public String preBtn = "\u4e0a\u4e00\u9875";
    public long allCount;
    public int currentNum;
    public int pageCount;
    public int numPerPage;
    public int maxShow;
    public String firstBtn = "\u9996\u9875";
    public String lastBtn = "\u672b\u9875";
    public List<Integer> numbers = new ArrayList<Integer>();

    public Paging(int pageNum, int numPerPage, long allCount, int maxShow) {
        if (pageNum == 0) {
            pageNum = 1;
        }
        if (numPerPage == 0) {
            numPerPage = 10;
        }
        this.maxShow = maxShow;
        this.currentNum = pageNum;
        this.numPerPage = numPerPage;
        this.allCount = allCount;
        this.doWork();
    }

    public Paging(String strPageNum, String strNumPerPage, long allCount, int maxShow) {
        int pageNum = 1;
        if (strPageNum.matches("^-?\\d+$")) {
            pageNum = Integer.parseInt(strPageNum);
        }
        int numPerPage = 10;
        if (strNumPerPage.matches("^-?\\d+$")) {
            numPerPage = Integer.parseInt(strNumPerPage);
        }
        this.maxShow = maxShow;
        this.currentNum = pageNum;
        this.numPerPage = numPerPage;
        this.allCount = allCount;
        this.doWork();
    }

    public void doWork() {
        int add;
        this.countPageCount();
        this.doNextAndPre();
        if (this.pageCount < this.maxShow) {
            this.maxShow = this.pageCount;
        }
        this.end = this.maxShow + this.currentNum;
        if (this.end >= this.pageCount) {
            this.end = this.pageCount;
        }
        if ((add = this.currentNum - this.maxShow) > this.start) {
            this.start = add;
        }
        int i = this.start;
        while (i <= this.end) {
            this.numbers.add(i);
            ++i;
        }
    }

    private void countPageCount() {
        this.pageCount = (int)(this.allCount - 1L) / this.numPerPage + 1;
    }

    private void doNextAndPre() {
        this.nextNum = this.currentNum < this.pageCount ? this.currentNum + 1 : this.pageCount;
        this.preNum = this.currentNum > 1 ? this.currentNum - 1 : 1;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 1) {
            this.currentNum = 1;
            return;
        }
        this.currentNum = this.pageCount >= currentPage ? currentPage : this.pageCount;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public int getNextNum() {
        return this.nextNum;
    }

    public void setNextNum(int nextNum) {
        this.nextNum = nextNum;
    }

    public String getNextBtn() {
        return this.nextBtn;
    }

    public void setNextBtn(String nextBtn) {
        this.nextBtn = nextBtn;
    }

    public int getPreNum() {
        return this.preNum;
    }

    public void setPreNum(int preNum) {
        this.preNum = preNum;
    }

    public String getPreBtn() {
        return this.preBtn;
    }

    public void setPreBtn(String preBtn) {
        this.preBtn = preBtn;
    }

    public long getAllCount() {
        return this.allCount;
    }

    public void setAllCount(long allCount) {
        this.allCount = allCount;
    }

    public int getCurrentNum() {
        return this.currentNum;
    }

    public void setCurrentNum(int currentNum) {
        this.currentNum = currentNum;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getNumPerPage() {
        return this.numPerPage;
    }

    public void setNumPerPage(int numPerPage) {
        this.numPerPage = numPerPage;
    }

    public int getMaxShow() {
        return this.maxShow;
    }

    public void setMaxShow(int maxShow) {
        this.maxShow = maxShow;
    }

    public String getFirstBtn() {
        return this.firstBtn;
    }

    public void setFirstBtn(String firstBtn) {
        this.firstBtn = firstBtn;
    }

    public String getLastBtn() {
        return this.lastBtn;
    }

    public void setLastBtn(String lastBtn) {
        this.lastBtn = lastBtn;
    }

    public List<Integer> getNumbers() {
        return this.numbers;
    }

    public void setNumbers(List<Integer> numbers) {
        this.numbers = numbers;
    }
}

