/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.view;

public class DivPageComp {
    private String location;
    private int nextPage;
    private int prePage;
    private long allCount;
    private int currentPage;
    private int pageCount;
    private int numPerPage;
    private int maxShow;
    private String html;
    private String classStyle;
    private String curPageClassStyle;
    private String nxtBtnName = "\u4e0b\u4e00\u9875";
    private String preBtnName = "\u4e0a\u4e00\u9875";
    private String firstBtnName = "\u9996\u9875";
    private String lastBtnName = "\u672b\u9875";

    public DivPageComp(int pageNum, int numPerPage, long allCount) {
        if (pageNum == 0) {
            pageNum = 1;
        }
        if (numPerPage == 0) {
            numPerPage = 10;
        }
        this.setMaxShow(4);
        this.currentPage = pageNum;
        this.numPerPage = numPerPage;
        this.allCount = allCount;
        this.doWork();
    }

    public DivPageComp(int pageNum, int numPerPage, long allCount, int maxShow) {
        if (pageNum == 0) {
            pageNum = 1;
        }
        if (numPerPage == 0) {
            numPerPage = 10;
        }
        this.setMaxShow(maxShow);
        this.currentPage = pageNum;
        this.numPerPage = numPerPage;
        this.allCount = allCount;
        this.doWork();
    }

    public DivPageComp(String strPageNum, String strNumPerPage, long allCount, int maxShow) {
        int pageNum = 1;
        if (strPageNum.matches("^-?\\d+$")) {
            pageNum = Integer.parseInt(strPageNum);
        }
        int numPerPage = 10;
        if (strNumPerPage.matches("^-?\\d+$")) {
            numPerPage = Integer.parseInt(strNumPerPage);
        }
        this.setMaxShow(maxShow);
        this.currentPage = pageNum;
        this.numPerPage = numPerPage;
        this.allCount = allCount;
        this.doWork();
    }

    public void doWork() {
        int add;
        String clickHandler = "divPage(%s)";
        if (this.location != null && !"".equals(this.location.trim())) {
            clickHandler = "window.location='" + this.location.replace("{pageNum}", "%s") + "'";
        }
        this.countPageCount();
        this.doNextAndPre();
        if (this.pageCount < this.maxShow) {
            this.maxShow = this.pageCount;
        }
        StringBuilder sb = new StringBuilder();
        if (this.prePage > 1) {
            if (this.classStyle != null) {
                sb.append("<span class=\"").append(this.classStyle).append("\" onclick=\"").append(String.format(clickHandler, this.prePage)).append("\"").append(">" + this.preBtnName + "</span>");
            } else {
                sb.append("<span onmouseover=\"this.style.color='red'\" onmouseout=\"this.style.color=''\" style='padding:5px; cursor:pointer;' onclick=\"").append(String.format(clickHandler, this.prePage)).append("\"").append(">" + this.preBtnName + "</span>");
            }
        }
        int start = 1;
        int end = this.maxShow + this.currentPage;
        if (end >= this.pageCount) {
            end = this.pageCount;
        }
        if ((add = this.currentPage - this.maxShow) > start) {
            start = add;
        }
        if (start > this.maxShow) {
            if (this.classStyle != null) {
                sb.append("<span class='").append(this.classStyle).append("'").append(" onclick=\"").append(String.format(clickHandler, 1)).append("\"").append(">").append(this.firstBtnName).append("</span>...");
            } else {
                sb.append("<span onmouseover=\"this.style.color='red'\" onmouseout=\"this.style.color=''\" style='padding:5px; cursor:pointer;' onclick=\"").append(String.format(clickHandler, 1)).append("\"").append(")>[").append(this.firstBtnName).append("]</span>...");
            }
        }
        int i = start;
        while (i <= end) {
            if (this.classStyle != null) {
                sb.append("<span class=\"").append(this.classStyle).append("\"");
            } else {
                sb.append("<span onmouseover=\"this.style.color='red'\" onmouseout=\"this.style.color=''\" style='padding:5px; cursor:pointer;' ");
            }
            if (i == this.currentPage) {
                if (this.curPageClassStyle != null && !"".equals(this.curPageClassStyle)) {
                    sb.append("'><span class='").append(this.curPageClassStyle).append("'>").append(i).append("</span>");
                } else {
                    sb.append("'><font color='red'><span style='color:red;cursor:text;'>").append(i).append("</span></font>");
                }
            } else {
                sb.append("onclick=\"").append(String.format(clickHandler, i)).append("\"").append(">");
                if (this.classStyle != null) {
                    sb.append(i);
                } else {
                    sb.append("[").append(i).append("]");
                }
            }
            sb.append("</span>");
            ++i;
        }
        if (end < this.pageCount - this.maxShow) {
            if (this.classStyle != null) {
                sb.append("... <span class='").append(this.classStyle).append("'").append(" onclick=\"").append(String.format(clickHandler, this.pageCount)).append("\"").append(">").append(this.lastBtnName).append("</span>");
            } else {
                sb.append("... <span onmouseover=\"this.style.color='red'\" onmouseout=\"this.style.color=''\" style='padding:5px; cursor:pointer;'").append(" onclick=\"").append(String.format(clickHandler, this.pageCount)).append("\"").append(">[").append(this.lastBtnName).append("]</span>");
            }
        }
        if (this.nextPage < this.pageCount) {
            if (this.classStyle != null) {
                sb.append("<span class=\"").append(this.classStyle).append("\"").append(" onclick=\"").append(String.format(clickHandler, this.nextPage)).append("\"").append(">" + this.nxtBtnName + "</span>");
            } else {
                sb.append("<span onmouseover=\"this.style.color='red'\" onmouseout=\"this.style.color=''\" style='padding:5px; cursor:pointer;' onclick=\"").append(String.format(clickHandler, this.nextPage)).append("\"").append(">" + this.nxtBtnName + "</span>");
            }
        }
        this.html = sb.toString();
    }

    private void countPageCount() {
        this.pageCount = (int)(this.allCount - 1L) / this.numPerPage + 1;
    }

    private void doNextAndPre() {
        this.nextPage = this.currentPage < this.pageCount ? this.currentPage + 1 : this.pageCount;
        this.prePage = this.currentPage > 1 ? this.currentPage - 1 : 1;
    }

    public int getNextPage() {
        return this.nextPage;
    }

    public void setNextPage(int nextPage) {
        this.nextPage = nextPage;
    }

    public int getPrePage() {
        return this.prePage;
    }

    public void setPrePage(int prePage) {
        this.prePage = prePage;
    }

    public long getAllCount() {
        return this.allCount;
    }

    public void setAllCount(long allCount) {
        this.allCount = allCount;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        if (currentPage < 1) {
            this.currentPage = 1;
            return;
        }
        this.currentPage = this.pageCount >= currentPage ? currentPage : this.pageCount;
    }

    public int getNumPerPage() {
        return this.numPerPage;
    }

    public void setNumPerPage(int numPerPage) {
        this.numPerPage = numPerPage;
    }

    public void setPageCount(int pageCount) {
        this.pageCount = pageCount;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public String getHtml() {
        return this.html;
    }

    public void setMaxShow(int maxShow) {
        this.maxShow = maxShow;
    }

    public int getMaxShow() {
        return this.maxShow;
    }

    public void setClassStyle(String classStyle) {
        this.classStyle = classStyle;
    }

    public String getClassStyle() {
        return this.classStyle;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getCurPageClassStyle() {
        return this.curPageClassStyle;
    }

    public void setCurPageClassStyle(String curPageClassStyle) {
        this.curPageClassStyle = curPageClassStyle;
    }

    public String getNxtBtnName() {
        return this.nxtBtnName;
    }

    public void setNxtBtnName(String nxtBtnName) {
        this.nxtBtnName = nxtBtnName;
    }

    public String getPreBtnName() {
        return this.preBtnName;
    }

    public void setPreBtnName(String preBtnName) {
        this.preBtnName = preBtnName;
    }

    public String getFirstBtnName() {
        return this.firstBtnName;
    }

    public void setFirstBtnName(String firstBtnName) {
        this.firstBtnName = firstBtnName;
    }

    public String getLastBtnName() {
        return this.lastBtnName;
    }

    public void setLastBtnName(String lastBtnName) {
        this.lastBtnName = lastBtnName;
    }
}

