/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc.validator;

import java.util.HashMap;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.action.Validation;
import org.eweb4j.mvc.config.bean.FieldConfigBean;
import org.eweb4j.mvc.config.bean.ParamConfigBean;
import org.eweb4j.mvc.config.bean.ValidatorConfigBean;
import org.eweb4j.mvc.validator.ValidatorIF;

public class StringLengthValidator
implements ValidatorIF {
    public Validation validate(ValidatorConfigBean val, Context context) {
        HashMap<String, String> valError = new HashMap<String, String>();
        for (FieldConfigBean f : val.getField()) {
            String[] value = context.getQueryParamMap().get(f.getName());
            if (value == null || value.length == 0) continue;
            String mess = f.getMessage();
            int min = 0;
            int max = 0;
            boolean minFlag = false;
            boolean maxFlag = false;
            for (ParamConfigBean p : f.getParam()) {
                if ("minLength".equals(p.getName())) {
                    min = Integer.parseInt(p.getValue());
                    minFlag = true;
                } else if ("maxLength".equals(p.getName())) {
                    max = Integer.parseInt(p.getValue());
                    maxFlag = true;
                }
                if (minFlag && maxFlag) break;
            }
            mess = mess.replace("{min}", String.valueOf(min)).replace("{max}", String.valueOf(max));
            String[] stringArray = value;
            int n = value.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (v.length() < min) {
                    valError.put(f.getName(), mess);
                    break;
                }
                if (v.length() > max) {
                    valError.put(f.getName(), mess);
                    break;
                }
                ++n2;
            }
            context.getRequest().setAttribute(f.getName(), (Object)value);
        }
        Validation validation = new Validation();
        if (!valError.isEmpty()) {
            validation.getErrors().put(val.getName(), valError);
        }
        return validation;
    }
}

