/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.mvc;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.EWeb4JConfig;
import org.eweb4j.config.LogFactory;
import org.eweb4j.i18n.Lang;
import org.eweb4j.mvc.Context;
import org.eweb4j.mvc.HtmlCreator;
import org.eweb4j.mvc.MVC;
import org.eweb4j.mvc.ParamUtil;
import org.eweb4j.mvc.action.ActionExecution;
import org.eweb4j.mvc.config.ActionConfig;
import org.eweb4j.mvc.config.MVCConfigConstant;
import org.eweb4j.mvc.interceptor.InterExecution;
import org.eweb4j.mvc.upload.UploadFile;
import org.eweb4j.mvc.upload.UploadUtil;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.FileUtil;

public class EWebFilter
implements Filter,
Servlet {
    private static ServletContext servletContext;

    public void init(FilterConfig config) throws ServletException {
        servletContext = config.getServletContext();
        EWeb4JConfig.setCONFIG_BASE_PATH(config.getInitParameter("ConfigBasePath"));
        EWeb4JConfig.setCHECK_START_FILE_EXIST(config.getInitParameter("CheckStartFileExist"));
        EWeb4JConfig.setSTART_FILE_NAME(config.getInitParameter("StartFileName"));
        ActionConfig.setFORWARD_BASE_PATH(config.getInitParameter("ForwardBasePath"));
        ActionConfig.setFORWARD_BASE_PATH(config.getInitParameter("ViewBasePath"));
        ActionConfig.setLAYOUT_SCREEN_CONTENT_KEY(config.getInitParameter("ScreenContent"));
        ActionConfig.setBASE_URL_KEY(config.getInitParameter("BaseURLKey"));
        ActionConfig.setREQ_PARAM_SCOPE_KEY(config.getInitParameter("ReqParamMapKey"));
        ActionConfig.setHTTP_HEADER_ACCEPT_PARAM(config.getInitParameter("HttpMethod"));
        ActionConfig.setHTTP_HEADER_ACCEPT_PARAM(config.getInitParameter("HeaderAccept"));
        StringBuilder info = new StringBuilder("eweb4j filter init \n");
        info.append("RootPath --> ").append(ConfigConstant.ROOT_PATH).append("\n");
        info.append("ConfigBasePath --> ").append(ConfigConstant.CONFIG_BASE_PATH).append("\n");
        info.append("StartFileName --> ").append(ConfigConstant.START_FILE_NAME).append("\n");
        info.append("BaseURLKey --> ").append(MVCConfigConstant.BASE_URL_KEY).append("\n");
        info.append("LayoutScreenContentKey --> ").append(MVCConfigConstant.LAYOUT_SCREEN_CONTENT_KEY).append("\n");
        info.append("ReqParamMapKey --> ").append(MVCConfigConstant.REQ_PARAM_SCOPE_KEY).append("\n");
        System.out.println(info.toString());
    }

    public static final boolean isMultipartContent(HttpServletRequest request) {
        if (!"post".equals(request.getMethod().toLowerCase())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith("multipart/");
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    private Context initContext(HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setCharacterEncoding("utf-8");
        response.setCharacterEncoding("utf-8");
        response.setContentType("text/html");
        Context context = new Context(servletContext, request, response, null, null, null, null);
        String ip = EWebFilter.getIpAddr(request);
        context.setIp(ip);
        HashMap<String, String[]> qpMap = new HashMap<String, String[]>();
        qpMap.putAll(ParamUtil.copyReqParams(context.getRequest()));
        context.setQueryParamMap(qpMap);
        if (EWebFilter.isMultipartContent(context.getRequest())) {
            UploadUtil.handleUpload(context);
        }
        return context;
    }

    /*
     * Unable to fully structure code
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        block27: {
            block26: {
                block28: {
                    block24: {
                        block25: {
                            block22: {
                                block23: {
                                    block20: {
                                        block21: {
                                            request = (HttpServletRequest)req;
                                            response = (HttpServletResponse)res;
                                            context = null;
                                            err = EWeb4JConfig.start(ConfigConstant.START_FILE_NAME);
                                            if (err == null) break block20;
                                            this.printHtml(err, res.getWriter());
                                            if (context == null || context.getUploadMap().isEmpty()) break block21;
                                            ** for (en : context.getUploadMap().entrySet())
lbl-1000:
                                            // 1 sources

                                            {
                                                if (en.getValue() == null) continue;
                                                for (UploadFile f : en.getValue()) {
                                                    FileUtil.deleteFile(f.getTmpFile());
                                                }
                                                continue;
                                            }
                                        }
                                        return;
                                    }
                                    context = this.initContext(request, response);
                                    MVC.getThreadLocal().set(context);
                                    Lang.change(request.getLocale());
                                    uri = this.parseURL(request);
                                    context.setUri(uri);
                                    this.parseBaseUrl(context);
                                    reqMethod = this.parseMethod(request);
                                    context.setHttpMethod(reqMethod);
                                    before_interExe = new InterExecution("before", context);
                                    if (!before_interExe.findAndExecuteInter()) break block22;
                                    before_interExe.showErr();
                                    if (context == null || context.getUploadMap().isEmpty()) break block23;
                                    ** for (en : context.getUploadMap().entrySet())
lbl-1000:
                                    // 1 sources

                                    {
                                        if (en.getValue() == null) continue;
                                        for (UploadFile f : en.getValue()) {
                                            FileUtil.deleteFile(f.getTmpFile());
                                        }
                                        continue;
                                    }
                                }
                                return;
                            }
                            actionExe = new ActionExecution(uri, reqMethod, context);
                            if (!actionExe.findAction()) break block24;
                            actionExe.execute();
                            if (context == null || context.getUploadMap().isEmpty()) break block25;
                            ** for (en : context.getUploadMap().entrySet())
lbl-1000:
                            // 1 sources

                            {
                                if (en.getValue() == null) continue;
                                for (UploadFile f : en.getValue()) {
                                    FileUtil.deleteFile(f.getTmpFile());
                                }
                                continue;
                            }
                        }
                        return;
                    }
                    try {
                        try {
                            this.normalReqLog(uri);
                            chain.doFilter(req, res);
                            break block26;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            info = CommonUtil.getExceptionString(e);
                            LogFactory.getMVCLogger(EWebFilter.class).error(info);
                            this.printHtml(info, res.getWriter());
                            if (context == null || context.getUploadMap().isEmpty()) break block27;
                            ** for (en : context.getUploadMap().entrySet())
                        }
                    }
                    catch (Throwable var12_37) {
                        if (context == null || context.getUploadMap().isEmpty()) break block28;
                        ** for (en : context.getUploadMap().entrySet())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (en.getValue() == null) continue;
                        for (UploadFile f : en.getValue()) {
                            FileUtil.deleteFile(f.getTmpFile());
                        }
                        continue;
lbl76:
                        // 1 sources

                        break block27;
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (en.getValue() == null) continue;
                        for (UploadFile f : en.getValue()) {
                            FileUtil.deleteFile(f.getTmpFile());
                        }
                        continue;
                    }
                }
                throw var12_37;
            }
            if (context != null && !context.getUploadMap().isEmpty()) {
                for (Map.Entry<String, List<UploadFile>> en : context.getUploadMap().entrySet()) {
                    if (en.getValue() == null) continue;
                    for (UploadFile f : en.getValue()) {
                        FileUtil.deleteFile(f.getTmpFile());
                    }
                }
            }
        }
    }

    private void printHtml(String err, PrintWriter writer) {
        writer.print(HtmlCreator.create(err));
        writer.flush();
        writer = null;
    }

    private String parseURL(HttpServletRequest request) throws Exception {
        String uri = URLDecoder.decode(request.getRequestURI(), "utf-8");
        String contextPath = URLDecoder.decode(request.getContextPath(), "utf-8");
        if (contextPath != null && contextPath.trim().length() > 0) {
            return uri.replace(String.valueOf(contextPath) + "/", "");
        }
        return uri.substring(1);
    }

    private void parseBaseUrl(Context context) throws Exception {
        ServletContext servletContext = context.getServletContext();
        HttpServletRequest request = context.getRequest();
        String uri = context.getUri();
        if (servletContext.getAttribute(MVCConfigConstant.BASE_URL_KEY) == null) {
            String baseUrl;
            String url = URLDecoder.decode(request.getRequestURL().toString(), "utf-8");
            MVCConfigConstant.BASE_URL = baseUrl = url.replace(uri, "");
            servletContext.setAttribute(MVCConfigConstant.BASE_URL_KEY, (Object)baseUrl);
            LogFactory.getMVCLogger(EWebFilter.class).debug("${" + MVCConfigConstant.BASE_URL_KEY + "} -> " + baseUrl);
        }
    }

    private String parseMethod(HttpServletRequest request) {
        String reqMethod = request.getMethod();
        if (!"POST".equalsIgnoreCase(reqMethod)) {
            return reqMethod;
        }
        String _method = request.getParameter(MVCConfigConstant.HTTP_METHOD_PARAM);
        if (_method == null) {
            return reqMethod;
        }
        if ("PUT".equalsIgnoreCase(_method.trim())) {
            reqMethod = "PUT";
        } else if ("DELETE".equalsIgnoreCase(_method.trim())) {
            reqMethod = "DELETE";
        }
        return reqMethod;
    }

    public void destroy() {
        String info = "eweb4j filter destroy invoke...\n";
        LogFactory.getMVCLogger(EWebFilter.class).debug(info);
    }

    private void normalReqLog(String uri) {
        StringBuilder sb = new StringBuilder();
        sb.append("normal uri -> ").append(uri);
        LogFactory.getMVCLogger(EWebFilter.class).debug(sb.toString());
    }

    public void init(ServletConfig config) throws ServletException {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
    }

    public String getServletInfo() {
        return null;
    }
}

