/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.config;

import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogImpl;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.config.bean.LogConfigBean;
import org.eweb4j.config.bean.LogsConfigBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFactory {
    public static Log getIOCLogger(Class<?> clazz) {
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        LogsConfigBean logs = cb == null ? new LogsConfigBean() : cb.getIoc().getLogs();
        return new LogImpl(logs, "IOC", clazz);
    }

    public static Log getMVCLogger(Class<?> clazz) {
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        LogsConfigBean logs = cb == null ? new LogsConfigBean() : cb.getMvc().getLogs();
        return new LogImpl(logs, "MVC", clazz);
    }

    public static Log getORMLogger(Class<?> clazz) {
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        LogsConfigBean logs = cb == null ? new LogsConfigBean() : cb.getOrm().getLogs();
        return new LogImpl(logs, "ORM", clazz);
    }

    public static Log getLogger(Class<?> clazz) {
        return LogFactory.getLogger(clazz, true);
    }

    public static Log getLogger(Class<?> clazz, boolean isConsole) {
        LogConfigBean log = new LogConfigBean();
        log.setLevel("debug");
        log.setFile(null);
        log.setSize("0");
        log.setConsole(String.valueOf(isConsole));
        LogsConfigBean logs = new LogsConfigBean();
        logs.getLog().add(log);
        return new LogImpl(logs, "CONFIG", clazz);
    }

    @Deprecated
    public static Log getConfigLogger(Class<?> clazz) {
        return LogFactory.getLogger(clazz);
    }
}

