/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eweb4j.cache.Cache;
import org.eweb4j.util.CommonUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<K, V>
implements Cache<K, V> {
    private Map<K, CacheEntry<V>> cache;
    private Queue<K> queue;
    private int maxSize;
    private AtomicInteger cacheSize = new AtomicInteger();

    public SimpleCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = new ConcurrentHashMap<K, CacheEntry<V>>(maxSize);
        this.queue = new ConcurrentLinkedQueue<K>();
    }

    public SimpleCache() {
        this.maxSize = -1;
        this.cache = new ConcurrentHashMap<K, CacheEntry<V>>();
        this.queue = new ConcurrentLinkedQueue<K>();
    }

    @Override
    public V get(K key) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid Key.");
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        long timestamp = entry.getExpireBy();
        if (timestamp != -1L && System.currentTimeMillis() > timestamp) {
            this.remove(key);
            return null;
        }
        return entry.getEntry();
    }

    @Override
    public V removeAndGet(K key) {
        if (key == null) {
            return null;
        }
        CacheEntry<V> entry = this.cache.get(key);
        if (entry != null) {
            this.cacheSize.decrementAndGet();
            return this.cache.remove(key).getEntry();
        }
        return null;
    }

    @Override
    public void put(K key, V value, long secondsToLive) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid Key.");
        }
        if (value == null) {
            return;
        }
        long expireBy = secondsToLive != -1L ? System.currentTimeMillis() + secondsToLive * 1000L : secondsToLive;
        boolean exists = this.cache.containsKey(key);
        if (!exists) {
            this.cacheSize.incrementAndGet();
            while (this.maxSize > 0 && this.cacheSize.get() > this.maxSize) {
                this.remove(this.queue.poll());
            }
        }
        this.cache.put(key, new CacheEntry<V>(expireBy, value));
        this.queue.add(key);
    }

    @Override
    public void put(K key, V value) {
        this.put(key, value, -1L);
    }

    @Override
    public void put(K key, V value, String timeToLive) {
        this.put(key, value, CommonUtil.toSeconds(timeToLive).longValue());
    }

    @Override
    public boolean remove(K key) {
        return this.removeAndGet(key) != null;
    }

    @Override
    public int size() {
        return this.cacheSize.get();
    }

    @Override
    public Map<K, V> getAll(Collection<K> collection) {
        HashMap<K, V> ret = new HashMap<K, V>();
        for (K o : collection) {
            ret.put(o, this.get(o));
        }
        return ret;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public int mapSize() {
        return this.cache.size();
    }

    public int queueSize() {
        return this.queue.size();
    }

    public static void main(String[] args) throws InterruptedException {
        SimpleCache<String, String> cache = new SimpleCache<String, String>(2);
        while (true) {
            String name;
            if ((name = (String)cache.get("name")) == null) {
                System.out.println("store the name to cache at -> " + CommonUtil.getNowTime());
                name = "laiweiwei";
                cache.put("name", name, 5L);
            }
            System.out.println("read the name->" + name + " from cache at -> " + CommonUtil.getNowTime());
            Thread.sleep(1000L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CacheEntry<V> {
        private long expireBy;
        private V entry;

        public CacheEntry(long expireBy, V entry) {
            this.expireBy = expireBy;
            this.entry = entry;
        }

        public long getExpireBy() {
            return this.expireBy;
        }

        public V getEntry() {
            return this.entry;
        }
    }
}

