/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.cache;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eweb4j.cache.SingleBeanCache;
import org.eweb4j.config.ConfigConstant;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.config.bean.ConfigBean;
import org.eweb4j.config.bean.I18N;
import org.eweb4j.config.bean.Locale;
import org.eweb4j.config.bean.Prop;
import org.eweb4j.i18n.Lang;
import org.eweb4j.util.CommonUtil;
import org.eweb4j.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Props {
    private static Log log = LogFactory.getIOCLogger(Props.class);
    private static Set<String> i18nIds = new HashSet<String>();
    private static Map<String, String> globalMap = new Hashtable<String, String>();
    private static Map<String, Map<String, String>> props = new Hashtable<String, Map<String, String>>();

    private Props() {
    }

    public static String get(String key) {
        return globalMap.get(key);
    }

    public static Map<String, String> getMap(String id) {
        if (i18nIds.contains(id)) {
            return new MapProxy<String, String>(id);
        }
        return props.get(id);
    }

    public static synchronized void reload(String propId) {
        if (propId == null || propId.trim().length() == 0) {
            return;
        }
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        for (Prop p : cb.getProperties().getFile()) {
            if (!propId.equals(p.getId())) continue;
            try {
                String err = Props.readProperties(p, false);
                if (err == null) break;
                log.error(err);
            }
            catch (IOException e) {
                log.error("reload properties id=" + propId + " throws exception", e);
            }
            break;
        }
    }

    public static synchronized String readProperties(Prop f, boolean isCreate) throws IOException {
        if (f == null || f.getPath().length() == 0) {
            return null;
        }
        String id = f.getId();
        String path = f.getPath();
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        I18N i18n = cb.getLocales();
        String sufPro = ".properties";
        if (i18n != null) {
            for (Locale l : i18n.getLocale()) {
                String suffix1 = "_" + l.getLanguage() + "_" + l.getCountry();
                String tmpPath1 = path.replace(".properties", String.valueOf(suffix1) + ".properties");
                i18nIds.add(id);
                if (FileUtil.exists(String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + tmpPath1)) {
                    Prop p = new Prop();
                    p.setGlobal("false");
                    p.setId(String.valueOf(id) + suffix1);
                    p.setPath(tmpPath1);
                    Props.readProperties(p, false);
                    isCreate = false;
                    continue;
                }
                String suffix2 = "_" + l.getLanguage();
                String tmpPath2 = path.replace(".properties", String.valueOf(suffix2) + ".properties");
                if (!FileUtil.exists(String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + tmpPath2)) continue;
                Prop p = new Prop();
                p.setGlobal("false");
                p.setId(String.valueOf(id) + suffix2);
                p.setPath(tmpPath2);
                Props.readProperties(p, false);
                isCreate = false;
            }
        }
        String error = null;
        String filePath = String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + path;
        String global = f.getGlobal();
        Properties properties = new Properties();
        InputStream in = null;
        Hashtable<String, String> tmpHt = new Hashtable<String, String>();
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(filePath));
                properties.load(in);
                Props.loadProperty(properties, tmpHt);
                Pattern pattern = Pattern.compile("\\$\\{[-a-zA-Z0-9_\u4e00-\u9fa5\\.,;:\\|]+\\}");
                for (Map.Entry<String, String> e : tmpHt.entrySet()) {
                    String key = e.getKey();
                    String property = e.getValue();
                    Props.renderVarable(pattern, key, property, tmpHt);
                }
                if ("true".equalsIgnoreCase(global) || "1".equalsIgnoreCase(global)) {
                    globalMap.putAll(tmpHt);
                    log.debug("global | map -> " + tmpHt.toString());
                } else if (id != null && id.length() > 0) {
                    props.put(id, tmpHt);
                    log.debug("id -> " + id + " | map -> " + tmpHt.toString());
                }
            }
            catch (FileNotFoundException e) {
                log.warn(String.valueOf(filePath) + ", file not found!", e);
                if (isCreate) {
                    boolean flag = FileUtil.createFile(filePath);
                    if (flag) {
                        error = String.valueOf(filePath) + " create success";
                        Props.writeProperties(filePath, "framework", "eweb4j");
                        log.warn(error);
                    } else {
                        log.warn(String.valueOf(filePath) + " create fail");
                    }
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return error;
    }

    private static String renderVarable(Pattern pattern, String key, String property, Map<String, String> tmpHt) {
        if (property == null || key == null) {
            return null;
        }
        Matcher matcher = pattern.matcher(property);
        while (matcher.find()) {
            String value;
            String g = matcher.group();
            String _key = g.replace("${", "").replace("}", "");
            String result = Props.renderVarable(pattern, _key, value = tmpHt.get(_key), tmpHt);
            if (result != null) continue;
            String _property = tmpHt.get(key);
            if (_property != null && _property.trim().length() > 0) {
                tmpHt.put(key, _property.replace(g, tmpHt.get(_key)));
                continue;
            }
            tmpHt.put(key, property.replace(g, tmpHt.get(_key)));
        }
        return null;
    }

    private static void loadProperty(Properties properties, Hashtable<String, String> tmpHt) throws UnsupportedEncodingException {
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String property = properties.getProperty(key);
            if (property == null) continue;
            if (!property.matches("[\u4e00-\u9fa5]+")) {
                property = new String(property.getBytes("ISO-8859-1"), "UTF-8");
            }
            tmpHt.put(key, property);
        }
    }

    public static synchronized void write(String propId, String key, String value) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        Props.write(propId, data);
    }

    public static synchronized void write(String propId, Map<String, String> data) {
        try {
            Props.writeProp(propId, data);
        }
        catch (IOException e) {
            log.error("write property value to properties id=" + propId + " throws exception", e);
        }
    }

    public static synchronized void writeProp(String propId, Map<String, String> data) throws IOException {
        if (propId == null) {
            return;
        }
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        List<Prop> files = cb.getProperties().getFile();
        for (Prop f : files) {
            if (!propId.equals(f.getId())) continue;
            Map<String, String> map = props.get(propId);
            if (map == null) {
                map = new Hashtable<String, String>();
                props.put(propId, map);
            }
            map.putAll(data);
            String filePath = String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + f.getPath();
            Props.writeProperties(filePath, data);
            break;
        }
    }

    public static synchronized void writeProperties(String filePath, String key, String value) throws IOException {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        Props.writeProperties(filePath, data);
    }

    public static synchronized void remove(String propId, String key) {
        try {
            Props.removeProp(propId, key);
        }
        catch (IOException e) {
            log.error("remove property which key=" + key + " of file which id=" + propId + " throws exception", e);
        }
    }

    public static synchronized void removeProp(String propId, String key) throws IOException {
        if (propId == null) {
            return;
        }
        ConfigBean cb = (ConfigBean)SingleBeanCache.get(ConfigBean.class.getName());
        List<Prop> files = cb.getProperties().getFile();
        for (Prop f : files) {
            if (!propId.equals(f.getId())) continue;
            Map<String, String> map = props.get(propId);
            if (map == null) break;
            String filePath = String.valueOf(ConfigConstant.CONFIG_BASE_PATH) + f.getPath();
            Props.removeProperties(filePath, key);
            break;
        }
    }

    public static synchronized void removeProperties(String filePath, String key) throws IOException {
        Properties prop = new Properties();
        BufferedReader fis = null;
        BufferedWriter fos = null;
        try {
            try {
                fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "utf-8"));
                prop.load(fis);
                fos = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "utf-8"));
                prop.remove(key);
                prop.store(fos, "Last updated at " + CommonUtil.getNowTime() + " by EWeb4J");
                fos.flush();
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static synchronized void writeProperties(String filePath, Map<String, String> data) throws IOException {
        Properties prop = new Properties();
        BufferedReader fis = null;
        BufferedWriter fos = null;
        try {
            try {
                fis = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), "utf-8"));
                prop.load(fis);
                fos = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), "utf-8"));
                prop.putAll(data);
                prop.store(fos, "Last updated at " + CommonUtil.getNowTime() + " by EWeb4J");
                fos.flush();
            }
            catch (IOException e) {
                throw new IOException(e);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static Map<String, Map<String, String>> getProps() {
        return props;
    }

    public static Map<String, String> getGlobalMap() {
        return globalMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapProxy<K, V>
    implements Map<K, V> {
        private String id;

        private Map<K, V> map() {
            String _id = String.valueOf(this.id) + "_" + Lang.get().toString();
            if (props.containsKey(_id)) {
                return (Map)props.get(_id);
            }
            _id = String.valueOf(this.id) + "_" + Lang.get().getLanguage();
            if (props.containsKey(_id)) {
                return (Map)props.get(_id);
            }
            return (Map)props.get(this.id);
        }

        public MapProxy(String id) {
            this.id = id;
        }

        @Override
        public int size() {
            Map<K, V> map = this.map();
            return map == null ? null : Integer.valueOf(map.size());
        }

        @Override
        public boolean isEmpty() {
            Map<K, V> map = this.map();
            return map == null ? null : Boolean.valueOf(map.isEmpty());
        }

        @Override
        public boolean containsKey(Object key) {
            Map<K, V> map = this.map();
            return map == null ? null : Boolean.valueOf(map.containsKey(key));
        }

        @Override
        public boolean containsValue(Object value) {
            Map<K, V> map = this.map();
            return map == null ? null : Boolean.valueOf(map.containsValue(value));
        }

        @Override
        public V get(Object key) {
            Map<K, V> map = this.map();
            return map == null ? null : (V)map.get(key);
        }

        @Override
        public V put(K key, V value) {
            Map<K, V> map = this.map();
            return map == null ? null : (V)map.put(key, value);
        }

        @Override
        public V remove(Object key) {
            Map<K, V> map = this.map();
            return map == null ? null : (V)map.remove(key);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            Map<? extends K, ? extends V> map = this.map();
            if (map != null) {
                map.putAll(m);
            }
        }

        @Override
        public void clear() {
            Map<K, V> map = this.map();
            if (map != null) {
                map.clear();
            }
        }

        @Override
        public Set<K> keySet() {
            Map<K, V> map = this.map();
            return map == null ? null : map.keySet();
        }

        @Override
        public Collection<V> values() {
            Map<K, V> map = this.map();
            return map == null ? null : map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Map<K, V> map = this.map();
            return map == null ? null : map.entrySet();
        }
    }
}

