/*
 * Decompiled with CFR 0.152.
 */
package org.eweb4j.cache;

import java.util.Hashtable;
import org.eweb4j.config.Log;
import org.eweb4j.config.LogFactory;
import org.eweb4j.ioc.config.bean.IOCConfigBean;

public class IOCConfigBeanCache {
    private static Log log = LogFactory.getIOCLogger(IOCConfigBeanCache.class);
    private static final Hashtable<Object, IOCConfigBean> ht = new Hashtable();

    public static boolean containsKey(String beanID) {
        if (beanID == null) {
            return false;
        }
        return ht.containsKey(beanID);
    }

    public static void add(String beanID, IOCConfigBean o) {
        String info = null;
        if (!ht.containsKey(beanID)) {
            ht.put(beanID, o);
            info = "bean_id->" + beanID + ", Class->" + o.getClazz();
            log.debug(info);
        }
    }

    public static IOCConfigBean get(String beanID) {
        IOCConfigBean o = null;
        if (ht.containsKey(beanID)) {
            o = ht.get(beanID);
        }
        return o;
    }

    public static void clear() {
        if (!ht.isEmpty()) {
            ht.clear();
        }
    }
}

