/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.Version;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.ThrowableObjectInputStream;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ExceptionEvent;
import org.elasticsearch.common.netty.channel.MessageEvent;
import org.elasticsearch.common.netty.channel.SimpleChannelUpstreamHandler;
import org.elasticsearch.common.netty.channel.WriteCompletionEvent;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSerializationException;
import org.elasticsearch.transport.TransportServiceAdapter;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty.ChannelBufferStreamInputFactory;
import org.elasticsearch.transport.netty.NettyTransport;
import org.elasticsearch.transport.netty.NettyTransportChannel;
import org.elasticsearch.transport.support.TransportStatus;

public class MessageChannelHandler
extends SimpleChannelUpstreamHandler {
    protected final ESLogger logger;
    protected final ThreadPool threadPool;
    protected final TransportServiceAdapter transportServiceAdapter;
    protected final NettyTransport transport;
    protected final String profileName;

    public MessageChannelHandler(NettyTransport transport, ESLogger logger, String profileName) {
        this.threadPool = transport.threadPool();
        this.transportServiceAdapter = transport.transportServiceAdapter();
        this.transport = transport;
        this.logger = logger;
        this.profileName = profileName;
    }

    @Override
    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        this.transportServiceAdapter.sent(e.getWrittenAmount());
        super.writeComplete(ctx, e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        HandlesStreamInput wrappedStream;
        Transports.assertTransportThread();
        Object m = e.getMessage();
        if (!(m instanceof ChannelBuffer)) {
            ctx.sendUpstream(e);
            return;
        }
        ChannelBuffer buffer = (ChannelBuffer)m;
        int size = buffer.getInt(buffer.readerIndex() - 4);
        this.transportServiceAdapter.received(size + 6);
        boolean hasMessageBytesToRead = size - 13 != 0;
        int markedReaderIndex = buffer.readerIndex();
        int expectedIndexReader = markedReaderIndex + size;
        StreamInput streamIn = ChannelBufferStreamInputFactory.create(buffer, size);
        long requestId = buffer.readLong();
        byte status = buffer.readByte();
        Version version = Version.fromId(buffer.readInt());
        if (TransportStatus.isCompress(status) && hasMessageBytesToRead && buffer.readable()) {
            Compressor compressor = CompressorFactory.compressor(buffer);
            if (compressor == null) {
                int maxToRead = Math.min(buffer.readableBytes(), 10);
                int offset = buffer.readerIndex();
                StringBuilder sb = new StringBuilder("stream marked as compressed, but no compressor found, first [").append(maxToRead).append("] content bytes out of [").append(buffer.readableBytes()).append("] readable bytes with message size [").append(size).append("] ").append("] are [");
                for (int i = 0; i < maxToRead; ++i) {
                    sb.append(buffer.getByte(offset + i)).append(",");
                }
                sb.append("]");
                throw new ElasticsearchIllegalStateException(sb.toString());
            }
            wrappedStream = CachedStreamInput.cachedHandlesCompressed(compressor, streamIn);
        } else {
            wrappedStream = CachedStreamInput.cachedHandles(streamIn);
        }
        ((StreamInput)wrappedStream).setVersion(version);
        if (TransportStatus.isRequest(status)) {
            String action = this.handleRequest(ctx.getChannel(), wrappedStream, requestId, version);
            if (buffer.readerIndex() != expectedIndexReader) {
                if (buffer.readerIndex() < expectedIndexReader) {
                    this.logger.warn("Message not fully read (request) for requestId [{}], action [{}], readerIndex [{}] vs expected [{}]; resetting", requestId, action, buffer.readerIndex(), expectedIndexReader);
                } else {
                    this.logger.warn("Message read past expected size (request) for requestId=[{}], action [{}], readerIndex [{}] vs expected [{}]; resetting", requestId, action, buffer.readerIndex(), expectedIndexReader);
                }
                buffer.readerIndex(expectedIndexReader);
            }
        } else {
            TransportResponseHandler handler = this.transportServiceAdapter.onResponseReceived(requestId);
            if (handler != null) {
                if (TransportStatus.isError(status)) {
                    this.handlerResponseError(wrappedStream, handler);
                } else {
                    this.handleResponse(ctx.getChannel(), wrappedStream, handler);
                }
            } else {
                buffer.readerIndex(markedReaderIndex + size);
            }
            if (buffer.readerIndex() != expectedIndexReader) {
                if (buffer.readerIndex() < expectedIndexReader) {
                    this.logger.warn("Message not fully read (response) for [{}] handler {}, error [{}], resetting", requestId, handler, TransportStatus.isError(status));
                } else {
                    this.logger.warn("Message read past expected size (response) for [{}] handler {}, error [{}], resetting", requestId, handler, TransportStatus.isError(status));
                }
                buffer.readerIndex(expectedIndexReader);
            }
        }
        ((StreamInput)wrappedStream).close();
    }

    protected void handleResponse(Channel channel, StreamInput buffer, TransportResponseHandler handler) {
        Object response = handler.newInstance();
        ((TransportMessage)response).remoteAddress(new InetSocketTransportAddress((InetSocketAddress)channel.getRemoteAddress()));
        ((TransportMessage)response).remoteAddress();
        try {
            ((TransportMessage)response).readFrom(buffer);
        }
        catch (Throwable e) {
            this.handleException(handler, new TransportSerializationException("Failed to deserialize response of type [" + response.getClass().getName() + "]", e));
            return;
        }
        try {
            if ("same".equals(handler.executor())) {
                handler.handleResponse(response);
            } else {
                this.threadPool.executor(handler.executor()).execute(new ResponseHandler(handler, (TransportResponse)response));
            }
        }
        catch (Throwable e) {
            this.handleException(handler, new ResponseHandlerFailureTransportException(e));
        }
    }

    private void handlerResponseError(StreamInput buffer, TransportResponseHandler handler) {
        Throwable error;
        try {
            ThrowableObjectInputStream ois = new ThrowableObjectInputStream(buffer, this.transport.settings().getClassLoader());
            error = (Throwable)ois.readObject();
        }
        catch (Throwable e) {
            error = new TransportSerializationException("Failed to deserialize exception response from stream", e);
        }
        this.handleException(handler, error);
    }

    private void handleException(final TransportResponseHandler handler, Throwable error) {
        if (!(error instanceof RemoteTransportException)) {
            error = new RemoteTransportException(error.getMessage(), error);
        }
        final RemoteTransportException rtx = (RemoteTransportException)error;
        if ("same".equals(handler.executor())) {
            try {
                handler.handleException(rtx);
            }
            catch (Throwable e) {
                this.logger.error("failed to handle exception response [{}]", e, handler);
            }
        } else {
            this.threadPool.executor(handler.executor()).execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        handler.handleException(rtx);
                    }
                    catch (Throwable e) {
                        MessageChannelHandler.this.logger.error("failed to handle exception response [{}]", e, handler);
                    }
                }
            });
        }
    }

    protected String handleRequest(Channel channel, StreamInput buffer, long requestId, Version version) throws IOException {
        String action = buffer.readString();
        this.transportServiceAdapter.onRequestReceived(requestId, action);
        NettyTransportChannel transportChannel = new NettyTransportChannel(this.transport, this.transportServiceAdapter, action, channel, requestId, version, this.profileName);
        try {
            TransportRequestHandler handler = this.transportServiceAdapter.handler(action, version);
            if (handler == null) {
                throw new ActionNotFoundTransportException(action);
            }
            Object request = handler.newInstance();
            ((TransportMessage)request).remoteAddress(new InetSocketTransportAddress((InetSocketAddress)channel.getRemoteAddress()));
            ((TransportMessage)request).readFrom(buffer);
            if ("same".equals(handler.executor())) {
                handler.messageReceived(request, transportChannel);
            } else {
                this.threadPool.executor(handler.executor()).execute(new RequestHandler(handler, (TransportRequest)request, transportChannel, action));
            }
        }
        catch (Throwable e) {
            try {
                transportChannel.sendResponse(e);
            }
            catch (IOException e1) {
                this.logger.warn("Failed to send error message back to client for action [" + action + "]", e, new Object[0]);
                this.logger.warn("Actual Exception", e1, new Object[0]);
            }
        }
        return action;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.transport.exceptionCaught(ctx, e);
    }

    class RequestHandler
    extends AbstractRunnable {
        private final TransportRequestHandler handler;
        private final TransportRequest request;
        private final NettyTransportChannel transportChannel;
        private final String action;

        public RequestHandler(TransportRequestHandler handler, TransportRequest request, NettyTransportChannel transportChannel, String action) {
            this.handler = handler;
            this.request = request;
            this.transportChannel = transportChannel;
            this.action = action;
        }

        @Override
        protected void doRun() throws Exception {
            this.handler.messageReceived(this.request, this.transportChannel);
        }

        @Override
        public boolean isForceExecution() {
            return this.handler.isForceExecution();
        }

        @Override
        public void onFailure(Throwable e) {
            if (MessageChannelHandler.this.transport.lifecycleState() == Lifecycle.State.STARTED) {
                try {
                    this.transportChannel.sendResponse(e);
                }
                catch (Throwable e1) {
                    MessageChannelHandler.this.logger.warn("Failed to send error message back to client for action [" + this.action + "]", e1, new Object[0]);
                    MessageChannelHandler.this.logger.warn("Actual Exception", e, new Object[0]);
                }
            }
        }
    }

    class ResponseHandler
    implements Runnable {
        private final TransportResponseHandler handler;
        private final TransportResponse response;

        public ResponseHandler(TransportResponseHandler handler, TransportResponse response) {
            this.handler = handler;
            this.response = response;
        }

        @Override
        public void run() {
            try {
                this.handler.handleResponse(this.response);
            }
            catch (Throwable e) {
                MessageChannelHandler.this.handleException(this.handler, new ResponseHandlerFailureTransportException(e));
            }
        }
    }
}

