/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.HashMap;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.collect.ImmutableCollection;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.script.ScriptContext;
import org.elasticsearch.script.ScriptService;

public final class ScriptContextRegistry {
    static final ImmutableSet<String> RESERVED_SCRIPT_CONTEXTS = ScriptContextRegistry.reservedScriptContexts();
    private final ImmutableMap<String, ScriptContext> scriptContexts;

    ScriptContextRegistry(Iterable<ScriptContext.Plugin> customScriptContexts) {
        HashMap<String, ScriptContext> scriptContexts = Maps.newHashMap();
        for (ScriptContext.Standard scriptContext : ScriptContext.Standard.values()) {
            scriptContexts.put(scriptContext.getKey(), scriptContext);
        }
        for (ScriptContext.Plugin customScriptContext : customScriptContexts) {
            this.validateScriptContext(customScriptContext);
            ScriptContext previousContext = scriptContexts.put(customScriptContext.getKey(), customScriptContext);
            if (previousContext == null) continue;
            throw new ElasticsearchIllegalArgumentException("script context [" + customScriptContext.getKey() + "] cannot be registered twice");
        }
        this.scriptContexts = ImmutableMap.copyOf(scriptContexts);
    }

    ImmutableCollection<ScriptContext> scriptContexts() {
        return this.scriptContexts.values();
    }

    boolean isSupportedContext(ScriptContext scriptContext) {
        return this.scriptContexts.containsKey(scriptContext.getKey());
    }

    private void validateScriptContext(ScriptContext.Plugin scriptContext) {
        if (RESERVED_SCRIPT_CONTEXTS.contains(scriptContext.getPluginName())) {
            throw new ElasticsearchIllegalArgumentException("[" + scriptContext.getPluginName() + "] is a reserved name, it cannot be registered as a custom script context");
        }
        if (RESERVED_SCRIPT_CONTEXTS.contains(scriptContext.getOperation())) {
            throw new ElasticsearchIllegalArgumentException("[" + scriptContext.getOperation() + "] is a reserved name, it cannot be registered as a custom script context");
        }
    }

    private static ImmutableSet<String> reservedScriptContexts() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ScriptService.ScriptType scriptType : ScriptService.ScriptType.values()) {
            builder.add(scriptType.toString());
        }
        for (Enum enum_ : ScriptContext.Standard.values()) {
            builder.add(((ScriptContext.Standard)enum_).getKey());
        }
        ((ImmutableSet.Builder)builder.add("script")).add("engine");
        return builder.build();
    }
}

