/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.internal;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Names;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.FailedToResolveConfigException;

public class InternalSettingsPreparer {
    static final List<String> ALLOWED_SUFFIXES = ImmutableList.of(".yml", ".yaml", ".json", ".properties");
    public static final String SECRET_PROMPT_VALUE = "${prompt.secret}";
    public static final String TEXT_PROMPT_VALUE = "${prompt.text}";
    public static final String IGNORE_SYSTEM_PROPERTIES_SETTING = "config.ignore_system_properties";

    public static Tuple<Settings, Environment> prepareSettings(Settings pSettings, boolean loadConfigSettings) {
        return InternalSettingsPreparer.prepareSettings(pSettings, loadConfigSettings, null);
    }

    public static Tuple<Settings, Environment> prepareSettings(Settings pSettings, boolean loadConfigSettings, Terminal terminal) {
        Settings settings;
        String name;
        String[] ignorePrefixes = new String[]{"es.default.", "elasticsearch.default."};
        boolean useSystemProperties = pSettings.getAsBoolean(IGNORE_SYSTEM_PROPERTIES_SETTING, (Boolean)false) == false;
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.settingsBuilder().put(pSettings);
        if (useSystemProperties) {
            settingsBuilder.putProperties("elasticsearch.default.", System.getProperties()).putProperties("es.default.", System.getProperties()).putProperties("elasticsearch.", System.getProperties(), ignorePrefixes).putProperties("es.", System.getProperties(), ignorePrefixes);
        }
        settingsBuilder.replacePropertyPlaceholders();
        Environment environment = new Environment(settingsBuilder.build());
        if (loadConfigSettings) {
            boolean loadFromEnv = true;
            if (useSystemProperties) {
                if (Strings.hasText(System.getProperty("es.default.config"))) {
                    loadFromEnv = true;
                    settingsBuilder.loadFromUrl(environment.resolveConfig(System.getProperty("es.default.config")));
                }
                if (Strings.hasText(System.getProperty("es.config"))) {
                    loadFromEnv = false;
                    settingsBuilder.loadFromUrl(environment.resolveConfig(System.getProperty("es.config")));
                }
                if (Strings.hasText(System.getProperty("elasticsearch.config"))) {
                    loadFromEnv = false;
                    settingsBuilder.loadFromUrl(environment.resolveConfig(System.getProperty("elasticsearch.config")));
                }
            }
            if (loadFromEnv) {
                for (String allowedSuffix : ALLOWED_SUFFIXES) {
                    try {
                        settingsBuilder.loadFromUrl(environment.resolveConfig("elasticsearch" + allowedSuffix));
                    }
                    catch (FailedToResolveConfigException failedToResolveConfigException) {}
                }
            }
        }
        settingsBuilder.put(pSettings);
        if (useSystemProperties) {
            settingsBuilder.putProperties("elasticsearch.", System.getProperties(), ignorePrefixes).putProperties("es.", System.getProperties(), ignorePrefixes);
        }
        settingsBuilder.replacePropertyPlaceholders();
        for (Map.Entry entry : pSettings.getAsMap().entrySet()) {
            String setting = (String)entry.getKey();
            if (!setting.startsWith("force.")) continue;
            settingsBuilder.remove(setting);
            settingsBuilder.put(setting.substring("force.".length()), (String)entry.getValue());
        }
        settingsBuilder.replacePropertyPlaceholders();
        if (settingsBuilder.get("name") == null && (name = System.getProperty("name")) != null) {
            settingsBuilder.put("name", name);
        }
        if (settingsBuilder.get("cluster.name") == null) {
            settingsBuilder.put("cluster.name", ClusterName.DEFAULT.value());
        }
        if ((settings = InternalSettingsPreparer.replacePromptPlaceholders(settingsBuilder.build(), terminal)).get("name") == null) {
            String name2 = settings.get("node.name");
            settings = name2 == null || name2.isEmpty() ? ImmutableSettings.settingsBuilder().put(settings).put("name", Names.randomNodeName(environment.resolveConfig("names.txt"))).build() : ImmutableSettings.settingsBuilder().put(settings).put("name", name2).build();
        }
        environment = new Environment(settings);
        settingsBuilder = ImmutableSettings.settingsBuilder().put(settings);
        settingsBuilder.put("path.logs", Strings.cleanPath(environment.logsFile().getAbsolutePath()));
        settings = settingsBuilder.build();
        return new Tuple<Settings, Environment>(settings, environment);
    }

    static Settings replacePromptPlaceholders(Settings settings, Terminal terminal) {
        Iterator iter = ((ImmutableSet)settings.getAsMap().entrySet()).iterator();
        ImmutableSettings.Builder builder = ImmutableSettings.builder().classLoader(settings.getClassLoaderIfSet());
        block8: while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String value = (String)entry.getValue();
            String key = (String)entry.getKey();
            switch (value) {
                case "${prompt.secret}": {
                    String secretValue = InternalSettingsPreparer.promptForValue(key, terminal, true);
                    if (!Strings.hasLength(secretValue)) continue block8;
                    builder.put(key, secretValue);
                    continue block8;
                }
                case "${prompt.text}": {
                    String textValue = InternalSettingsPreparer.promptForValue(key, terminal, false);
                    if (!Strings.hasLength(textValue)) continue block8;
                    builder.put(key, textValue);
                    continue block8;
                }
            }
            builder.put(key, value);
        }
        return builder.build();
    }

    static String promptForValue(String key, Terminal terminal, boolean secret) {
        if (terminal == null) {
            throw new UnsupportedOperationException("found property [" + key + "] with value [" + (secret ? SECRET_PROMPT_VALUE : TEXT_PROMPT_VALUE) + "]. prompting for property values is only supported when running elasticsearch in the foreground");
        }
        if (secret) {
            return new String(terminal.readSecret("Enter value for [%s]: ", key));
        }
        return terminal.readText("Enter value for [%s]: ", key);
    }
}

