/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.action.fieldstats.FieldStats;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NumericIntegerAnalyzer;
import org.elasticsearch.index.codec.docvaluesformat.DocValuesFormatProvider;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;
import org.elasticsearch.index.similarity.SimilarityProvider;

public class IntegerFieldMapper
extends NumberFieldMapper<Integer> {
    public static final String CONTENT_TYPE = "integer";
    private Integer nullValue;
    private String nullValueAsString;

    protected IntegerFieldMapper(FieldMapper.Names names, int precisionStep, float boost, FieldType fieldType, Boolean docValues, Integer nullValue, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, PostingsFormatProvider postingsProvider, DocValuesFormatProvider docValuesProvider, SimilarityProvider similarity, FieldMapper.Loading normsLoading, @Nullable Settings fieldDataSettings, Settings indexSettings, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo) {
        super(names, precisionStep, boost, fieldType, docValues, ignoreMalformed, coerce, NumericIntegerAnalyzer.buildNamedAnalyzer(precisionStep), NumericIntegerAnalyzer.buildNamedAnalyzer(Integer.MAX_VALUE), postingsProvider, docValuesProvider, similarity, normsLoading, fieldDataSettings, indexSettings, multiFields, copyTo);
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return new FieldDataType("int");
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Integer value(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof BytesRef) {
            return Numbers.bytesToInt((BytesRef)value);
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    public BytesRef indexedValueForSearch(Object value) {
        BytesRefBuilder bytesRef = new BytesRefBuilder();
        NumericUtils.intToPrefixCoded((int)this.parseValue(value), (int)0, (BytesRefBuilder)bytesRef);
        return bytesRef.get();
    }

    private int parseValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof BytesRef) {
            return Integer.parseInt(((BytesRef)value).utf8ToString());
        }
        return Integer.parseInt(value.toString());
    }

    @Override
    public Query fuzzyQuery(String value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions) {
        int iValue = Integer.parseInt(value);
        int iSim = fuzziness.asInt();
        return NumericRangeQuery.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)(iValue - iSim), (Integer)(iValue + iSim), (boolean)true, (boolean)true);
    }

    @Override
    public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)(lowerTerm == null ? null : Integer.valueOf(this.parseValue(lowerTerm))), (Integer)(upperTerm == null ? null : Integer.valueOf(this.parseValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)(lowerTerm == null ? null : Integer.valueOf(this.parseValue(lowerTerm))), (Integer)(upperTerm == null ? null : Integer.valueOf(this.parseValue(upperTerm))), (boolean)includeLower, (boolean)includeUpper);
    }

    @Override
    public Filter rangeFilter(QueryParseContext parseContext, Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newIntRange((IndexNumericFieldData)parseContext.getForField(this), lowerTerm == null ? null : Integer.valueOf(this.parseValue(lowerTerm)), upperTerm == null ? null : Integer.valueOf(this.parseValue(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newIntRange((String)this.names.indexName(), (int)this.precisionStep, (Integer)this.nullValue, (Integer)this.nullValue, (boolean)true, (boolean)true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected void innerParseCreateField(ParseContext context, List<Field> fields) throws IOException {
        int value;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return;
                }
                value = this.nullValue;
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.nullValue == null) {
                        return;
                    }
                    value = this.nullValue;
                } else {
                    value = Integer.parseInt(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).intValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.names.fullName(), Integer.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.nullValue == null) {
                    return;
                }
                value = this.nullValue;
                if (this.nullValueAsString != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), this.nullValueAsString, boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Integer objValue = this.nullValue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = parser.intValue((Boolean)this.coerce.value());
                        continue;
                    }
                    if ("boost".equals(currentFieldName) || "_boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new ElasticsearchIllegalArgumentException("unknown property [" + currentFieldName + "]");
                }
                if (objValue == null) {
                    return;
                }
                value = objValue;
            } else {
                value = parser.intValue((Boolean)this.coerce.value());
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), parser.text(), boost);
                }
            }
        }
        this.addIntegerFields(context, fields, value, boost);
    }

    protected void addIntegerFields(ParseContext context, List<Field> fields, int value, float boost) {
        if (this.fieldType.indexed() || this.fieldType.stored()) {
            CustomIntegerNumericField field = new CustomIntegerNumericField((NumberFieldMapper)this, value, this.fieldType);
            field.setBoost(boost);
            fields.add(field);
        }
        if (this.hasDocValues()) {
            this.addDocValue(context, fields, value);
        }
    }

    protected Integer nullValue() {
        return this.nullValue;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((IntegerFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((IntegerFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.precisionStep != 8) {
            builder.field("precision_step", this.precisionStep);
        }
        if (includeDefaults || this.nullValue != null) {
            builder.field("null_value", this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", false);
        }
    }

    @Override
    public FieldStats stats(Terms terms, int maxDoc) throws IOException {
        long minValue = NumericUtils.getMinInt((Terms)terms);
        long maxValue = NumericUtils.getMaxInt((Terms)terms);
        return new FieldStats.Long(maxDoc, terms.getDocCount(), terms.getSumDocFreq(), terms.getSumTotalTermFreq(), minValue, maxValue);
    }

    public static class CustomIntegerNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final int number;
        private final NumberFieldMapper mapper;

        public CustomIntegerNumericField(NumberFieldMapper mapper, int number, FieldType fieldType) {
            super(mapper, number, fieldType);
            this.mapper = mapper;
            this.number = number;
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) throws IOException {
            if (this.fieldType().indexed()) {
                return this.mapper.popCachedStream().setIntValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Integer.toString(this.number);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.integerField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                if (propNode == null) {
                    throw new MapperParsingException("Property [null_value] cannot be null.");
                }
                builder.nullValue(XContentMapValues.nodeIntegerValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, IntegerFieldMapper> {
        protected Integer nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE), 8);
            this.builder = this;
        }

        public Builder nullValue(int nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public IntegerFieldMapper build(Mapper.BuilderContext context) {
            this.fieldType.setOmitNorms(this.fieldType.omitNorms() && this.boost == 1.0f);
            IntegerFieldMapper fieldMapper = new IntegerFieldMapper(this.buildNames(context), this.fieldType.numericPrecisionStep(), this.boost, this.fieldType, this.docValues, this.nullValue, this.ignoreMalformed(context), this.coerce(context), this.postingsProvider, this.docValuesProvider, this.similarity, this.normsLoading, this.fieldDataSettings, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final FieldType FIELD_TYPE = new FieldType(NumberFieldMapper.Defaults.FIELD_TYPE);
        public static final Integer NULL_VALUE;

        static {
            FIELD_TYPE.freeze();
            NULL_VALUE = null;
        }
    }
}

