/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.EngineConfig;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.engine.InternalEngine;
import org.elasticsearch.index.engine.ShadowEngine;
import org.elasticsearch.index.engine.SharedFSEngine;

public class InternalEngineFactory
implements EngineFactory {
    @Override
    public Engine newReadWriteEngine(EngineConfig config) {
        if (IndexMetaData.isOnSharedFilesystem(config.getIndexSettings())) {
            return new SharedFSEngine(config);
        }
        return new InternalEngine(config);
    }

    @Override
    public Engine newReadOnlyEngine(EngineConfig config) {
        return new ShadowEngine(config);
    }
}

