/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.codec.CodecService;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.indexing.ShardIndexingService;
import org.elasticsearch.index.merge.policy.MergePolicyProvider;
import org.elasticsearch.index.merge.scheduler.MergeSchedulerProvider;
import org.elasticsearch.index.settings.IndexSettingsService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesWarmer;
import org.elasticsearch.threadpool.ThreadPool;

public final class EngineConfig {
    private final ShardId shardId;
    private volatile boolean failOnMergeFailure = true;
    private volatile boolean failEngineOnCorruption = true;
    private volatile ByteSizeValue indexingBufferSize;
    private volatile ByteSizeValue versionMapSize;
    private volatile String versionMapSizeSetting;
    private final int indexConcurrency;
    private volatile boolean compoundOnFlush = true;
    private long gcDeletesInMillis = DEFAULT_GC_DELETES.millis();
    private volatile boolean enableGcDeletes = true;
    private final String codecName;
    private final boolean optimizeAutoGenerateId;
    private volatile boolean checksumOnMerge = true;
    private final ThreadPool threadPool;
    private final ShardIndexingService indexingService;
    private final IndexSettingsService indexSettingsService;
    @Nullable
    private final IndicesWarmer warmer;
    private final Store store;
    private final SnapshotDeletionPolicy deletionPolicy;
    private final Translog translog;
    private final MergePolicyProvider mergePolicyProvider;
    private final MergeSchedulerProvider mergeScheduler;
    private final Analyzer analyzer;
    private final Similarity similarity;
    private final CodecService codecService;
    private final Engine.FailedEngineListener failedEngineListener;
    public static final String INDEX_CONCURRENCY_SETTING = "index.index_concurrency";
    public static final String INDEX_COMPOUND_ON_FLUSH = "index.compound_on_flush";
    public static final String INDEX_OPTIMIZE_AUTOGENERATED_ID_SETTING = "index.optimize_auto_generated_id";
    public static final String INDEX_GC_DELETES_SETTING = "index.gc_deletes";
    public static final String INDEX_FAIL_ON_MERGE_FAILURE_SETTING = "index.fail_on_merge_failure";
    public static final String INDEX_FAIL_ON_CORRUPTION_SETTING = "index.fail_on_corruption";
    public static final String INDEX_BUFFER_SIZE_SETTING = "index.buffer_size";
    public static final String INDEX_CODEC_SETTING = "index.codec";
    public static final String INDEX_CHECKSUM_ON_MERGE = "index.checksum_on_merge";
    public static final String INDEX_VERSION_MAP_SIZE = "index.version_map_size";
    public static final TimeValue DEFAULT_REFRESH_INTERVAL = new TimeValue(1L, TimeUnit.SECONDS);
    public static final TimeValue DEFAULT_GC_DELETES = TimeValue.timeValueSeconds(60L);
    public static final ByteSizeValue DEFAUTL_INDEX_BUFFER_SIZE = new ByteSizeValue(64L, ByteSizeUnit.MB);
    public static final ByteSizeValue INACTIVE_SHARD_INDEXING_BUFFER = ByteSizeValue.parseBytesSizeValue("500kb");
    public static final String DEFAULT_VERSION_MAP_SIZE = "25%";
    private static final String DEFAULT_CODEC_NAME = "default";

    public EngineConfig(ShardId shardId, boolean optimizeAutoGenerateId, ThreadPool threadPool, ShardIndexingService indexingService, IndexSettingsService indexSettingsService, IndicesWarmer warmer, Store store, SnapshotDeletionPolicy deletionPolicy, Translog translog, MergePolicyProvider mergePolicyProvider, MergeSchedulerProvider mergeScheduler, Analyzer analyzer, Similarity similarity, CodecService codecService, Engine.FailedEngineListener failedEngineListener) {
        this.shardId = shardId;
        this.optimizeAutoGenerateId = optimizeAutoGenerateId;
        this.threadPool = threadPool;
        this.indexingService = indexingService;
        this.indexSettingsService = indexSettingsService;
        this.warmer = warmer;
        this.store = store;
        this.deletionPolicy = deletionPolicy;
        this.translog = translog;
        this.mergePolicyProvider = mergePolicyProvider;
        this.mergeScheduler = mergeScheduler;
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.codecService = codecService;
        this.failedEngineListener = failedEngineListener;
        Settings indexSettings = indexSettingsService.getSettings();
        this.compoundOnFlush = indexSettings.getAsBoolean(INDEX_COMPOUND_ON_FLUSH, (Boolean)this.compoundOnFlush);
        this.indexConcurrency = indexSettings.getAsInt(INDEX_CONCURRENCY_SETTING, (Integer)Math.max(8, (int)((double)EsExecutors.boundedNumberOfProcessors(indexSettings) * 0.65)));
        this.codecName = indexSettings.get(INDEX_CODEC_SETTING, DEFAULT_CODEC_NAME);
        this.indexingBufferSize = indexSettings.getAsBytesSize(INDEX_BUFFER_SIZE_SETTING, DEFAUTL_INDEX_BUFFER_SIZE);
        this.failEngineOnCorruption = indexSettings.getAsBoolean(INDEX_FAIL_ON_CORRUPTION_SETTING, (Boolean)true);
        this.failOnMergeFailure = indexSettings.getAsBoolean(INDEX_FAIL_ON_MERGE_FAILURE_SETTING, (Boolean)true);
        this.gcDeletesInMillis = indexSettings.getAsTime(INDEX_GC_DELETES_SETTING, DEFAULT_GC_DELETES).millis();
        this.versionMapSizeSetting = indexSettings.get(INDEX_VERSION_MAP_SIZE, DEFAULT_VERSION_MAP_SIZE);
        this.updateVersionMapSize();
    }

    private void updateVersionMapSize() {
        if (this.versionMapSizeSetting.endsWith("%")) {
            double percent = Double.parseDouble(this.versionMapSizeSetting.substring(0, this.versionMapSizeSetting.length() - 1));
            this.versionMapSize = new ByteSizeValue((long)((double)this.indexingBufferSize.bytes() * (percent / 100.0)));
        } else {
            this.versionMapSize = ByteSizeValue.parseBytesSizeValue(this.versionMapSizeSetting);
        }
    }

    public void setVersionMapSizeSetting(String versionMapSizeSetting) {
        this.versionMapSizeSetting = versionMapSizeSetting;
        this.updateVersionMapSize();
    }

    public String getVersionMapSizeSetting() {
        return this.versionMapSizeSetting;
    }

    public ByteSizeValue getVersionMapSize() {
        return this.versionMapSize;
    }

    public void setIndexingBufferSize(ByteSizeValue indexingBufferSize) {
        this.indexingBufferSize = indexingBufferSize;
        this.updateVersionMapSize();
    }

    public void setEnableGcDeletes(boolean enableGcDeletes) {
        this.enableGcDeletes = enableGcDeletes;
    }

    public boolean isFailOnMergeFailure() {
        return this.failOnMergeFailure;
    }

    public boolean isFailEngineOnCorruption() {
        return this.failEngineOnCorruption;
    }

    public ByteSizeValue getIndexingBufferSize() {
        return this.indexingBufferSize;
    }

    public int getIndexConcurrency() {
        return this.indexConcurrency;
    }

    public boolean isCompoundOnFlush() {
        return this.compoundOnFlush;
    }

    public long getGcDeletesInMillis() {
        return this.gcDeletesInMillis;
    }

    public boolean isEnableGcDeletes() {
        return this.enableGcDeletes;
    }

    public Codec getCodec() {
        return this.codecService.codec(this.codecName);
    }

    public boolean isOptimizeAutoGenerateId() {
        return this.optimizeAutoGenerateId;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public ShardIndexingService getIndexingService() {
        return this.indexingService;
    }

    @Nullable
    public IndicesWarmer getWarmer() {
        return this.warmer;
    }

    public Store getStore() {
        return this.store;
    }

    public SnapshotDeletionPolicy getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public Translog getTranslog() {
        return this.translog;
    }

    public MergePolicyProvider getMergePolicyProvider() {
        return this.mergePolicyProvider;
    }

    public MergeSchedulerProvider getMergeScheduler() {
        return this.mergeScheduler;
    }

    public Engine.FailedEngineListener getFailedEngineListener() {
        return this.failedEngineListener;
    }

    public Settings getIndexSettings() {
        return this.indexSettingsService.getSettings();
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public boolean isChecksumOnMerge() {
        return this.checksumOnMerge;
    }

    public void setGcDeletesInMillis(long gcDeletesInMillis) {
        this.gcDeletesInMillis = gcDeletesInMillis;
    }

    public void setCompoundOnFlush(boolean compoundOnFlush) {
        this.compoundOnFlush = compoundOnFlush;
    }

    public void setFailEngineOnCorruption(boolean failEngineOnCorruption) {
        this.failEngineOnCorruption = failEngineOnCorruption;
    }

    public void setFailOnMergeFailure(boolean failOnMergeFailure) {
        this.failOnMergeFailure = failOnMergeFailure;
    }

    public void setChecksumOnMerge(boolean checksumOnMerge) {
        this.checksumOnMerge = checksumOnMerge;
    }
}

