/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.delete;

import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.delete.ShardDeleteRequest;
import org.elasticsearch.action.delete.ShardDeleteResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.TransportShardReplicationOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardDeleteAction
extends TransportShardReplicationOperationAction<ShardDeleteRequest, ShardDeleteRequest, ShardDeleteResponse> {
    private static final String ACTION_NAME = "indices:data/write/delete[s]";

    @Inject
    public TransportShardDeleteAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters);
    }

    @Override
    protected boolean checkWriteConsistency() {
        return true;
    }

    @Override
    protected ShardDeleteRequest newRequestInstance() {
        return new ShardDeleteRequest();
    }

    @Override
    protected ShardDeleteRequest newReplicaRequestInstance() {
        return new ShardDeleteRequest();
    }

    @Override
    protected ShardDeleteResponse newResponseInstance() {
        return new ShardDeleteResponse();
    }

    @Override
    protected String executor() {
        return "index";
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    protected Tuple<ShardDeleteResponse, ShardDeleteRequest> shardOperationOnPrimary(ClusterState clusterState, TransportShardReplicationOperationAction.PrimaryOperationRequest shardRequest) {
        ShardDeleteRequest request = (ShardDeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRequest.shardId.getIndex()).shardSafe(shardRequest.shardId.id());
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version(), VersionType.INTERNAL, Engine.Operation.Origin.PRIMARY);
        indexShard.delete(delete);
        request.version(delete.version());
        if (request.refresh()) {
            try {
                indexShard.refresh("refresh_flag_delete");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ShardDeleteResponse response = new ShardDeleteResponse(delete.version(), delete.found());
        return new Tuple<ShardDeleteResponse, ShardDeleteRequest>(response, (ShardDeleteRequest)shardRequest.request);
    }

    @Override
    protected void shardOperationOnReplica(TransportShardReplicationOperationAction.ReplicaOperationRequest shardRequest) {
        ShardDeleteRequest request = (ShardDeleteRequest)shardRequest.request;
        IndexShard indexShard = this.indicesService.indexServiceSafe(shardRequest.shardId.getIndex()).shardSafe(shardRequest.shardId.id());
        Engine.Delete delete = indexShard.prepareDelete(request.type(), request.id(), request.version(), VersionType.INTERNAL, Engine.Operation.Origin.REPLICA);
        delete = new Engine.Delete(delete, VersionType.INTERNAL.versionTypeForReplicationAndRecovery());
        assert (delete.versionType().validateVersionForWrites(delete.version()));
        indexShard.delete(delete);
        if (request.refresh()) {
            try {
                indexShard.refresh("refresh_flag_delete");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected ShardIterator shards(ClusterState clusterState, TransportShardReplicationOperationAction.InternalRequest request) {
        GroupShardsIterator group = this.clusterService.operationRouting().broadcastDeleteShards(this.clusterService.state(), request.concreteIndex());
        for (ShardIterator shardIt : group) {
            if (shardIt.shardId().id() != ((ShardDeleteRequest)request.request()).shardId()) continue;
            return shardIt;
        }
        throw new ElasticsearchIllegalStateException("No shards iterator found for shard [" + ((ShardDeleteRequest)request.request()).shardId() + "]");
    }
}

