/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationResponse;
import org.elasticsearch.cluster.routing.ImmutableShardRouting;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.engine.CommitStats;
import org.elasticsearch.index.shard.IndexShard;

public class ShardStats
extends BroadcastShardOperationResponse
implements ToXContent {
    private ShardRouting shardRouting;
    CommonStats commonStats;
    @Nullable
    CommitStats commitStats;

    ShardStats() {
    }

    public ShardStats(IndexShard indexShard, ShardRouting shardRouting, CommonStatsFlags flags) {
        super(indexShard.shardId());
        this.shardRouting = shardRouting;
        this.commonStats = new CommonStats(indexShard, flags);
        this.commitStats = indexShard.commitStats();
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public CommonStats getStats() {
        return this.commonStats;
    }

    public CommitStats getCommitStats() {
        return this.commitStats;
    }

    public static ShardStats readShardStats(StreamInput in) throws IOException {
        ShardStats stats = new ShardStats();
        stats.readFrom(in);
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardRouting = ImmutableShardRouting.readShardRoutingEntry(in);
        this.commonStats = CommonStats.readCommonStats(in);
        if (in.getVersion().onOrAfter(Version.V_1_6_0)) {
            this.commitStats = CommitStats.readOptionalCommitStatsFrom(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardRouting.writeTo(out);
        this.commonStats.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_1_6_0)) {
            out.writeOptionalStreamable(this.commitStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.ROUTING).field(Fields.STATE, (Object)this.shardRouting.state()).field(Fields.PRIMARY, this.shardRouting.primary()).field(Fields.NODE, this.shardRouting.currentNodeId()).field(Fields.RELOCATING_NODE, this.shardRouting.relocatingNodeId()).endObject();
        this.commonStats.toXContent(builder, params);
        if (this.commitStats != null) {
            this.commitStats.toXContent(builder, params);
        }
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString ROUTING = new XContentBuilderString("routing");
        static final XContentBuilderString STATE = new XContentBuilderString("state");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString NODE = new XContentBuilderString("node");
        static final XContentBuilderString RELOCATING_NODE = new XContentBuilderString("relocating_node");

        Fields() {
        }
    }
}

