/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;

public class Log2LatencyBins {
    public static final int DEFAULT_SMALLEST_RESOLUTION = 16;
    public static final int DEFAULT_BIN_COUNT = 20;
    private final LongAdder[] bins;
    private final LongAdder counter = new LongAdder();
    private final String name;
    private final int binCount;
    private final int smallestResolutionPower;

    public Log2LatencyBins(String name) {
        this(name, 20, 16);
    }

    public Log2LatencyBins(String name, int binCount, int smallestResolutionPower) {
        if (name == null) {
            throw new IllegalArgumentException("Must have name.");
        }
        this.name = name;
        this.binCount = Math.max(2, Math.min(32, binCount));
        this.smallestResolutionPower = Math.max(2, Math.min(smallestResolutionPower, 63 - this.binCount));
        this.bins = new LongAdder[this.binCount];
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = new LongAdder();
        }
    }

    public void record(long ... latenciesInNanos) {
        for (long latency : latenciesInNanos) {
            this.bins[this.binIndexFor(latency)].increment();
            this.counter.increment();
        }
    }

    private int binIndexFor(long latencyInNanos) {
        int leadingZeros = 63 - Long.numberOfLeadingZeros(latencyInNanos) - this.smallestResolutionPower;
        if (leadingZeros <= 0) {
            return 0;
        }
        return Math.min(this.bins.length - 1, leadingZeros);
    }

    public int getSmallestResolutionPower() {
        return this.smallestResolutionPower;
    }

    public String toString() {
        return this.toString(ToString.NO_RANGES_AND_ZEROS);
    }

    public String toString(ToString formatting) {
        return this.toString(formatting, this.binCounts(), this.count());
    }

    public String toString(ToString formatting, long[] binCounts, long count) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append(" latencies: (");
        sb.append(count);
        if (!formatting.includeRanges()) {
            sb.append(" @ ");
            sb.append(Log2LatencyBins.niceDuration(this.nanosMaxForBin(0)));
        }
        sb.append(") [");
        boolean first = true;
        for (int i = 0; i < binCounts.length; ++i) {
            if (!formatting.includeZeros() && binCounts[i] <= 0L) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (formatting.includeRanges()) {
                long maxNS = this.nanosMaxForBin(i);
                sb.append(binCounts[i]);
                sb.append(" <=");
                sb.append(Log2LatencyBins.niceDuration(maxNS));
                continue;
            }
            sb.append(binCounts[i]);
        }
        sb.append("]");
        return sb.toString();
    }

    public long[] binCounts() {
        long[] ret = new long[this.bins.length];
        for (int i = 0; i < this.bins.length; ++i) {
            ret[i] = this.bins[i].longValue();
        }
        return ret;
    }

    public long count() {
        return this.counter.longValue();
    }

    public static String niceDuration(long ns) {
        if (ns < TimeUnit.MILLISECONDS.toNanos(1L) - 1L) {
            return ns + "ns";
        }
        if (ns < TimeUnit.SECONDS.toNanos(1L) - 1L) {
            return TimeUnit.NANOSECONDS.toMillis(ns) + "ms";
        }
        if (ns < TimeUnit.MINUTES.toNanos(1L) - 1L) {
            return TimeUnit.NANOSECONDS.toSeconds(ns) + "sec";
        }
        if (ns < TimeUnit.HOURS.toNanos(1L) - 1L) {
            return TimeUnit.NANOSECONDS.toMinutes(ns) + "min";
        }
        if (ns < TimeUnit.DAYS.toNanos(1L) - 1L) {
            return TimeUnit.NANOSECONDS.toHours(ns) + "hours";
        }
        return "infinity";
    }

    public long nanosMaxForBin(int index) {
        if (index < 0 || index >= this.bins.length) {
            throw new IllegalArgumentException();
        }
        if (index >= this.bins.length - 1) {
            return Long.MAX_VALUE;
        }
        long val = 1L << index + this.smallestResolutionPower;
        return val;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public void sloppyReset() {
        this.counter.reset();
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i].reset();
        }
    }

    public long nanosMinForBin(int index) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return 0L;
        }
        return this.nanosMaxForBin(index - 1) + 1L;
    }

    public Thread reporterThread(BooleanSupplier keepAlive, long delayInterval, TimeUnit delayUnits, long minNSToReport, Consumer<Log2LatencyBins> output) {
        Runnable runnable = this.reporterRunnable(keepAlive, delayInterval, delayUnits, minNSToReport, output);
        Thread ret = new Thread(() -> {
            try {
                delayUnits.sleep(delayInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            runnable.run();
        }, this.name + " latency watcher");
        ret.setDaemon(true);
        return ret;
    }

    public Runnable reporterRunnable(BooleanSupplier keepAlive, long delayInterval, TimeUnit delayUnits, long minNSToReport, Consumer<Log2LatencyBins> output) {
        if (minNSToReport <= 0L) {
            return () -> {
                do {
                    output.accept(this);
                    try {
                        delayUnits.sleep(delayInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                } while (keepAlive.getAsBoolean());
            };
        }
        int minIndex = this.binIndexFor(minNSToReport);
        return () -> {
            do {
                long[] binCounts = this.binCounts();
                boolean found = false;
                for (int i = minIndex; !found && i < binCounts.length; ++i) {
                    if (binCounts[i] <= 0L) continue;
                    found = true;
                }
                if (found) {
                    output.accept(this);
                }
                try {
                    Thread.sleep(delayUnits.toMillis(delayInterval));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            } while (keepAlive.getAsBoolean());
        };
    }

    public String getName() {
        return this.name;
    }

    public static enum ToString {
        NO_RANGES_AND_ZEROS(false, true),
        RANGES_AND_ZEROS(true, true),
        RANGES_NO_ZEROS(true, false);

        private final boolean includeRanges;
        private final boolean includeZeros;

        private ToString(boolean includeRanges, boolean includeZeros) {
            this.includeRanges = includeRanges;
            this.includeZeros = includeZeros;
        }

        public boolean includeRanges() {
            return this.includeRanges;
        }

        public boolean includeZeros() {
            return this.includeZeros;
        }
    }
}

