/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import kilim.KilimException;
import kilim.WeavingClassLoader;
import kilim.analysis.ClassInfo;
import kilim.analysis.ClassWeaver;
import kilim.analysis.FileLister;
import kilim.analysis.KilimContext;
import kilim.mirrors.CachedClassMirrors;

public class Weaver {
    public static String outputDir = null;
    public static boolean verbose = true;
    public static boolean force = false;
    public static boolean proxy = true;
    public static Pattern excludePattern = null;
    static int err = 0;
    public KilimContext context;

    public Weaver(KilimContext $context) {
        this.context = $context == null ? new KilimContext() : $context;
    }

    public static void main(String[] args) throws IOException {
        ArrayList<String> names = Weaver.parseArgs(args);
        Weaver.doMain(names.toArray(new String[0]), null);
        if (err > 0) {
            System.exit(err);
        }
    }

    private static String[] concat(String[] a, String[] b) {
        String[] c = new String[a.length + b.length];
        System.arraycopy(a, 0, c, 0, a.length);
        System.arraycopy(b, 0, c, a.length, b.length);
        return c;
    }

    public static int doMain(String[] names, String[] classpath) throws IOException {
        Weaver weaver;
        Weaver.mkdir(outputDir);
        if (proxy) {
            ClassLoader current = Weaver.class.getClassLoader();
            String[] composite = classpath == null ? names : Weaver.concat(names, classpath);
            URL[] paths = WeavingClassLoader.getURLs(composite);
            CachedClassMirrors ccm = new CachedClassMirrors(new URLClassLoader(paths, current));
            weaver = new Weaver(new KilimContext(ccm));
        } else {
            weaver = new Weaver(null);
        }
        String currentName = null;
        for (String name : names) {
            try {
                if (name.endsWith(".class")) {
                    if (Weaver.exclude(name)) continue;
                    currentName = name;
                    weaver.weaveFile(name, new BufferedInputStream(new FileInputStream(name)));
                    continue;
                }
                if (name.endsWith(".jar")) {
                    for (FileLister.Entry fe : new FileLister(name)) {
                        currentName = fe.getFileName();
                        if (!currentName.endsWith(".class") || Weaver.exclude(currentName = currentName.substring(0, currentName.length() - 6).replace('/', '.'))) continue;
                        weaver.weaveFile(currentName, fe.getInputStream());
                    }
                    continue;
                }
                if (new File(name).isDirectory()) {
                    for (FileLister.Entry fe : new FileLister(name)) {
                        currentName = fe.getFileName();
                        if (!currentName.endsWith(".class") || Weaver.exclude(currentName) || !force && fe.check(outputDir)) continue;
                        weaver.weaveFile(currentName, fe.getInputStream());
                    }
                    continue;
                }
                System.out.println("skipping class (support removed): " + name);
            }
            catch (KilimException ke) {
                System.err.println("Error weaving " + currentName + ". " + ke.getMessage());
                System.exit(1);
            }
            catch (IOException ioe) {
                System.err.println("Unable to find/process '" + currentName + "'");
                System.exit(1);
            }
            catch (Throwable t) {
                System.err.println("Error weaving " + currentName);
                t.printStackTrace();
                System.exit(1);
            }
        }
        return err;
    }

    static boolean exclude(String name) {
        return excludePattern == null ? false : excludePattern.matcher(name).find();
    }

    public ClassWeaver weave(InputStream is) {
        ClassWeaver cw = null;
        if (is == null) {
            return null;
        }
        try {
            cw = new ClassWeaver(this.context, is);
            cw.weave();
            if (outputDir != null) {
                Weaver.writeClasses(cw);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return cw;
    }

    public void weaveFile(String name, InputStream is) throws IOException {
        try {
            ClassWeaver cw = new ClassWeaver(this.context, is);
            cw.weave();
            Weaver.writeClasses(cw);
        }
        catch (KilimException ke) {
            System.err.println("***** Error weaving " + name + ". " + ke.getMessage());
            err = 1;
        }
        catch (RuntimeException re) {
            System.err.println("***** Error weaving " + name + ". " + re.getMessage());
            re.printStackTrace();
            err = 1;
        }
        catch (IOException ioe) {
            err = 1;
            System.err.println("***** Unable to find/process '" + name + "'\n" + ioe.getMessage());
        }
    }

    static void writeClasses(ClassWeaver cw) throws IOException {
        List<ClassInfo> cis = cw.getClassInfos();
        if (cis.size() > 0) {
            for (ClassInfo ci : cis) {
                Weaver.writeClass(ci);
            }
        }
    }

    public static void writeClass(ClassInfo ci) throws IOException {
        String className = ci.className.replace('.', File.separatorChar);
        String dir = outputDir + File.separatorChar + Weaver.getDirName(className);
        Weaver.mkdir(dir);
        className = outputDir + File.separatorChar + className + ".class";
        if (ci.className.startsWith("kilim.S_") && new File(className).exists()) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(className);
        fos.write(ci.bytes);
        fos.close();
        if (verbose) {
            System.out.println("Wrote: " + className);
        }
    }

    static void mkdir(String dir) throws IOException {
        File f = new File(dir);
        if (!f.exists() && !f.mkdirs()) {
            throw new IOException("Unable to create directory: " + dir);
        }
    }

    static String getDirName(String className) {
        int end = className.lastIndexOf(File.separatorChar);
        return end == -1 ? "" : className.substring(0, end);
    }

    static void help() {
        System.err.println("java kilim.tools.Weaver opts -d <outputDir> (class/directory/jar)+");
        System.err.println("   where opts are   -q : quiet");
        System.err.println("                    -x <regex> : exclude all classes matching regex");
        System.err.println("                    -f         : weave even if up to date");
        System.err.println("                    -c         : don't add targets to classpath");
        System.exit(1);
    }

    public static ArrayList<String> parseArgs(String[] args) throws IOException {
        if (args.length == 0) {
            Weaver.help();
        }
        ArrayList<String> ret = new ArrayList<String>(args.length);
        String regex = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-d")) {
                outputDir = args[++i];
                continue;
            }
            if (arg.equals("-q")) {
                verbose = false;
                continue;
            }
            if (arg.equals("-f")) {
                force = true;
                continue;
            }
            if (arg.equals("-c")) {
                proxy = false;
                continue;
            }
            if (arg.equals("-h")) {
                Weaver.help();
                continue;
            }
            if (arg.equals("-x")) {
                regex = args[++i];
                excludePattern = Pattern.compile(regex);
                continue;
            }
            ret.add(arg);
        }
        if (outputDir == null) {
            System.err.println("Specify output directory with -d option");
            System.exit(1);
        }
        return ret;
    }

    public List<ClassInfo> weave(List<ClassInfo> classes) throws KilimException, IOException {
        ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>(classes.size());
        for (ClassInfo cl : classes) {
            this.context.detector.mirrors.mirror(cl.bytes);
        }
        for (ClassInfo cl : classes) {
            ByteArrayInputStream is = new ByteArrayInputStream(cl.bytes);
            ClassWeaver cw = new ClassWeaver(this.context, is);
            cw.weave();
            ret.addAll(cw.getClassInfos());
        }
        return ret;
    }
}

