/*
 * Decompiled with CFR 0.152.
 */
package kilim.tools;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import kilim.analysis.Utils;
import kilim.tools.DummyAnnotationVisitor;
import kilim.tools.DumpMethodVisitor;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class DumpClass
extends ClassVisitor
implements Opcodes {
    static boolean lineNumbers = true;

    public static void main(String[] args) throws IOException {
        String name;
        String string = name = args.length == 2 ? args[1] : args[0];
        if (name.endsWith(".jar")) {
            try {
                Enumeration<JarEntry> e = new JarFile(name).entries();
                while (e.hasMoreElements()) {
                    ZipEntry en = e.nextElement();
                    String n = en.getName();
                    if (!n.endsWith(".class")) continue;
                    n = n.substring(0, n.length() - 6).replace('/', '.');
                    new DumpClass(n);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            new DumpClass(name);
        }
    }

    public DumpClass(InputStream is) throws IOException {
        super(458752);
        ClassReader cr = new ClassReader(is);
        cr.accept((ClassVisitor)this, 0);
    }

    public DumpClass(String className) throws IOException {
        super(458752);
        ClassReader cr;
        if (className.endsWith(".class")) {
            FileInputStream fis = new FileInputStream(className);
            cr = new ClassReader((InputStream)fis);
        } else {
            cr = new ClassReader(className);
        }
        cr.accept((ClassVisitor)this, 8);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Utils.p(".class ");
        Utils.p(Modifier.toString(access));
        Utils.p(" ");
        Utils.pn(name);
        if (superName != null) {
            Utils.pn(".super " + superName);
        }
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Utils.p(".implements ");
                Utils.pn(interfaces[i]);
            }
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Utils.pn(".annotation " + (visible ? "visible " : "") + desc);
        Utils.pn(".end annotation");
        return new DummyAnnotationVisitor();
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitEnd() {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Utils.p(".field ");
        Utils.p(Modifier.toString(access));
        Utils.p(" ");
        Utils.p(name);
        Utils.p(" ");
        Utils.p(desc);
        if (value != null) {
            Utils.p(" = ");
            if (value instanceof String) {
                Utils.pn("\"" + value + "\"");
            } else {
                Utils.pn(value.toString());
            }
        } else {
            Utils.pn();
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        Utils.pn("");
        Utils.pn("; -------------------------------------------------------------");
        Utils.p(".method ");
        Utils.p(Modifier.toString(access));
        Utils.p(" ");
        Utils.p(name);
        Utils.pn(desc);
        Utils.pn("; signature = " + signature);
        Utils.pn("; -------------------------------------------------------------\n");
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                Utils.p(".throws ");
                Utils.pn(exceptions[i]);
            }
        }
        return new DumpMethodVisitor();
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public void visitNestMember(String nestMember) {
    }

    public void visitNestHost(String nestHost) {
    }

    public void visitSource(String source, String debug) {
    }
}

